/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.graph.layout;

import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.hibernate.eclipse.graph.layout.DirectedGraphLayoutVisitor;
import org.hibernate.eclipse.graph.layout.GraphAnimation;
import org.hibernate.eclipse.graph.parts.ConfigurationEditPart;

public class GraphLayoutManager
extends AbstractLayout {
    private ConfigurationEditPart diagram;

    public GraphLayoutManager(ConfigurationEditPart diagram) {
        this.diagram = diagram;
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        container.validate();
        List children = container.getChildren();
        Rectangle result = new Rectangle().setLocation(container.getClientArea().getLocation());
        int i = 0;
        while (i < children.size()) {
            result.union(((IFigure)children.get(i)).getBounds());
            ++i;
        }
        result.resize(container.getInsets().getWidth(), container.getInsets().getHeight());
        return result.getSize();
    }

    public void layout(IFigure container) {
        GraphAnimation.recordInitialState(container);
        if (GraphAnimation.playbackState(container)) {
            return;
        }
        new DirectedGraphLayoutVisitor().layoutDiagram(this.diagram);
        this.diagram.resetModelBounds(null);
    }
}

