/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.graph.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import org.hibernate.cfg.Configuration;
import org.hibernate.eclipse.graph.model.PersistentClassViewAdapter;
import org.hibernate.eclipse.graph.model.TableViewAdapter;
import org.hibernate.mapping.PersistentClass;

public class ConfigurationViewAdapter
extends Observable {
    private final Configuration cfg;
    private Map<String, PersistentClassViewAdapter> persistentClasses;
    private List<TableViewAdapter> selectedTables;

    public ConfigurationViewAdapter(Configuration cfg) {
        this.cfg = cfg;
    }

    public List<PersistentClassViewAdapter> getPersistentClasses() {
        if (this.persistentClasses == null) {
            Iterator classMappings = this.cfg.getClassMappings();
            this.persistentClasses = new HashMap<String, PersistentClassViewAdapter>();
            while (classMappings.hasNext()) {
                PersistentClass clazz = (PersistentClass)classMappings.next();
                this.persistentClasses.put(clazz.getEntityName(), new PersistentClassViewAdapter(this, clazz));
            }
            for (PersistentClassViewAdapter element : this.persistentClasses.values()) {
                element.getSourceAssociations();
            }
        }
        return new ArrayList<PersistentClassViewAdapter>(this.persistentClasses.values());
    }

    public PersistentClassViewAdapter getPersistentClassViewAdapter(String associatedEntityName) {
        return this.persistentClasses.get(associatedEntityName);
    }

    public List<TableViewAdapter> getSelectedTables() {
        return this.selectedTables;
    }

    public Configuration getConfiguration() {
        return this.cfg;
    }

    public void setSelectedTables(List<TableViewAdapter> tables) {
        this.selectedTables = tables;
    }
}

