/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.hqleditor;

import java.util.ResourceBundle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.editors.text.TextEditorActionContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;
import org.hibernate.eclipse.console.QueryEditor;
import org.hibernate.eclipse.console.actions.ExecuteQueryAction;

public class HQLEditorActionContributor
extends TextEditorActionContributor {
    protected RetargetTextEditorAction contentAssistProposalAction;
    protected RetargetTextEditorAction contentAssistTipAction;
    protected RetargetTextEditorAction contentFormatAction;
    private ExecuteQueryAction executeHQLAction;

    public HQLEditorActionContributor() {
        ResourceBundle bundle = ResourceBundle.getBundle("org.hibernate.eclipse.console.HibernateConsoleMessages");
        this.contentAssistProposalAction = new RetargetTextEditorAction(bundle, "HQLEditor_ContentAssistProposal_");
        this.contentAssistTipAction = new RetargetTextEditorAction(bundle, "HQLEditor_ContentAssistTip_");
        this.contentFormatAction = new RetargetTextEditorAction(bundle, "HQLEditor_ContentFormat_");
        this.executeHQLAction = new ExecuteQueryAction();
    }

    public void contributeToMenu(IMenuManager mm) {
        IMenuManager editMenu = mm.findMenuUsingPath("edit");
        if (editMenu != null) {
            editMenu.add((IContributionItem)new Separator());
            editMenu.add((IAction)this.contentAssistProposalAction);
            editMenu.add((IAction)this.contentFormatAction);
            editMenu.add((IAction)this.contentAssistTipAction);
        }
    }

    public void setActiveEditor(IEditorPart targetEditor) {
        super.setActiveEditor(targetEditor);
        ITextEditor textEditor = null;
        if (targetEditor instanceof ITextEditor) {
            textEditor = (ITextEditor)targetEditor;
        }
        this.contentAssistProposalAction.setAction(this.getAction(textEditor, "ContentAssistProposal"));
        this.contentAssistTipAction.setAction(this.getAction(textEditor, "ContentAssistTip"));
        this.contentFormatAction.setAction(this.getAction(textEditor, "ContentFormat"));
        if (targetEditor instanceof QueryEditor) {
            this.executeHQLAction.setHibernateQueryEditor((QueryEditor)targetEditor);
        }
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        super.contributeToToolBar(toolBarManager);
    }

    public void init(IActionBars bars, IWorkbenchPage page) {
        super.init(bars, page);
        bars.setGlobalActionHandler("org.hibernate.eclipse.console.actions.ExecuteQueryAction", (IAction)this.executeHQLAction);
        bars.updateActionBars();
    }
}

