/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.launch;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.model.impl.ExporterFactory;
import org.hibernate.eclipse.console.model.impl.ExporterProperty;
import org.hibernate.eclipse.console.utils.DialogSelectionHelper;
import org.hibernate.util.xpl.StringHelper;

public class AddPropertyDialog
extends TitleAreaDialog {
    private final ExporterFactory ef;
    private final String selectedPropertyId;
    private final boolean flagEdit;
    private ComboViewer propertyCombo;
    private Control value;
    private Button addPathButton;
    private String propertyName;
    private String propertyValue;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            AddPropertyDialog.this.updateStatus();
        }
    };

    protected AddPropertyDialog(Shell parentShell, ExporterFactory ef, String selectedPropertyId, boolean flagEdit) {
        super(parentShell);
        this.ef = ef;
        this.selectedPropertyId = selectedPropertyId;
        this.flagEdit = flagEdit;
    }

    protected Control createDialogArea(Composite parent) {
        String dialogTitle = HibernateConsoleMessages.AddPropertyDialog_add_exporter_property;
        String editTitle = HibernateConsoleMessages.AddPropertyDialog_add_property_to;
        if (this.flagEdit) {
            dialogTitle = HibernateConsoleMessages.AddPropertyDialog_edit_exporter_property;
            editTitle = HibernateConsoleMessages.AddPropertyDialog_edit_property_to;
        }
        this.getShell().setText(dialogTitle);
        this.setTitle(String.valueOf(editTitle) + this.ef.getExporterDefinition().getDescription());
        Composite control = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(control, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(HibernateConsoleMessages.AddPropertyDialog_name);
        final Combo combo = new Combo(composite, 2052);
        GridData pgd = new GridData(768);
        pgd.horizontalSpan = 2;
        combo.setLayoutData((Object)pgd);
        combo.setFocus();
        combo.addModifyListener(this.modifyListener);
        this.propertyCombo = new ComboViewer(combo);
        combo.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000001 || e.keyCode == 0x1000002) {
                    AddPropertyDialog.this.propertyCombo.setSelection(AddPropertyDialog.this.propertyCombo.getSelection(), false);
                    return;
                }
                int i = 0;
                while (i < combo.getItemCount()) {
                    if (combo.getText().equals(combo.getItem(i))) {
                        if (combo.getSelectionIndex() != i) {
                            combo.select(i);
                            AddPropertyDialog.this.propertyCombo.setSelection(AddPropertyDialog.this.propertyCombo.getSelection(), false);
                        }
                        return;
                    }
                    ++i;
                }
                AddPropertyDialog.this.disposeBrowseButton();
                AddPropertyDialog.this.createTextValueComposite(2);
            }
        });
        if (this.flagEdit) {
            this.propertyCombo.getControl().setEnabled(false);
        }
        label = new Label(composite, 0);
        label.setText(HibernateConsoleMessages.AddPropertyDialog_value);
        this.value = new Text(composite, 2048);
        this.value.setLayoutData((Object)new GridData(768));
        ((Text)this.value).addModifyListener(this.modifyListener);
        this.initDefaultNames(this.ef, this.propertyCombo);
        return control;
    }

    private void initDefaultNames(ExporterFactory ef2, ComboViewer viewer) {
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            ExporterFactory localEf;

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.localEf = (ExporterFactory)newInput;
            }

            public void dispose() {
                this.localEf = null;
            }

            public Object[] getElements(Object inputElement) {
                Iterator<Map.Entry<String, ExporterProperty>> set = this.localEf.getDefaultExporterProperties().entrySet().iterator();
                ArrayList<ExporterProperty> values = new ArrayList<ExporterProperty>(4);
                while (set.hasNext()) {
                    Map.Entry<String, ExporterProperty> element = set.next();
                    ExporterProperty exporterProperty = this.localEf.getExporterProperty(element.getKey());
                    if (exporterProperty == null) continue;
                    values.add(exporterProperty);
                }
                return values.toArray(new ExporterProperty[values.size()]);
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getText(Object element) {
                ExporterProperty exporterProperty = (ExporterProperty)element;
                return exporterProperty.getDescriptionForLabel();
            }

            public Image getImage(Object element) {
                return null;
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            private SelectionListener getSelectionListener(ExporterProperty prop) {
                if (!"path".equals(prop.getType()) && !"directory".equals(prop.getType())) {
                    return null;
                }
                final boolean isPath = "path".equals(prop.getType());
                return new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }

                    public void widgetSelected(SelectionEvent e) {
                        String title = isPath ? HibernateConsoleMessages.ExporterSettingsTab_select_path : HibernateConsoleMessages.ExporterSettingsTab_select_dir;
                        String description = isPath ? HibernateConsoleMessages.ExporterSettingsTab_select_path2 : HibernateConsoleMessages.ExporterSettingsTab_select_dir2;
                        MessageDialog dialog = new MessageDialog(AddPropertyDialog.this.getShell(), title, null, description, 3, new String[]{HibernateConsoleMessages.CodeGenerationSettingsTab_filesystem, HibernateConsoleMessages.CodeGenerationSettingsTab_workspace, IDialogConstants.CANCEL_LABEL}, 1);
                        int answer = dialog.open();
                        String strPath = null;
                        if (answer == 0) {
                            DirectoryDialog dialog2 = new DirectoryDialog(AddPropertyDialog.this.getShell());
                            dialog2.setText(title);
                            dialog2.setMessage(description);
                            String dir = dialog2.open();
                            if (dir != null) {
                                strPath = dir;
                            }
                        } else if (answer == 1) {
                            IPath[] paths = DialogSelectionHelper.chooseFileEntries(AddPropertyDialog.this.getShell(), null, (IPath[])new Path[0], title, description, new String[0], isPath, true, false);
                            if (paths != null && paths.length > 0) {
                                strPath = paths[0].toOSString();
                                if (isPath) {
                                    int i = 1;
                                    while (i < paths.length) {
                                        strPath = String.valueOf(strPath) + ';' + paths[i].toOSString();
                                        ++i;
                                    }
                                }
                            }
                        } else {
                            return;
                        }
                        String oldPath = ((Text)AddPropertyDialog.this.value).getText();
                        if (isPath && oldPath.trim().length() > 0 && strPath != null) {
                            ((Text)AddPropertyDialog.this.value).setText(String.valueOf(oldPath) + ';' + strPath);
                        } else if (strPath != null) {
                            ((Text)AddPropertyDialog.this.value).setText(strPath);
                        }
                    }
                };
            }

            public void selectionChanged(SelectionChangedEvent event) {
                if (AddPropertyDialog.this.value == null) {
                    return;
                }
                IStructuredSelection iss = (IStructuredSelection)event.getSelection();
                if (!iss.isEmpty()) {
                    ExporterProperty prop = (ExporterProperty)iss.getFirstElement();
                    if ("boolean".equalsIgnoreCase(prop.getType())) {
                        AddPropertyDialog.this.disposeBrowseButton();
                        AddPropertyDialog.this.createComboValueComposite(new String[]{String.valueOf(true), String.valueOf(false)});
                        ((Combo)AddPropertyDialog.this.value).select(Boolean.valueOf(AddPropertyDialog.this.ef.getPropertyValue(prop.getName())) != false ? 0 : 1);
                    } else if ("directory".equalsIgnoreCase(prop.getType()) || "path".equalsIgnoreCase(prop.getType())) {
                        AddPropertyDialog.this.disposeBrowseButton();
                        AddPropertyDialog.this.createTextValueComposite(1);
                        ((Text)AddPropertyDialog.this.value).setText(AddPropertyDialog.this.ef.getPropertyValue(prop.getName()));
                        AddPropertyDialog.this.createBrowseButton(this.getSelectionListener(prop), prop);
                    } else {
                        AddPropertyDialog.this.disposeBrowseButton();
                        AddPropertyDialog.this.createTextValueComposite(2);
                        ((Text)AddPropertyDialog.this.value).setText(AddPropertyDialog.this.ef.getPropertyValue(prop.getName()));
                    }
                } else {
                    AddPropertyDialog.this.createTextValueComposite(2);
                }
            }
        });
        viewer.setInput((Object)this.ef);
        if (viewer.getCombo().getItemCount() > 0) {
            Object selected = null;
            selected = this.selectedPropertyId != null ? this.ef.getExporterProperty(this.selectedPropertyId) : viewer.getElementAt(0);
            viewer.setSelection((ISelection)new StructuredSelection(selected));
            viewer.getCombo().select(viewer.getCombo().getSelectionIndex());
        }
    }

    private void disposeBrowseButton() {
        if (this.addPathButton != null) {
            Composite parent = this.addPathButton.getParent();
            this.addPathButton.dispose();
            this.addPathButton = null;
            parent.layout();
        }
    }

    private void createBrowseButton(SelectionListener listener, ExporterProperty prop) {
        this.disposeBrowseButton();
        this.addPathButton = new Button(this.value.getParent(), 8);
        if ("path".equals(prop.getType())) {
            this.addPathButton.setText(HibernateConsoleMessages.AddPropertyDialog_add_path);
        } else {
            this.addPathButton.setText(HibernateConsoleMessages.AddPropertyDialog_browse);
        }
        this.addPathButton.setLayoutData((Object)new GridData(3));
        this.addPathButton.addSelectionListener(listener);
        this.value.getParent().layout();
    }

    private void createTextValueComposite(int span) {
        if (!(this.value instanceof Text)) {
            Composite parent = this.value.getParent();
            if (this.value != null) {
                this.value.dispose();
            }
            this.value = new Text(parent, 18436);
            ((Text)this.value).addModifyListener(this.modifyListener);
            GridData vgd = new GridData(768);
            vgd.horizontalSpan = span;
            this.value.setLayoutData((Object)vgd);
        } else {
            ((GridData)this.value.getLayoutData()).horizontalSpan = span;
            ((Text)this.value).setText("");
        }
        this.value.getParent().layout();
    }

    private void createComboValueComposite(String[] items) {
        if (!(this.value instanceof Combo)) {
            Composite parent = this.value.getParent();
            if (this.value != null) {
                this.value.dispose();
            }
            this.value = new Combo(parent, 18444);
            GridData bgd = new GridData(768);
            bgd.horizontalSpan = 2;
            this.value.setLayoutData((Object)bgd);
            ((Combo)this.value).setItems(items);
            ((Combo)this.value).addModifyListener(this.modifyListener);
            if (items != null && items.length > 0) {
                ((Combo)this.value).select(0);
            }
            parent.layout();
        }
    }

    void updateStatus() {
        this.getEnteredValues();
        boolean ok = false;
        if (StringHelper.isEmpty((String)this.getPropertyName())) {
            this.setMessage(HibernateConsoleMessages.AddPropertyDialog_the_property_name_must_be_chosen_or_entered, 3);
        } else if (this.getPropertyName().indexOf(32) >= 0 || this.getPropertyName().indexOf(9) >= 0) {
            this.setMessage(HibernateConsoleMessages.AddPropertyDialog_the_property_name_may_not_contain_whitespaces, 3);
        } else if (StringHelper.isEmpty((String)this.getPropertyValue())) {
            this.setMessage(HibernateConsoleMessages.AddPropertyDialog_the_property_value_must_be_non_empty, 3);
        } else {
            if (!this.flagEdit && this.ef.hasLocalValueFor(this.getPropertyName())) {
                String out = NLS.bind((String)HibernateConsoleMessages.AddPropertyDialog_the_property_is_already_set, (Object)this.getPropertyName());
                this.setMessage(out, 2);
            } else {
                this.setMessage(null, 3);
            }
            ok = true;
        }
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(ok);
        }
    }

    public String getPropertyValue() {
        return this.propertyValue;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    void getEnteredValues() {
        if (this.propertyCombo == null) {
            this.propertyName = null;
        } else {
            IStructuredSelection selection = (IStructuredSelection)this.propertyCombo.getSelection();
            if (selection.isEmpty()) {
                this.propertyName = this.propertyCombo.getCombo().getText();
            } else {
                ExporterProperty p = (ExporterProperty)selection.getFirstElement();
                this.propertyName = p.getName();
            }
        }
        if (this.value != null) {
            if (this.value instanceof Text) {
                this.propertyValue = ((Text)this.value).getText();
            } else if (this.value instanceof Combo) {
                this.propertyValue = ((Combo)this.value).getText();
            }
        } else {
            this.propertyValue = null;
        }
    }

    protected void okPressed() {
        this.getEnteredValues();
        super.okPressed();
    }

    public void create() {
        super.create();
        this.updateStatus();
    }
}

