/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.launch;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ui.wizards.NewCPWizard;
import org.eclipse.datatools.connectivity.internal.ui.wizards.NewCPWizardCategoryFilter;
import org.eclipse.datatools.connectivity.ui.wizards.NewConnectionProfileWizard;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;

public class ConnectionProfileCtrl {
    protected ComboViewer comboControl;
    protected Button buttonNew;
    protected Button buttonEdit;
    static final String NO_CONNECTIN_NAME = HibernateConsoleMessages.ConnectionProfileCtrl_HibernateConfiguredConnection;
    static final String JPA_CONNECTIN_NAME = HibernateConsoleMessages.ConnectionProfileCtrl_JPAConfiguredConnection;
    protected static final ConnectionWrapper NO_CONNECTION_PLACEHOLDER = new ConnectionWrapper(NO_CONNECTIN_NAME, null);
    protected static final ConnectionWrapper JPA_CONNECTION_PLACEHOLDER = new ConnectionWrapper(JPA_CONNECTIN_NAME, null);
    protected ArrayList<ModifyListener> modifyListeners = new ArrayList();

    public ConnectionProfileCtrl(Composite comp, int hspan, String defaultValue) {
        this.createComboWithTwoButtons(comp, hspan, defaultValue, new NewConnectionProfileAction(), new EditConnectionProfileAction());
    }

    public Composite createComboWithTwoButtons(Composite container, int hspan, String defaultValue, ButtonPressedAction action1, ButtonPressedAction action2) {
        Composite comp = SWTFactory.createComposite((Composite)container, (Font)container.getFont(), (int)3, (int)1, (int)1808, (int)0, (int)0);
        Combo combo = new Combo(comp, 12);
        combo.setBackground(Display.getDefault().getSystemColor(1));
        this.comboControl = new ComboViewer(combo);
        this.comboControl.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return ConnectionProfileCtrl.this.getProfileNameList().toArray();
            }
        });
        this.comboControl.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                ConnectionWrapper cw = (ConnectionWrapper)element;
                return cw.getId();
            }
        });
        this.comboControl.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConnectionProfileCtrl.this.buttonEdit.setEnabled(ConnectionProfileCtrl.this.getSelectedConnection().getProfile() != null);
                ConnectionProfileCtrl.this.notifyModifyListeners();
            }
        });
        combo.setLayoutData((Object)new GridData(768));
        this.buttonNew = new Button(comp, 8);
        this.buttonNew.setText(HibernateConsoleMessages.ConnectionProfileCtrl_New);
        this.buttonNew.addSelectionListener((SelectionListener)action1);
        this.buttonEdit = new Button(comp, 8);
        this.buttonEdit.setText(HibernateConsoleMessages.ConnectionProfileCtrl_Edit);
        this.buttonEdit.addSelectionListener((SelectionListener)action2);
        this.updateInput();
        return comp;
    }

    public void updateInput() {
        this.comboControl.setInput(this.getProfileNameList());
    }

    protected ConnectionWrapper findMatchingConnection(String name) {
        if (StringHelper.isEmpty((String)name)) {
            return NO_CONNECTION_PLACEHOLDER;
        }
        List<ConnectionWrapper> list = this.getProfileNameList();
        for (ConnectionWrapper object : list) {
            if (!name.equals(object.getId())) continue;
            return object;
        }
        return NO_CONNECTION_PLACEHOLDER;
    }

    public void selectValue(String name) {
        ConnectionWrapper connection = this.findMatchingConnection(name);
        this.comboControl.setSelection((ISelection)new StructuredSelection((Object)connection), true);
        this.comboControl.refresh();
        this.notifyModifyListeners();
    }

    private ConnectionWrapper getSelectedConnection() {
        StructuredSelection selection = (StructuredSelection)this.comboControl.getSelection();
        if (selection == null || selection.isEmpty()) {
            return NO_CONNECTION_PLACEHOLDER;
        }
        ConnectionWrapper cw = (ConnectionWrapper)selection.getFirstElement();
        return cw;
    }

    private String getSelectedId() {
        ConnectionWrapper cw = this.getSelectedConnection();
        return cw.getId();
    }

    protected void validate() {
    }

    private List<ConnectionWrapper> getProfileNameList() {
        IConnectionProfile[] profiles = ProfileManager.getInstance().getProfilesByCategory("org.eclipse.datatools.connectivity.db.category");
        ArrayList<ConnectionWrapper> names = new ArrayList<ConnectionWrapper>();
        names.add(JPA_CONNECTION_PLACEHOLDER);
        names.add(NO_CONNECTION_PLACEHOLDER);
        IConnectionProfile[] iConnectionProfileArray = profiles;
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionProfile connectionProfile = iConnectionProfileArray[n2];
            names.add(new ConnectionWrapper(connectionProfile.getName(), connectionProfile));
            ++n2;
        }
        return names;
    }

    public void setEnabled(boolean enabled) {
        this.comboControl.getControl().setEnabled(enabled);
        this.buttonNew.setEnabled(enabled);
        this.buttonEdit.setEnabled(enabled);
    }

    public void notifyModifyListeners() {
        int i = 0;
        while (i < this.modifyListeners.size()) {
            this.modifyListeners.get(i).modifyText(null);
            ++i;
        }
    }

    public void addModifyListener(ModifyListener listener) {
        this.modifyListeners.add(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.modifyListeners.remove(listener);
    }

    public String getSelectedConnectionName() {
        return this.getSelectedConnection().getId();
    }

    public boolean hasConnectionProfileSelected() {
        return this.getSelectedConnection().getProfile() != null;
    }

    public class ButtonPressedAction
    extends Action
    implements SelectionListener {
        public ButtonPressedAction(String label) {
            super(label);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            this.run();
        }
    }

    public class ConnectionProfileChangeListener
    implements IProfileListener {
        public void profileAdded(final IConnectionProfile profile) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ConnectionProfileCtrl.this.updateInput();
                    ConnectionProfileCtrl.this.selectValue(profile.getName());
                    ConnectionProfileCtrl.this.validate();
                }
            });
        }

        public void profileChanged(IConnectionProfile profile) {
            this.profileAdded(profile);
        }

        public void profileDeleted(IConnectionProfile profile) {
        }
    }

    private static class ConnectionWrapper {
        private final String id;
        private final IConnectionProfile profile;

        public ConnectionWrapper(String id, IConnectionProfile profile) {
            this.id = id;
            this.profile = profile;
        }

        public String getId() {
            return this.id;
        }

        public IConnectionProfile getProfile() {
            return this.profile;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ConnectionWrapper)) {
                return false;
            }
            ConnectionWrapper cw = (ConnectionWrapper)obj;
            return this.getId().equals(cw.getId());
        }

        public int hashCode() {
            return this.getId().hashCode();
        }
    }

    public class EditConnectionProfileAction
    extends ButtonPressedAction {
        public EditConnectionProfileAction() {
            super(HibernateConsoleMessages.ConnectionProfileCtrl_Edit);
        }

        public void run() {
            ConnectionWrapper currentConnection = ConnectionProfileCtrl.this.getSelectedConnection();
            if (currentConnection == null || currentConnection.getProfile() == null) {
                return;
            }
            IConnectionProfile selectedProfile = currentConnection.getProfile();
            PropertyDialog.createDialogOn((Shell)Display.getCurrent().getActiveShell(), (String)"org.eclipse.datatools.connectivity.db.generic.profileProperties", (Object)selectedProfile).open();
            if (!currentConnection.getId().equals(selectedProfile.getName())) {
                ConnectionProfileCtrl.this.updateInput();
                ConnectionProfileCtrl.this.selectValue(selectedProfile.getName());
            }
            ConnectionProfileCtrl.this.validate();
        }
    }

    public class NewConnectionProfileAction
    extends ButtonPressedAction {
        public NewConnectionProfileAction() {
            super(HibernateConsoleMessages.ConnectionProfileCtrl_New);
        }

        public void run() {
            ConnectionProfileChangeListener listener = new ConnectionProfileChangeListener();
            ProfileManager.getInstance().addProfileListener((IProfileListener)listener);
            NewCPWizardCategoryFilter filter = new NewCPWizardCategoryFilter("org.eclipse.datatools.connectivity.db.category");
            NewCPWizard wizard = new NewCPWizard((ViewerFilter)filter, null);
            new NewConnectionProfileWizard(){

                public boolean performFinish() {
                    try {
                        ProfileManager.getInstance().createProfile(this.getProfileName() == null ? "" : this.getProfileName(), this.getProfileDescription() == null ? "" : this.getProfileDescription(), this.mProviderID, this.getProfileProperties(), this.mProfilePage.getRepository() == null ? "" : this.mProfilePage.getRepository().getName(), false);
                    }
                    catch (ConnectionProfileException e) {
                        HibernateConsolePlugin.getDefault().log(e);
                    }
                    return true;
                }

                public void addCustomPages() {
                }

                public Properties getProfileProperties() {
                    return null;
                }
            };
            WizardDialog wizardDialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
            wizardDialog.open();
            ProfileManager.getInstance().removeProfileListener((IProfileListener)listener);
        }
    }
}

