/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.launch;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.hibernate.eclipse.console.model.impl.ExporterFactory;
import org.hibernate.eclipse.console.model.impl.ExporterProperty;

public class ExporterFactoryPropertySource
implements IPropertySource {
    private final ExporterFactory factory;

    public ExporterFactoryPropertySource(ExporterFactory factory) {
        this.factory = factory;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<TextPropertyDescriptor> descriptors = new ArrayList<TextPropertyDescriptor>();
        Map<String, String> values = this.factory.getProperties();
        for (String key : values.keySet()) {
            ExporterProperty element = this.factory.getExporterProperty(key);
            if (element != null) {
                descriptors.add(new TextPropertyDescriptor((Object)element.getName(), element.getDescription() == null ? element.getName() : element.getDescription()));
                continue;
            }
            descriptors.add(new TextPropertyDescriptor((Object)key, key));
        }
        return descriptors.toArray(new IPropertyDescriptor[0]);
    }

    public Object getPropertyValue(Object id) {
        String propertyValue = this.factory.getPropertyValue(id.toString());
        if (propertyValue == null) {
            return "";
        }
        return propertyValue;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        this.factory.setProperty(id.toString(), value.toString());
    }
}

