/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.launch.core.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.eclipse.launch.core.refactoring.Messages;

public class CodeGenerationConsoleNameChange
extends Change {
    private ILaunchConfiguration fLaunchConfiguration;
    private String newCCName;

    public CodeGenerationConsoleNameChange(ILaunchConfiguration launchConfiguration, String newCCName) {
        assert (KnownConfigurations.getInstance().isKnownConfiguration(launchConfiguration.getName()));
        this.fLaunchConfiguration = launchConfiguration;
        this.newCCName = newCCName;
    }

    public String getName() {
        return NLS.bind((String)Messages.CodeGenerationConsoleNameChange_update, (Object)this.fLaunchConfiguration.getName());
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.fLaunchConfiguration.getAttribute("org.hibernate.tools.configurationname", null) == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.CodeGenerationConsoleNameChange_error_null_confi);
        }
        if (this.newCCName == null || this.newCCName.trim().length() == 0) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.CodeGenerationConsoleNameChange_error_empty_name);
        }
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        String oldName = this.fLaunchConfiguration.getAttribute("org.hibernate.tools.configurationname", new String());
        ILaunchConfigurationWorkingCopy wc = this.fLaunchConfiguration.getWorkingCopy();
        wc.setAttribute("org.hibernate.tools.configurationname", this.newCCName);
        ILaunchConfiguration newLaunchConfig = wc.doSave();
        return new CodeGenerationConsoleNameChange(newLaunchConfig, oldName);
    }

    public Object getModifiedElement() {
        return this.fLaunchConfiguration;
    }
}

