/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.launch.core.refactoring;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.eclipse.launch.core.refactoring.CodeGenerationConsoleNameChange;
import org.hibernate.eclipse.launch.core.refactoring.HibernateRefactoringUtil;
import org.hibernate.eclipse.launch.core.refactoring.Messages;
import org.hibernate.eclipse.launch.core.refactoring.ProjectDefaultConfigurationChange;

public class ConsoleConfigurationRenameParticipant
extends RenameParticipant {
    private String oldName;

    protected boolean initialize(Object element) {
        if (element instanceof ILaunchConfiguration) {
            this.oldName = ((ILaunchConfiguration)element).getName();
            return KnownConfigurations.getInstance().isKnownConfiguration(this.oldName);
        }
        return false;
    }

    public String getName() {
        return Messages.ConsoleConfigurationRenameParticipant_name;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange change = new CompositeChange(Messages.ConsoleConfigurationRenameParticipant_change_name);
        change.markAsSynthetic();
        CompositeChange change1 = new CompositeChange(Messages.ConsoleConfigurationRenameParticipant_update_code_generations);
        change1.addAll(this.getCodeGenerationConsoleNameChanges());
        CompositeChange change2 = new CompositeChange(Messages.ConsoleConfigurationRenameParticipant_update_project_config);
        change2.addAll(this.getProjectDefaultConfigurationChanges());
        change.add((Change)change1);
        change.add((Change)change2);
        return change;
    }

    private Change[] getCodeGenerationConsoleNameChanges() {
        ILaunchConfiguration[] affectedConfigurations = HibernateRefactoringUtil.getAffectedCodeGenerationConfigs(this.oldName);
        Change[] changes = new Change[affectedConfigurations.length];
        int i = 0;
        while (i < affectedConfigurations.length) {
            changes[i] = new CodeGenerationConsoleNameChange(affectedConfigurations[i], this.getArguments().getNewName());
            ++i;
        }
        return changes;
    }

    private Change[] getProjectDefaultConfigurationChanges() {
        IProject[] affectedProjects = HibernateRefactoringUtil.getAffectedProjects(this.oldName);
        Change[] changes = new Change[affectedProjects.length];
        int i = 0;
        while (i < affectedProjects.length) {
            changes[i] = new ProjectDefaultConfigurationChange(affectedProjects[i], this.getArguments().getNewName());
            ++i;
        }
        return changes;
    }
}

