/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.launch.core.refactoring;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.launch.core.refactoring.CodeGenerationResourceNameChange;
import org.hibernate.eclipse.launch.core.refactoring.HibernateRefactoringUtil;
import org.hibernate.eclipse.launch.core.refactoring.LaunchConfigurationResourceNameChange;

public class MoveResourceParticipant
extends MoveParticipant {
    private IResource fResource;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        ILaunchConfiguration[] configs = HibernateRefactoringUtil.getAffectedConsoleConfigs(this.fResource.getFullPath());
        ArrayList<Change> changes = new ArrayList<Change>();
        Change change = null;
        int i = 0;
        while (i < configs.length) {
            change = new LaunchConfigurationResourceNameChange(configs[i], this.fResource.getFullPath(), ((IResource)this.getArguments().getDestination()).getFullPath().append(this.fResource.getName()));
            changes.add(change);
            ++i;
        }
        configs = HibernateRefactoringUtil.getAffectedCodeGenerationConfigs(this.fResource.getFullPath());
        i = 0;
        while (i < configs.length) {
            change = new CodeGenerationResourceNameChange(configs[i], this.fResource.getFullPath(), ((IResource)this.getArguments().getDestination()).getFullPath().append(this.fResource.getName()));
            changes.add(change);
            ++i;
        }
        return HibernateRefactoringUtil.createChangesFromList(changes, this.getName());
    }

    public String getName() {
        return HibernateConsoleMessages.MoveResourceParticipant_launch_configurations_updates;
    }

    protected boolean initialize(Object element) {
        this.fResource = (IResource)element;
        return true;
    }
}

