/*
 * Decompiled with CFR 0.152.
 */
package org.eclemma.runtime.equinox.internal;

import com.vladium.emma.data.CoverageOptions;
import com.vladium.emma.data.CoverageOptionsFactory;
import com.vladium.emma.data.DataFactory;
import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.data.IMetaData;
import com.vladium.emma.data.ISessionData;
import com.vladium.emma.data.SessionData;
import com.vladium.emma.filter.IInclExclFilter;
import com.vladium.emma.instr.InstrVisitor;
import com.vladium.emma.rt.RT;
import com.vladium.emma.rt.RTSettings;
import com.vladium.jcd.cls.ClassDef;
import com.vladium.jcd.compiler.ClassWriter;
import com.vladium.jcd.parser.ClassDefParser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.eclemma.runtime.equinox.ICoverageAnalyzer;
import org.eclemma.runtime.equinox.internal.PropertyUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class EMMAAnalyzer
implements ICoverageAnalyzer {
    private static final String PREFIX = "emma.";
    private static final String SESSION_OUT_FILE = "emma.session.out.file";
    private static final String SESSION_OUT_MERGE = "emma.session.out.merge";
    private static final String INCL_EXCL_FILTER = "emma.filter";
    private static final String SHOW_HELP = "eclemma.help";
    private static final String INSTRUMENT_BUNDLES = "eclemma.instrument.bundles";
    private BundleContext bundleContext;
    private CoverageOptions options;
    private IMetaData metadata;
    private boolean started;
    private List bundlesToInstrument;
    private IInclExclFilter filter;

    public void start(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        System.out.println("Running Equinox with emma code coverage. (Add -Declemma.help for more information)");
        this.printHelpOptions();
        RTSettings.setStandaloneMode((boolean)false);
        RT.reset((boolean)true, (boolean)false);
        this.options = CoverageOptionsFactory.create((Properties)System.getProperties());
        this.filter = IInclExclFilter.Factory.create((String[])PropertyUtils.toArray(System.getProperty(INCL_EXCL_FILTER)));
        this.metadata = DataFactory.newMetaData((CoverageOptions)this.options);
        String instrumentBundles = System.getProperty(INSTRUMENT_BUNDLES);
        this.bundlesToInstrument = PropertyUtils.toList(instrumentBundles);
        System.out.println("Covering the bundles with symbolic name(s): " + (instrumentBundles != null ? instrumentBundles : " no bundles specified (for example: -Declemma.instrument.bundles=org.eclipse.swt). So instrumenting all then"));
        this.started = true;
    }

    public void stop() {
        this.collectMetaData();
        this.started = false;
        ICoverageData coveragedata = RT.getCoverageData();
        try {
            this.writeSessionData(this.metadata, coveragedata);
        }
        catch (IOException e) {
            System.err.println("Error while writing the session file");
            e.printStackTrace();
        }
    }

    public byte[] instrument(String bundleid, String classname, byte[] bytes) {
        if (this.started) {
            try {
                ClassDef classdef = ClassDefParser.parseClass((byte[])bytes);
                InstrVisitor.InstrResult result = this.process(classdef, true);
                if (result.m_instrumented) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream(bytes.length * 2);
                    ClassWriter.writeClassTable((ClassDef)classdef, (OutputStream)out);
                    return out.toByteArray();
                }
            }
            catch (Exception ex) {
                System.err.println("Error while instrumenting " + classname + " in bundle " + bundleid);
                ex.printStackTrace();
            }
        }
        return null;
    }

    public String getRuntimePackages() {
        return "com.vladium.emma.rt";
    }

    public boolean shouldInstrumentClassesInBundle(String symbolicName) {
        return this.getBundlesToInstrument().contains(symbolicName) || this.getBundlesToInstrument().isEmpty();
    }

    private void collectMetaData() {
        Bundle[] allBundles = this.bundleContext.getBundles();
        ArrayList instrumentBundles = new ArrayList(this.getBundlesToInstrument());
        int i = 0;
        while (i < allBundles.length) {
            Bundle bundle = allBundles[i];
            if (this.shouldInstrumentClassesInBundle(bundle.getSymbolicName())) {
                instrumentBundles.remove(bundle.getSymbolicName());
                this.collectMetaData(bundle);
            }
            ++i;
        }
        if (!instrumentBundles.isEmpty()) {
            System.err.println("Could not instrument all bundles as they were not in the bundle context: " + PropertyUtils.listToString(instrumentBundles));
            throw new RuntimeException("Could not instrument all bundles as they were not in the bundle context: " + PropertyUtils.listToString(instrumentBundles));
        }
    }

    private void collectMetaData(Bundle bundle) {
        System.out.println("Collecting coverage Meta data for bundle " + bundle.getSymbolicName());
        Enumeration entries = bundle.findEntries("/", "*.class", true);
        while (entries != null && entries.hasMoreElements()) {
            URL url = (URL)entries.nextElement();
            try {
                ClassDef classdef = ClassDefParser.parseClass((InputStream)url.openStream());
                if (this.metadata.hasDescriptor(classdef.getName())) continue;
                this.process(classdef, false);
            }
            catch (IOException e) {
                System.err.println("Error while opening resource " + url + " in bundle " + bundle.getSymbolicName());
                e.printStackTrace();
            }
        }
    }

    private InstrVisitor.InstrResult process(ClassDef classdef, boolean instrument) {
        InstrVisitor.InstrResult result = new InstrVisitor.InstrResult();
        if (this.filter == null || this.filter.included(classdef.getName().replace('/', '.'))) {
            InstrVisitor visitor = new InstrVisitor(this.options);
            visitor.process(classdef, false, instrument, true, result);
            if (result.m_descriptor != null) {
                this.metadata.add(result.m_descriptor, true);
            }
        }
        return result;
    }

    private void writeSessionData(IMetaData metadata, ICoverageData coveragedata) throws IOException {
        String fileName = System.getProperty(SESSION_OUT_FILE, "coverage.es");
        System.out.println("Saving session data to: " + fileName);
        File file = new File(fileName);
        new File(file.getParent()).mkdirs();
        DataFactory.persist((ISessionData)new SessionData(metadata, coveragedata), (File)file, (boolean)this.shouldMerge());
    }

    private boolean shouldMerge() {
        return new Boolean(System.getProperty(SESSION_OUT_MERGE, "true"));
    }

    private List getBundlesToInstrument() {
        return this.bundlesToInstrument;
    }

    private void printHelpOptions() {
        if (System.getProperty(SHOW_HELP) != null) {
            System.out.println("---------------------------------------------------------------------------------------------------------------------------------------");
            System.out.println("Options: eclemma.instrument.bundles, emma.session.out.file, emma.session.out.merge, emma.filter");
            this.printOption(INSTRUMENT_BUNDLES, "list all symbolic names of bundles you want coverered, separated with , (comma) (if eclemma.instrument.bundles is not specified all bundles will be instrumented)");
            this.printOption(SESSION_OUT_FILE, "the file to put the output of the session in (c:\\myCoverage\\coverage.es)");
            this.printOption(SESSION_OUT_MERGE, "true if it should merge and false if it should not merge with existing session.out.file (default is true)");
            this.printOption(INCL_EXCL_FILTER, "filter when covering files, see emma documentation for details. (remember - for exclude and + for include)");
            System.out.println("    Example 1: -Declemma.instrument.bundles=org.eclipse.swt -Demma.session.out.merge=false");
            System.out.println("    Example 2: -Declemma.instrument.bundles=org.eclipse.swt,org.eclipse.jface -Demma.session.out.file=c:/swt-jface-coverage.es");
            System.out.println("    Example 2: -Declemma.instrument.bundles=org.eclipse.swt,org.eclipse.jface -Demma.session.out.file=c:/swt-jface-coverage.es -D+emma.filter=-*Test*");
            System.out.println("---------------------------------------------------------------------------------------------------------------------------------------");
        }
    }

    private void printOption(String property, String description) {
        System.out.println("  - " + property + ": " + description);
    }
}

