/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.jboss.forge.shell.CompositeClassLoader;
import org.jboss.forge.shell.InstalledPluginRegistry;
import org.jboss.forge.shell.ModularWeld;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.events.AcceptUserInput;
import org.jboss.forge.shell.events.PostStartup;
import org.jboss.forge.shell.events.PreStartup;
import org.jboss.forge.shell.events.ReinitializeEnvironment;
import org.jboss.forge.shell.events.Shutdown;
import org.jboss.forge.shell.events.Startup;
import org.jboss.modules.ConcurrentClassLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.weld.environment.se.WeldContainer;

public class Bootstrap {
    public static final String PROP_PLUGIN_DIR = "org.jboss.forge.pluginDir";
    public static final String PROP_EVALUATE = "org.jboss.forge.evaluate";
    private static final String ARG_PLUGIN_DIR = "-pluginDir";
    private static final String ARG_EVALUATE = "-e";
    private static boolean pluginSystemEnabled = !Boolean.getBoolean("forge.plugins.disable");
    private static Thread currentShell = null;
    private static boolean restartRequested = false;
    private static File workingDir = new File("").getAbsoluteFile();
    private static ClassLoader mainClassLoader;
    @Inject
    private BeanManager manager;

    public static void main(String[] args) {
        mainClassLoader = Thread.currentThread().getContextClassLoader();
        Bootstrap.readArguments(args);
        Bootstrap.init();
    }

    private static void readArguments(String[] args) {
        Bootstrap.readPluginDirArgument(args);
        Bootstrap.readEvaluateArgument(args);
    }

    private static void readPluginDirArgument(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!ARG_PLUGIN_DIR.equals(args[i]) || i + 1 >= args.length) continue;
            System.setProperty(PROP_PLUGIN_DIR, args[i + 1]);
            return;
        }
    }

    private static void readEvaluateArgument(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!ARG_EVALUATE.equals(args[i]) || i + 1 >= args.length) continue;
            System.setProperty(PROP_EVALUATE, args[i + 1]);
            return;
        }
    }

    private static void init() {
        do {
            currentShell = new Thread(new Runnable(){

                @Override
                public void run() {
                    WeldContainer container;
                    Bootstrap.initLogging();
                    boolean restarting = restartRequested;
                    restartRequested = false;
                    ModularWeld weld = new ModularWeld();
                    BeanManager manager = null;
                    try {
                        container = weld.initialize();
                        manager = container.getBeanManager();
                        weld.shutdown();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        Bootstrap.loadPlugins();
                        container = weld.initialize();
                        manager = container.getBeanManager();
                    }
                    catch (Throwable e) {
                        System.out.println("Plugin system disabled due to failure while loading one or more plugins; try removing offending plugins with \"forge remove-plugin <TAB>\".");
                        e.printStackTrace();
                        Thread.currentThread().setContextClassLoader(mainClassLoader);
                        Bootstrap.initLogging();
                        WeldContainer container2 = weld.initialize();
                        manager = container2.getBeanManager();
                    }
                    manager.fireEvent((Object)new PreStartup(), new Annotation[0]);
                    manager.fireEvent((Object)new Startup(workingDir, restarting), new Annotation[0]);
                    manager.fireEvent((Object)new PostStartup(), new Annotation[0]);
                    manager.fireEvent((Object)new AcceptUserInput(), new Annotation[0]);
                    weld.shutdown();
                }
            });
            currentShell.start();
            try {
                currentShell.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        } while (restartRequested);
    }

    public void observeReinitialize(@Observes ReinitializeEnvironment event, Shell shell) {
        workingDir = shell.getCurrentDirectory().getUnderlyingResourceObject();
        this.manager.fireEvent((Object)new Shutdown(), new Annotation[0]);
        restartRequested = true;
    }

    private static void initLogging() {
        String[] loggerNames;
        for (String loggerName : loggerNames = new String[]{"", "main", "global"}) {
            Handler[] handlers;
            Logger globalLogger = Logger.getLogger(loggerName);
            for (Handler handler : handlers = globalLogger.getHandlers()) {
                handler.setLevel(Level.SEVERE);
                globalLogger.removeHandler(handler);
            }
        }
    }

    private static synchronized void loadPlugins() {
        if (!pluginSystemEnabled) {
            return;
        }
        try {
            ModuleLoader moduleLoader = Module.getBootModuleLoader();
            CompositeClassLoader composite = new CompositeClassLoader();
            composite.add((ConcurrentClassLoader)Module.forClassLoader((ClassLoader)Bootstrap.class.getClassLoader(), (boolean)true).getClassLoader());
            ArrayList<InstalledPluginRegistry.PluginEntry> toLoad = new ArrayList<InstalledPluginRegistry.PluginEntry>();
            List<InstalledPluginRegistry.PluginEntry> installed = InstalledPluginRegistry.listByAPICompatibleVersion(InstalledPluginRegistry.getRuntimeAPIVersion());
            toLoad.addAll(installed);
            List<InstalledPluginRegistry.PluginEntry> incompatible = InstalledPluginRegistry.list();
            incompatible.removeAll(installed);
            for (InstalledPluginRegistry.PluginEntry pluginEntry : incompatible) {
                System.out.println("Not loading plugin [" + pluginEntry.getName() + "] because it references Forge API version [" + pluginEntry.getApiVersion() + "] which may not be compatible with my current version [" + Bootstrap.class.getPackage().getImplementationVersion() + "]. To remove this plugin, type 'forge remove-plugin " + pluginEntry + ". Otherwise, try installing a new version of the plugin.");
            }
            for (InstalledPluginRegistry.PluginEntry plugin : toLoad) {
                try {
                    Module module = moduleLoader.loadModule(ModuleIdentifier.fromString((String)plugin.toModuleId()));
                    composite.add((ConcurrentClassLoader)module.getClassLoader());
                }
                catch (Exception e) {
                    System.out.println("Failed loading: " + plugin);
                    e.printStackTrace();
                }
            }
            Module forge = moduleLoader.loadModule(ModuleIdentifier.fromString((String)"org.jboss.forge:main"));
            composite.add((ConcurrentClassLoader)forge.getClassLoader());
            Thread.currentThread().setContextClassLoader((ClassLoader)((Object)composite));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

