/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.inject.Inject;
import org.jboss.forge.ForgeEnvironment;
import org.jboss.forge.shell.ShellImpl;

public class ShellConfig {
    @Inject
    private ForgeEnvironment environment;

    public void loadConfig(ShellImpl shell) {
        File configDir = this.environment.getConfigDirectory().getUnderlyingResourceObject();
        if (configDir != null && configDir.exists() && !shell.isNoInitMode()) {
            boolean historyEnabled = shell.isHistoryEnabled();
            shell.setHistoryEnabled(false);
            File configFile = new File(configDir.getPath(), "config");
            if (!configFile.exists()) {
                this.createDefaultConfigFile(configFile);
            }
            try {
                shell.execute(configFile);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("error loading file: " + configFile.getAbsolutePath());
            }
            shell.setHistoryEnabled(historyEnabled);
        }
    }

    public void loadHistory(ShellImpl shell) {
        File configDir = this.environment.getConfigDirectory().getUnderlyingResourceObject();
        if (configDir != null && configDir.exists() && !shell.isNoInitMode()) {
            File historyFile = new File(configDir.getPath(), "cmd_history");
            try {
                if (!historyFile.exists() && !historyFile.createNewFile()) {
                    System.err.println("could not create config file: " + historyFile.getAbsolutePath());
                }
            }
            catch (IOException e) {
                throw new RuntimeException("could not create config file: " + historyFile.getAbsolutePath());
            }
            ArrayList<String> history = new ArrayList<String>();
            try {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(historyFile));
                while ((line = reader.readLine()) != null) {
                    history.add(line);
                }
                reader.close();
                shell.setHistory(history);
            }
            catch (IOException e) {
                throw new RuntimeException("error loading file: " + historyFile.getAbsolutePath());
            }
            try {
                shell.setHistoryOutputStream(new BufferedOutputStream(new FileOutputStream(historyFile, true)));
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("error setting forge history output stream to file: " + historyFile.getAbsolutePath());
            }
        }
    }

    private void createDefaultConfigFile(File configFile) {
        try {
            configFile.createNewFile();
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(configFile));
            String defaultConfig = this.getDefaultConfig();
            for (int i = 0; i < defaultConfig.length(); ++i) {
                ((OutputStream)outputStream).write(defaultConfig.charAt(i));
            }
            ((OutputStream)outputStream).flush();
            ((OutputStream)outputStream).close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("error creating default config file: " + configFile.getAbsolutePath());
        }
    }

    private String getDefaultConfig() {
        return "@/* Automatically generated config file */;\nif (!$NO_MOTD) { \n   echo \"    _____                    \";\n   echo \"   |  ___|__  _ __ __ _  ___ \";\n   echo \"   | |_ / _ \\\\| `__/ _` |/ _ \\\\  \\c{yellow}\\\\\\\\c\";\n   echo \"   |  _| (_) | | | (_| |  __/  \\c{yellow}//\\c\";\n   echo \"   |_|  \\\\___/|_|  \\\\__, |\\\\___| \";\n   echo \"                   |___/      \";\n   echo \" \";\n}\n\nif ($OS_NAME.startsWith(\"Windows\")) {\n    echo \"  Windows? Really? Okay...\\n\"\n}\n\nset HISTORY true;\nset PROMPT \"[\\c{green}$PROJECT_NAME\\c] \\c{blue}\\W\\c \\c{green}\\$\\c \";\nset PROMPT_NOPROJ \"[\\c{red}no project\\c] \\c{blue}\\W\\c \\c{red}\\$\\c \";\nset DEFAULT_PLUGIN_REPO \"https://raw.github.com/forge/plugin-repository/master/repository.yaml\";\nset IGNOREEOF 1;\n";
    }
}

