/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.buffers;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jboss.forge.shell.util.OSUtils;

public class ConsoleInputSession {
    private InputStream consoleStream;
    private InputStream externalInputStream;
    private final ArrayBlockingQueue<String> blockingQueue = new ArrayBlockingQueue(1000);
    private volatile boolean connected;

    public ConsoleInputSession(InputStream consoleStream) {
        this.consoleStream = consoleStream;
        this.connected = true;
        this.externalInputStream = new InputStream(){
            private String b;
            private int c;

            @Override
            public int read() throws IOException {
                try {
                    if (this.b == null || this.c == this.b.length()) {
                        this.b = (String)ConsoleInputSession.this.blockingQueue.poll(365L, TimeUnit.DAYS);
                        this.c = 0;
                    }
                    if (this.b != null) {
                        return this.b.charAt(this.c++);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return -1;
            }
        };
        this.startReader();
    }

    private void startReader() {
        Thread readerThread = new Thread(){

            @Override
            public void run() {
                while (ConsoleInputSession.this.connected) {
                    try {
                        byte[] bBuf = new byte[20];
                        int read = ConsoleInputSession.this.consoleStream.read(bBuf);
                        if (read > 0) {
                            ConsoleInputSession.this.blockingQueue.put(new String(bBuf, 0, read));
                        }
                        Thread.sleep(10L);
                    }
                    catch (IOException e) {
                        if (!ConsoleInputSession.this.connected) continue;
                        ConsoleInputSession.this.connected = false;
                        throw new RuntimeException("broken pipe");
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        readerThread.start();
    }

    public void interruptPipe() {
        this.blockingQueue.offer(OSUtils.getLineSeparator());
    }

    public void stop() {
        this.connected = false;
        this.blockingQueue.offer("");
    }

    public InputStream getExternalInputStream() {
        return this.externalInputStream;
    }
}

