/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.command.fshparser;

import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import org.jboss.forge.shell.command.fshparser.FSHRuntime;
import org.jboss.forge.shell.command.fshparser.LogicalStatement;
import org.jboss.forge.shell.command.fshparser.Node;
import org.jboss.forge.shell.command.fshparser.Parse;
import org.jboss.forge.shell.command.fshparser.ScriptNode;
import org.jboss.forge.shell.command.fshparser.TokenNode;

public class AutoReducingQueue
implements Queue<String> {
    private Node currNode;
    private String reduceCache;
    private final FSHRuntime runtime;

    public AutoReducingQueue(Node startNode, FSHRuntime runtime) {
        this.currNode = startNode;
        this.runtime = runtime;
    }

    @Override
    public boolean add(String o) {
        throw new RuntimeException("add() not supported");
    }

    @Override
    public boolean offer(String o) {
        throw new RuntimeException("offer() not supported");
    }

    @Override
    public String remove() {
        if (this.currNode == null) {
            throw new RuntimeException("empty queue");
        }
        this.reduce();
        this.advance();
        return this.reduceCache;
    }

    @Override
    public String poll() {
        this.reduce();
        this.advance();
        return this.reduceCache;
    }

    @Override
    public String element() {
        return null;
    }

    @Override
    public String peek() {
        if (this.reduceCache == null) {
            this.reduce();
        }
        return this.reduceCache;
    }

    private void reduce() {
        if (this.currNode instanceof ScriptNode) {
            this.reduceCache = Parse.executeScript((ScriptNode)this.currNode, this.runtime);
            if (((ScriptNode)this.currNode).isNocommand()) {
                this.reduceCache = "";
            }
        } else if (this.currNode instanceof TokenNode) {
            this.reduceCache = ((TokenNode)this.currNode).getValue();
        } else if (this.currNode instanceof LogicalStatement) {
            StringBuilder sb = new StringBuilder("(");
            Iterator<String> iter = new AutoReducingQueue(((LogicalStatement)this.currNode).getNest(), this.runtime).iterator();
            while (iter.hasNext()) {
                sb.append(iter.next());
                if (!iter.hasNext()) continue;
                sb.append(" ");
            }
            this.reduceCache = sb.append(")").toString();
        } else {
            throw new RuntimeException("cannot reduce: " + this.currNode);
        }
        if (this.reduceCache == null) {
            this.reduceCache = "";
        }
    }

    private void advance() {
        this.reduceCache = null;
        this.currNode = this.currNode != null && this.currNode.next != null ? this.currNode.next : null;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return this.currNode == null;
    }

    @Override
    public boolean contains(Object o) {
        return false;
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return AutoReducingQueue.this.currNode != null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String next() {
                try {
                    String string = AutoReducingQueue.this.peek();
                    return string;
                }
                finally {
                    AutoReducingQueue.this.advance();
                }
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public Object[] toArray() {
        return new Object[0];
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return null;
    }

    @Override
    public boolean remove(Object o) {
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new RuntimeException("containsAll() not supported");
    }

    @Override
    public boolean addAll(Collection c) {
        throw new RuntimeException("addAll() not supported");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new RuntimeException("removeAll() not supported");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new RuntimeException("retainAll() not supported");
    }

    @Override
    public void clear() {
        throw new RuntimeException("clear() not supported");
    }
}

