/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.command.parser;

import java.util.Queue;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.shell.command.CommandMetadata;
import org.jboss.forge.shell.command.OptionMetadata;
import org.jboss.forge.shell.command.parser.CommandParser;
import org.jboss.forge.shell.command.parser.CommandParserContext;

public class OrderedValueOptionParser
implements CommandParser {
    @Override
    public CommandParserContext parse(CommandMetadata command, Queue<String> tokens, CommandParserContext ctx) {
        String currentToken = tokens.peek();
        if (command.hasOrderedOptions() && !command.hasOption(currentToken.replaceAll("^--?", ""))) {
            if (currentToken.matches("^--?$") && ctx.isCompleting() && !ctx.isTokenComplete()) {
                return ctx;
            }
            int numberOrderedParams = ctx.getOrderedParamCount();
            try {
                OptionMetadata option = command.getOrderedOptionByIndex(numberOrderedParams);
                if (!option.isVarargs()) {
                    ctx.put(option, Strings.stripQuotes((String)currentToken), Strings.stripQuotes((String)tokens.remove()));
                    ctx.incrementParmCount();
                }
            }
            catch (IllegalArgumentException e) {
                ctx.addWarning("The command [" + command + "] takes [" + command.getNumOrderedOptions() + "] unnamed argument(s), but found [" + (numberOrderedParams + 1) + "].");
            }
        }
        return ctx;
    }
}

