/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.console.jline.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jboss.forge.shell.console.jline.internal.Log;

public final class Configuration {
    public static final String JLINE_RC = ".jline.rc";
    private static final Properties userprops;

    private static boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static String getString(String name, String defaultValue) {
        assert (name != null);
        String value = System.getProperty(name);
        if (Configuration.isEmpty(value) && Configuration.isEmpty(value = userprops.getProperty(name))) {
            value = defaultValue;
        }
        return value;
    }

    public static String getString(String name) {
        return Configuration.getString(name, null);
    }

    public static Boolean getBoolean(String name, Boolean defaultValue) {
        String value = Configuration.getString(name);
        if (Configuration.isEmpty(value)) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    public static Boolean getBoolean(String name) {
        return Configuration.getBoolean(name, null);
    }

    public static File getUserHome() {
        return new File(System.getProperty("user.home"));
    }

    public static String getOsName() {
        return System.getProperty("os.name").toLowerCase();
    }

    public static String getFileEncoding() {
        return System.getProperty("file.encoding");
    }

    public static String getInputEncoding() {
        return System.getProperty("input.encoding", "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Properties props = new Properties();
        File file = new File(Configuration.getUserHome(), JLINE_RC);
        if (file.exists() && file.canRead()) {
            try {
                BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
                try {
                    props.load(input);
                    Log.debug("Loaded user configuration: ", file);
                }
                finally {
                    ((InputStream)input).close();
                }
            }
            catch (IOException e) {
                Log.warn("Unable to read user configuration: ", file, e);
            }
        } else {
            Log.trace("User configuration file missing or unreadable: ", file);
        }
        userprops = props;
    }
}

