/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.plugins.builtin;

import javax.inject.Inject;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.JavaExecutionFacet;
import org.jboss.forge.resources.java.JavaResource;
import org.jboss.forge.shell.PromptType;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.Topic;

@Alias(value="execute-java")
@Topic(value="Project")
@Help(value="Execute a main method on a project class")
public class JavaExecutionPlugin
implements Plugin {
    @Inject
    Project project;

    @DefaultCommand
    public void executeJavaClass(@Option(name="class", type=PromptType.JAVA_CLASS, required=true) JavaResource classToExecute, @Option(name="arguments") String arguments) throws Exception {
        String qualifiedName = classToExecute.getJavaSource().getQualifiedName();
        JavaExecutionFacet facet = (JavaExecutionFacet)this.project.getFacet(JavaExecutionFacet.class);
        if (arguments != null) {
            facet.executeProjectClass(qualifiedName, arguments.split(" "));
        } else {
            facet.executeProjectClass(qualifiedName, new String[0]);
        }
    }
}

