/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.project;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.jboss.forge.project.Facet;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.FacetActionAborted;
import org.jboss.forge.project.facets.events.FacetRemoved;
import org.jboss.forge.project.facets.events.RemoveFacets;
import org.jboss.forge.project.services.FacetFactory;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.util.ConstraintInspector;

public class FacetRemovalHandler {
    @Inject
    private FacetFactory factory;
    @Inject
    private Shell shell;
    @Inject
    private Project project;
    @Inject
    private BeanManager manager;

    public void removeRequest(@Observes RemoveFacets request) {
        ArrayList<Facet> removed = new ArrayList<Facet>();
        this.shell.printlnVerbose("Received Facet removal request " + request.getFacetTypes());
        if (!request.promptRequested() || this.shell.promptBoolean("An action has requested to remove the following facets from your project " + request.getFacetTypes() + " continue?", true)) {
            for (Class type : request.getFacetTypes()) {
                Facet facet = this.factory.getFacet(type);
                if (this.project.hasFacet(type)) {
                    removed.addAll(this.remove(facet, false));
                    continue;
                }
                this.shell.printlnVerbose("Facet not installed" + type);
            }
        } else if (request.promptRequested()) {
            throw new FacetActionAborted("Facet installation aborted.");
        }
        for (Facet facet : removed) {
            this.manager.fireEvent((Object)new FacetRemoved(facet), new Annotation[0]);
        }
    }

    private Collection<Facet> remove(Facet facet, boolean prompt) {
        Collection<Facet> removed = this.performRemoval(facet, prompt);
        if (!removed.contains(facet)) {
            ShellMessages.error((ShellPrintWriter)this.shell, (String)("Failed to remove [" + ConstraintInspector.getName(facet.getClass()) + "]; there may be a mess!"));
        }
        return removed;
    }

    private Collection<Facet> performRemoval(Facet facet, boolean prompt) {
        ArrayList<Facet> result = new ArrayList<Facet>();
        if (!this.project.hasFacet(facet.getClass())) {
            result.add(facet);
        } else {
            facet.setProject(this.project);
            if (facet.isInstalled() || this.project.hasFacet(facet.getClass())) {
                this.project.removeFacet(facet);
            }
            if (!facet.isInstalled()) {
                ShellMessages.success((ShellPrintWriter)this.shell, (String)("Removed [" + ConstraintInspector.getName(facet.getClass()) + "] successfully."));
                result.add(facet);
            }
        }
        return result;
    }
}

