/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.spi.node;

import java.util.ArrayList;
import org.jboss.shrinkwrap.descriptor.spi.node.Pattern;

class Patterns {
    private static final String PATH_SEPARATOR = "/";
    private static final String ATTR_PATH_SEPERATOR = "@";
    private static final String ATTR_SEPERATOR = "&";
    private static final String ATTR_VALUE_SEPERATOR = "=";
    private static final Pattern[] ARRAY_CAST = new Pattern[0];

    Patterns() {
    }

    public static Pattern[] from(String queryExpression) throws IllegalArgumentException {
        String[] paths;
        if (queryExpression == null) {
            throw new IllegalArgumentException("Query expression must be specified");
        }
        boolean isAbsolute = queryExpression.startsWith(PATH_SEPARATOR);
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String path : paths = (isAbsolute ? queryExpression.substring(1) : queryExpression).split(PATH_SEPARATOR)) {
            String nameSegment = path.indexOf(ATTR_PATH_SEPERATOR) != -1 ? path.substring(0, path.indexOf(ATTR_PATH_SEPERATOR)) : path;
            String name = nameSegment.indexOf(ATTR_VALUE_SEPERATOR) != -1 ? nameSegment.substring(0, nameSegment.indexOf(ATTR_VALUE_SEPERATOR)) : nameSegment;
            String text = nameSegment.indexOf(ATTR_VALUE_SEPERATOR) != -1 ? nameSegment.substring(nameSegment.indexOf(ATTR_VALUE_SEPERATOR) + 1) : null;
            String attribute = path.indexOf(ATTR_PATH_SEPERATOR) != -1 ? path.substring(path.indexOf(ATTR_PATH_SEPERATOR) + ATTR_PATH_SEPERATOR.length(), path.length()) : null;
            String[] attributes = attribute == null ? new String[]{} : attribute.split(ATTR_SEPERATOR);
            Pattern pattern = new Pattern(name);
            pattern.text(text);
            for (String attr : attributes) {
                String[] nameValue = attr.split(ATTR_VALUE_SEPERATOR);
                if (nameValue.length != 2) {
                    throw new IllegalArgumentException("Attribute without name or value found: " + attr + " in expression: " + queryExpression);
                }
                pattern.attribute(nameValue[0], nameValue[1]);
            }
            patterns.add(pattern);
        }
        return patterns.toArray(ARRAY_CAST);
    }
}

