/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.plugins.model.handlers;

import java.util.Properties;
import org.jboss.tools.common.meta.action.SpecialWizard;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XModelObjectUtil;
import org.jboss.tools.struts.webprj.model.helpers.WebModulesHelper;

public abstract class PluginRegistration
implements SpecialWizard {
    protected Properties p;
    protected XModel model;
    protected XModelObject cfg;
    protected String oldPath;
    protected String path;
    protected boolean test;

    public void setObject(Object object) {
        this.p = (Properties)object;
        this.model = (XModel)this.p.get("model");
        XModelObject[] cgs = WebModulesHelper.getInstance(this.model).getAllConfigs();
        if (cgs == null || cgs.length == 0) {
            return;
        }
        this.cfg = cgs[0];
        this.path = this.p.getProperty("path");
        this.oldPath = this.p.getProperty("oldPath");
        this.test = "true".equals(this.p.getProperty("test"));
    }

    public int execute() {
        if (this.cfg == null) {
            return 1;
        }
        try {
            return this.doExecute();
        }
        catch (XModelException e) {
            if (this.p != null) {
                this.p.put("exception", (Object)e);
            }
            return 1;
        }
    }

    private int doExecute() throws XModelException {
        if (this.test) {
            return this.test();
        }
        if (this.path == null && this.oldPath != null) {
            this.remove();
        } else {
            if (this.path == null) {
                return 1;
            }
            if (this.oldPath != null) {
                this.replace();
            } else {
                this.append();
            }
        }
        XActionInvoker.invoke((String)"SaveActions.Save", (XModelObject)this.cfg, null);
        return 0;
    }

    void append() throws XModelException {
        XModelObject plugin = this.getPlugin(true);
        XModelObject property = this.getSetProperty(plugin, true);
        this.addPathIfNeeded(property, this.path);
    }

    protected void modifyProperties(XModelObject plugin) throws XModelException {
    }

    void replace() throws XModelException {
        boolean isDefault = this.isOldNameDefault();
        XModelObject plugin = this.getPlugin(isDefault);
        if (plugin == null) {
            return;
        }
        XModelObject property = this.getSetProperty(plugin, isDefault);
        this.replacePath(property);
    }

    void remove() throws XModelException {
        XModelObject plugin = this.getPlugin(false);
        if (plugin == null) {
            return;
        }
        XModelObject property = this.getSetProperty(plugin, false);
        this.replacePath(property);
    }

    private XModelObject getPlugin(boolean create) throws XModelException {
        XModelObject plugins = this.cfg.getChildByPath("plug-ins");
        XModelObject[] os = plugins.getChildren();
        int i = 0;
        while (i < os.length) {
            if (this.getPluginClassName().equals(os[i].getAttributeValue("className"))) {
                return os[i];
            }
            ++i;
        }
        if (!create) {
            return null;
        }
        XModelObject plugin = this.model.createModelObject("StrutsPlugin11", null);
        plugin.setAttributeValue("className", this.getPluginClassName());
        DefaultCreateHandler.addCreatedObject((XModelObject)plugins, (XModelObject)plugin, (int)-1);
        this.modifyProperties(plugin);
        return plugin;
    }

    private XModelObject getSetProperty(XModelObject plugin, boolean create) throws XModelException {
        return this.getSetProperty(plugin, this.getSetPropertyName(), create, this.getDefaultSetPropertyValue());
    }

    protected XModelObject getSetProperty(XModelObject plugin, String name, boolean create, String value) throws XModelException {
        XModelObject[] ps = plugin.getChildren();
        int i = 0;
        while (i < ps.length) {
            if (name.equals(ps[i].getAttributeValue("property"))) {
                return ps[i];
            }
            ++i;
        }
        if (!create) {
            return null;
        }
        XModelObject property = this.model.createModelObject("StrutsPluginSetProperty11", null);
        property.setAttributeValue("property", name);
        if (value != null) {
            property.setAttributeValue("value", value);
        }
        DefaultCreateHandler.addCreatedObject((XModelObject)plugin, (XModelObject)property, (int)-1);
        return property;
    }

    private void addPathIfNeeded(XModelObject property, String path) throws XModelException {
        String value = property.getAttributeValue("value");
        String[] array = XModelObjectUtil.asStringArray((String)value);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(path)) {
                return;
            }
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(array[i]);
            ++i;
        }
        if (sb.length() > 0) {
            sb.append(",");
        }
        sb.append(path);
        value = sb.toString();
        property.getModel().changeObjectAttribute(property, "value", value);
    }

    private void replacePath(XModelObject property) throws XModelException {
        String value = property.getAttributeValue("value");
        String[] s = XModelObjectUtil.asStringArray((String)value);
        StringBuffer sb = new StringBuffer();
        boolean replaced = false;
        int i = 0;
        while (i < s.length) {
            String add = null;
            if (s[i].equals(this.oldPath)) {
                add = this.path;
                replaced = true;
            } else {
                add = s[i];
            }
            if (add != null) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(add);
            }
            ++i;
        }
        if (!replaced && this.path != null) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(this.path);
        }
        value = sb.toString();
        property.getModel().changeObjectAttribute(property, "value", value);
    }

    int test() throws XModelException {
        if (this.path == null) {
            return 1;
        }
        XModelObject plugin = this.getPlugin(false);
        if (plugin == null) {
            return 1;
        }
        XModelObject property = this.getSetProperty(plugin, this.getSetPropertyName(), false, null);
        if (property == null) {
            return 1;
        }
        String value = property.getAttributeValue("value");
        String[] s = XModelObjectUtil.asStringArray((String)value);
        int i = 0;
        while (i < s.length) {
            if (s[i].equals(this.path)) {
                return 0;
            }
            ++i;
        }
        return 1;
    }

    protected abstract String getPluginClassName();

    protected abstract String getSetPropertyName();

    protected String getDefaultSetPropertyValue() {
        return null;
    }

    protected boolean isOldNameDefault() {
        return false;
    }
}

