/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.webprj.model.helpers.context;

import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.model.util.XModelObjectUtil;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jst.web.context.AdoptWebProjectContext;
import org.jboss.tools.jst.web.context.ImportWebDirProjectContext;
import org.jboss.tools.jst.web.model.helpers.WebAppHelper;
import org.jboss.tools.jst.web.webapp.model.FileWebAppLoader;
import org.jboss.tools.struts.StrutsModelPlugin;
import org.jboss.tools.struts.StrutsPreference;
import org.jboss.tools.struts.StrutsUtils;
import org.jboss.tools.struts.webprj.model.helpers.adopt.AdoptProjectContext;
import org.jboss.tools.struts.webprj.model.helpers.sync.ModulesDataValidator;

public class ImportProjectWizardContext
extends ImportWebDirProjectContext {
    Delta delta = new Delta();
    ModulesDataValidator modulesValidator = new ModulesDataValidator();
    AdoptWebProjectContext adoptWebProjectContext = null;

    public ImportProjectWizardContext(XModelObject target) {
        super(target);
    }

    protected void initRegistry() {
        this.getRegisterServerContext().setNatureIndex("struts");
        this.getRegisterServerContext().setPreferences(StrutsPreference.REGISTER_IMPORTED_PROJECT_IN_SERVER);
        this.getRegisterServerContext().init();
    }

    public void setPexFileName(String value) {
    }

    public String getModulesErrorMessage(XModelObject[] modules, XModelObject selected) {
        this.modulesValidator.setProject(this.getProjectLocation());
        return this.modulesValidator.getErrorMessage(modules, selected);
    }

    public boolean createConfigFile(String path) {
        File f = new File(path);
        if (f.exists()) {
            ServiceDialog d = this.target.getModel().getService();
            d.showDialog("Error", "File " + path + " exists.", new String[]{"OK"}, null, 1);
            return false;
        }
        this.createConfigFile(f, "StrutsConfig11");
        return true;
    }

    public void addSupportDelta(Properties p) {
        XModelObject folder = this.webxml.getChildByPath(WebAppHelper.SERVLET_FOLDER);
        if (folder == null) {
            folder = this.webxml;
        }
        File f = new File(this.webXmlLocation);
        String version = p.getProperty("version");
        String servletclass = p.getProperty("servlet class");
        String urlpattern = p.getProperty("url pattern");
        String tldfiles = p.getProperty("tld files");
        this.delta.webxmlCopy = this.webxml.copy();
        XModel model = this.webxml.getModel();
        XModelObject servlet = this.webxml.getChildByPath("action");
        if (servlet == null) {
            servlet = XModelObjectLoaderUtil.createValidObject((XModel)model, (String)WebAppHelper.SERVLET_ENTITY);
            servlet.setAttributeValue("servlet-name", "action");
            servlet.setAttributeValue("load-on-startup", "1");
        }
        servlet.setAttributeValue("servlet-class", servletclass);
        XModelObject config = XModelObjectLoaderUtil.createValidObject((XModel)model, (String)"WebAppInitParam");
        config.setAttributeValue("param-name", "config");
        config.setAttributeValue("param-value", "/WEB-INF/struts-config.xml");
        servlet.addChild(config);
        XModelObject mapping = XModelObjectLoaderUtil.createValidObject((XModel)model, (String)WebAppHelper.SERVLET_MAPPING_ENTITY);
        mapping.setAttributeValue("servlet-name", "action");
        mapping.setAttributeValue("url-pattern", urlpattern);
        if (servlet.getParent() == null) {
            folder.addChild(servlet);
        }
        folder.addChild(mapping);
        String[] ts = XModelObjectUtil.asStringArray((String)tldfiles);
        int i = 0;
        while (i < ts.length) {
            XModelObject taglib = XModelObjectLoaderUtil.createValidObject((XModel)model, (String)"WebAppTaglib");
            String path = "/WEB-INF/" + ts[i];
            String uri = path;
            if (uri.endsWith(".tld")) {
                uri = uri.substring(0, uri.length() - 4);
            }
            taglib.setAttributeValue("taglib-uri", uri);
            taglib.setAttributeValue("taglib-location", path);
            WebAppHelper.getJSPConfig((XModelObject)this.webxml).addChild(taglib);
            File sf = new File(String.valueOf(new StrutsUtils().getStrutsSupportTemplatesLocation(version)) + "/tld/" + ts[i]);
            File tf = new File(String.valueOf(f.getParent()) + "/" + ts[i]);
            this.delta.addTLDDelta(sf, tf);
            ++i;
        }
        File sf = new File(String.valueOf(f.getParent()) + "/" + "struts-config.xml");
        String suffix = "1.0".equals(version) ? "10" : ("1.2".equals(version) ? "12" : "11");
        String entity = "StrutsConfig" + suffix;
        if (!sf.exists()) {
            this.createConfigFile(sf, entity);
            this.delta.struts.f = sf;
        }
        this.delta.lib.version = version;
        this.modules = this.createAdoptContext().createModulesInfo(this.webxml, f.getParentFile());
        this.createAllModules();
        this.setProjectJavaSrc();
    }

    public String getNatureID() {
        return "org.jboss.tools.struts.strutsnature";
    }

    protected AdoptWebProjectContext createAdoptContext() {
        if (this.adoptWebProjectContext == null) {
            this.adoptWebProjectContext = new AdoptProjectContext();
        }
        return this.adoptWebProjectContext;
    }

    public void rollbackSupportDelta() {
        if (this.delta.webxmlCopy == null) {
            return;
        }
        this.webxml = this.delta.webxmlCopy;
        this.delta.webxmlCopy = null;
        this.modules = this.adoptWebProjectContext.createModulesInfo(this.webxml, new File(this.webXmlLocation).getParentFile());
        this.createAllModules();
        this.delta.tlds.clear();
        this.delta.struts.rollback();
    }

    public void commitSupportDelta() {
        if (this.delta.webxmlCopy == null) {
            return;
        }
        this.delta.webxmlCopy = null;
        this.delta.commitTLD();
        String body = ((FileWebAppLoader)XModelObjectLoaderUtil.getObjectLoader((XModelObject)this.webxml)).serializeObject(this.webxml);
        FileUtil.writeFile((File)new File(this.webXmlLocation), (String)body);
        this.delta.lib.commit();
        try {
            this.getProjectHandle().refreshLocal(2, null);
        }
        catch (Exception e) {
            StrutsModelPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    class Delta {
        XModelObject webxmlCopy = null;
        StrutsDelta struts;
        ArrayList<TLDDelta> tlds;
        LibDelta lib;

        Delta() {
            this.struts = new StrutsDelta();
            this.tlds = new ArrayList();
            this.lib = new LibDelta();
        }

        public void addTLDDelta(File sf, File tf) {
            TLDDelta d = new TLDDelta();
            d.sf = sf;
            d.tf = tf;
            this.tlds.add(d);
        }

        public void commitTLD() {
            TLDDelta[] ds = this.tlds.toArray(new TLDDelta[0]);
            int i = 0;
            while (i < ds.length) {
                ds[i].commit();
                ++i;
            }
        }
    }

    class LibDelta {
        String version;

        LibDelta() {
        }

        public void commit() {
            String[] strutsJars = new StrutsUtils().getLibraries(this.version);
            String libDir = String.valueOf(ImportProjectWizardContext.this.getWebInfLocation()) + "/lib";
            int i = 0;
            while (i < strutsJars.length) {
                File source = new File(strutsJars[i]);
                File target = new File(libDir, source.getName());
                if (!target.isFile()) {
                    FileUtil.copyFile((File)source, (File)target, (boolean)true);
                }
                ++i;
            }
        }
    }

    class StrutsDelta {
        File f = null;

        StrutsDelta() {
        }

        public void rollback() {
            if (this.f != null) {
                this.f.delete();
            }
            this.f = null;
        }
    }

    class TLDDelta {
        File sf;
        File tf;

        TLDDelta() {
        }

        public void commit() {
            if (this.sf.isFile() && !this.tf.exists()) {
                FileUtil.copyFile((File)this.sf, (File)this.tf, (boolean)true);
            }
        }
    }
}

