/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.webprj.pattern;

import java.util.HashMap;
import java.util.Map;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.jst.web.model.helpers.WebAppHelper;
import org.jboss.tools.struts.webprj.model.helpers.sync.StrutsWebHelper;
import org.jboss.tools.struts.webprj.pattern.PostfixUrlPattern;
import org.jboss.tools.struts.webprj.pattern.PrefixUrlPattern;
import org.jboss.tools.struts.webprj.pattern.UrlPattern;

public class PatternLoader {
    public static UrlPattern DEFAULT_PATTERN = new PostfixUrlPattern();
    private Map<String, UrlPattern> servletPatterns = new HashMap<String, UrlPattern>();
    private Map<String, UrlPattern> configPatterns = new HashMap<String, UrlPattern>();
    private long timeStamp = -1L;

    public UrlPattern getUrlPatternForModule(String module) {
        if (module == null) {
            return DEFAULT_PATTERN;
        }
        UrlPattern p = this.configPatterns.get(module);
        return p != null ? p : DEFAULT_PATTERN;
    }

    public void revalidate(XModelObject webxml) {
        if (webxml == null || webxml.getChildren().length == 0) {
            return;
        }
        if (this.timeStamp == webxml.getTimeStamp()) {
            return;
        }
        this.timeStamp = webxml.getTimeStamp();
        XModelObject[] mappings = WebAppHelper.getServletMappings((XModelObject)webxml);
        this.servletPatterns.clear();
        this.configPatterns.clear();
        if (mappings.length == 0) {
            return;
        }
        int i = 0;
        while (i < mappings.length) {
            String servlet = mappings[i].getAttributeValue("servlet-name");
            String pattern = mappings[i].getAttributeValue("url-pattern");
            UrlPattern up = this.load(pattern);
            if (up != null) {
                this.servletPatterns.put(servlet, up);
            }
            ++i;
        }
        if (this.servletPatterns.size() == 0) {
            return;
        }
        XModelObject servlet = WebAppHelper.findServlet((XModelObject)webxml, (String)StrutsWebHelper.ACTION_SERVLET, (String)"action");
        if (servlet == null) {
            return;
        }
        String servletName = servlet.getAttributeValue("servlet-name");
        if (this.servletPatterns.containsKey(servletName)) {
            UrlPattern up = this.servletPatterns.get(servletName);
            XModelObject[] init = servlet.getChildren("WebAppInitParam");
            int j = 0;
            while (j < init.length) {
                String module = init[j].getAttributeValue("param-name");
                if (module.startsWith("config")) {
                    module = module.substring(6);
                    this.configPatterns.put(module, up);
                }
                ++j;
            }
        }
    }

    UrlPattern load(String p) {
        if (p == null || p.length() == 0) {
            return null;
        }
        if (p.startsWith("*.")) {
            String n = p.substring(2);
            int i = 0;
            while (i < n.length()) {
                if (!Character.isJavaIdentifierPart(n.charAt(i))) {
                    return null;
                }
                ++i;
            }
            if (n.equals("do")) {
                return null;
            }
            PostfixUrlPattern up = new PostfixUrlPattern();
            up.setPostfix(p.substring(1));
            return up;
        }
        if (p.endsWith("/*") && p.startsWith("/") && p.length() > 2) {
            String n = p.substring(1, p.length() - 2);
            int i = 0;
            while (i < n.length()) {
                if (!Character.isJavaIdentifierPart(n.charAt(i))) {
                    return null;
                }
                ++i;
            }
            PrefixUrlPattern up = new PrefixUrlPattern();
            up.setPrefix(p.substring(0, p.length() - 1));
            return up;
        }
        return null;
    }
}

