/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.scaffold.faces.metawidget.inspector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Embedded;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.jboss.forge.parser.java.EnumConstant;
import org.jboss.forge.parser.java.JavaEnum;
import org.jboss.forge.scaffold.faces.metawidget.inspector.ForgeInspectorConfig;
import org.jboss.forge.scaffold.faces.metawidget.inspector.propertystyle.ForgePropertyStyle;
import org.jboss.forge.scaffold.faces.util.AnnotationLookup;
import org.jboss.solder.logging.Logger;
import org.metawidget.inspector.impl.BaseObjectInspector;
import org.metawidget.inspector.impl.BaseObjectInspectorConfig;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.statically.faces.StaticFacesUtils;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.StringUtils;

public class ForgeInspector
extends BaseObjectInspector {
    Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private AnnotationLookup annotationLookup;

    public ForgeInspector(ForgeInspectorConfig config) {
        super((BaseObjectInspectorConfig)config);
        this.annotationLookup = config.getAnnotationLookup();
    }

    protected Map<String, String> inspectProperty(Property property) throws Exception {
        List<EnumConstant<JavaEnum>> enumConstants;
        HashMap attributes = CollectionUtils.newHashMap();
        if (property.isAnnotationPresent(OneToOne.class) || property.isAnnotationPresent(Embedded.class)) {
            attributes.put("one-to-one", "true");
        }
        if (property.isAnnotationPresent(ManyToOne.class)) {
            attributes.put("faces-lookup", StaticFacesUtils.wrapExpression((String)(StringUtils.decapitalize((String)ClassUtils.getSimpleName((String)property.getType())) + "Bean.all")));
            attributes.put("faces-converter-id", StaticFacesUtils.wrapExpression((String)(StringUtils.decapitalize((String)ClassUtils.getSimpleName((String)property.getType())) + "Bean.converter")));
        }
        if (property.isAnnotationPresent(OneToMany.class) || property.isAnnotationPresent(ManyToMany.class)) {
            attributes.put("n-to-many", "true");
        }
        if (property instanceof ForgePropertyStyle.ForgeProperty && (enumConstants = ((ForgePropertyStyle.ForgeProperty)property).getEnumConstants()) != null) {
            ArrayList lookup = CollectionUtils.newArrayList();
            for (EnumConstant<JavaEnum> anEnum : enumConstants) {
                lookup.add(anEnum.getName());
            }
            attributes.put("lookup", CollectionUtils.toString((Collection)lookup));
        }
        if (null != property.getAnnotation(Id.class)) {
            attributes.put("primary-key", property.getName());
            if (null != property.getAnnotation(GeneratedValue.class)) {
                attributes.put("primary-key-not-generated", "false");
            } else {
                attributes.put("primary-key-not-generated", "true");
            }
        }
        if (null != property.getAnnotation(ManyToOne.class)) {
            attributes.put("reverse-primary-key-type", property.getType());
        }
        if (attributes.containsKey("primary-key") && !"true".equals(attributes.get("primary-key-not-generated"))) {
            attributes.remove("hidden");
            attributes.put("required", "true");
        }
        if (null != this.annotationLookup && attributes.containsKey("reverse-primary-key-type") && null != this.annotationLookup) {
            try {
                String reverseKey = this.annotationLookup.getFieldName(Id.class, (String)attributes.get("reverse-primary-key-type"));
                attributes.put("reverse-primary-key", reverseKey);
            }
            catch (Exception e) {
                throw new RuntimeException("cannot resolve reverse primary key", e);
            }
        }
        return attributes;
    }

    protected Map<String, String> inspectEntity(String declaredClass, String actualClass) throws Exception {
        HashMap attributes = CollectionUtils.newHashMap();
        Map superMap = super.inspectEntity(declaredClass, actualClass);
        if (superMap != null) {
            attributes.putAll(superMap);
        }
        if (null != this.annotationLookup) {
            try {
                String primaryKey = this.annotationLookup.getFieldName(Id.class, declaredClass);
                attributes.put("primary-key", primaryKey);
            }
            catch (Exception e) {
                this.log.debug((Object)("cannot resolve primary key for class " + declaredClass), (Throwable)e);
            }
        }
        return attributes;
    }
}

