/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.scaffold.faces.metawidget.inspector.propertystyle;

import java.io.FileNotFoundException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.forge.parser.java.Annotation;
import org.jboss.forge.parser.java.EnumConstant;
import org.jboss.forge.parser.java.Field;
import org.jboss.forge.parser.java.FieldHolder;
import org.jboss.forge.parser.java.JavaEnum;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.Method;
import org.jboss.forge.parser.java.MethodHolder;
import org.jboss.forge.parser.java.Parameter;
import org.jboss.forge.parser.java.Type;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.jboss.forge.scaffold.faces.metawidget.inspector.propertystyle.ForgePropertyStyleConfig;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseTraitStyleConfig;
import org.metawidget.inspector.impl.propertystyle.BaseProperty;
import org.metawidget.inspector.impl.propertystyle.BasePropertyStyle;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.inspector.impl.propertystyle.ValueAndDeclaredType;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.StringUtils;

public class ForgePropertyStyle
extends BasePropertyStyle {
    private final Project project;
    private final MessageFormat privateFieldConvention;

    public ForgePropertyStyle(ForgePropertyStyleConfig config) {
        super((BaseTraitStyleConfig)config);
        this.project = config.getProject();
        this.privateFieldConvention = config.getPrivateFieldConvention();
    }

    public ValueAndDeclaredType traverse(Object toTraverse, String type, boolean onlyToParent, String ... names) {
        if (names == null || names.length == 0) {
            if (onlyToParent) {
                return new ValueAndDeclaredType(null, null);
            }
            return new ValueAndDeclaredType(null, type);
        }
        String traverseDeclaredType = type;
        int length = names.length;
        for (int loop = 0; loop < length; ++loop) {
            if (onlyToParent && loop >= length - 1) {
                return new ValueAndDeclaredType(null, traverseDeclaredType);
            }
            String name = names[loop];
            Property property = (Property)this.getProperties(traverseDeclaredType).get(name);
            if (property == null || !property.isReadable()) {
                return new ValueAndDeclaredType(null, null);
            }
            traverseDeclaredType = property.getType();
        }
        return new ValueAndDeclaredType(null, traverseDeclaredType);
    }

    protected Map<String, Property> inspectProperties(String type) {
        try {
            LinkedHashMap properties = CollectionUtils.newLinkedHashMap();
            JavaSource<?> clazz = ForgePropertyStyle.sourceForName(this.project, type);
            if (clazz instanceof MethodHolder) {
                this.lookupGetters(properties, (MethodHolder)clazz);
                this.lookupSetters(properties, (MethodHolder)clazz);
            }
            return properties;
        }
        catch (Exception e) {
            throw InspectorException.newException((Throwable)e);
        }
    }

    protected void lookupGetters(Map<String, Property> properties, MethodHolder<?> clazz) {
        for (Method method : clazz.getMethods()) {
            String propertyName;
            String returnType;
            if (method.isStatic() || !method.getParameters().isEmpty() || (returnType = method.getQualifiedReturnType()) == null || (propertyName = this.isGetter(method)) == null) continue;
            Field<?> privateField = this.getPrivateField((FieldHolder)clazz, propertyName);
            if (privateField != null && this.privateFieldConvention == null) {
                propertyName = privateField.getName();
            }
            properties.put(propertyName, (Property)new ForgeProperty(propertyName, returnType, method, null, privateField, this.project));
        }
    }

    protected String isGetter(Method<?> method) {
        String propertyName;
        String methodName = method.getName();
        if (methodName.startsWith("get")) {
            propertyName = methodName.substring("get".length());
        } else if (methodName.startsWith("is") && Boolean.TYPE.equals(method.getQualifiedReturnType())) {
            propertyName = methodName.substring("is".length());
        } else {
            return null;
        }
        if (!StringUtils.isCapitalized((String)propertyName)) {
            return null;
        }
        return StringUtils.decapitalize((String)propertyName);
    }

    protected void lookupSetters(Map<String, Property> properties, MethodHolder<?> clazz) {
        for (Method method : clazz.getMethods()) {
            Property existingProperty;
            String propertyName;
            List parameters;
            if (method.isStatic() || (parameters = method.getParameters()).size() != 1 || (propertyName = this.isSetter(method)) == null) continue;
            String type = ((Parameter)parameters.get(0)).getType();
            Field<?> privateField = this.getPrivateField((FieldHolder)clazz, propertyName);
            if (privateField != null && this.privateFieldConvention == null) {
                propertyName = privateField.getName();
            }
            if ((existingProperty = properties.get(propertyName)) instanceof ForgeProperty) {
                ForgeProperty existingForgeProperty = (ForgeProperty)existingProperty;
                properties.put(propertyName, (Property)new ForgeProperty(propertyName, existingForgeProperty.getType(), existingForgeProperty.getReadMethod(), method, this.getPrivateField((FieldHolder)clazz, propertyName), this.project));
                continue;
            }
            if (existingProperty == null && properties.containsKey(propertyName)) continue;
            properties.put(propertyName, (Property)new ForgeProperty(propertyName, type, null, method, privateField, this.project));
        }
    }

    protected String isSetter(Method<?> method) {
        String methodName = method.getName();
        if (!methodName.startsWith("set")) {
            return null;
        }
        String propertyName = methodName.substring("set".length());
        if (!StringUtils.isCapitalized((String)propertyName)) {
            return null;
        }
        return StringUtils.decapitalize((String)propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Field<?> getPrivateField(FieldHolder<?> fieldHolder, String propertyName) {
        if (this.privateFieldConvention != null) {
            String fieldName;
            Object[] arguments = new String[]{propertyName, StringUtils.capitalize((String)propertyName)};
            MessageFormat messageFormat = this.privateFieldConvention;
            synchronized (messageFormat) {
                fieldName = this.privateFieldConvention.format(arguments, new StringBuffer(), (FieldPosition)null).toString();
            }
            return fieldHolder.getField(fieldName);
        }
        Field field = fieldHolder.getField(propertyName);
        if (field == null && !StringUtils.isCapitalized((String)propertyName)) {
            field = fieldHolder.getField(StringUtils.capitalize((String)propertyName));
        }
        return field;
    }

    static JavaSource<?> sourceForName(Project project, String type) {
        try {
            JavaSourceFacet javaSourceFact = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
            return javaSourceFact.getJavaResource(type).getJavaSource();
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public static class AnnotationProxy<T extends java.lang.annotation.Annotation>
    implements InvocationHandler {
        private final Annotation<?> annotationSource;
        private final Class<T> annotationClass;

        public static <T extends java.lang.annotation.Annotation> T newInstance(Annotation<?> annotationSource) {
            try {
                Class<?> annotationClass = Class.forName(annotationSource.getQualifiedName());
                return (T)((java.lang.annotation.Annotation)Proxy.newProxyInstance(annotationClass.getClassLoader(), new Class[]{annotationClass}, new AnnotationProxy(annotationClass, annotationSource)));
            }
            catch (Exception e) {
                throw InspectorException.newException((Throwable)e);
            }
        }

        private AnnotationProxy(Class<T> annotationClass, Annotation<?> annotationSource) {
            this.annotationSource = annotationSource;
            this.annotationClass = annotationClass;
        }

        @Override
        public Object invoke(Object proxy, java.lang.reflect.Method method, Object[] args) throws Throwable {
            try {
                String methodName = method.getName();
                if ("annotationType".equals(methodName)) {
                    return this.annotationClass;
                }
                java.lang.reflect.Method annotationMethod = this.annotationClass.getMethod(methodName, new Class[0]);
                String literalValue = this.annotationSource.getLiteralValue(methodName);
                if (literalValue == null) {
                    Object defaultValue = annotationMethod.getDefaultValue();
                    if (defaultValue == null) {
                        throw new UnsupportedOperationException(methodName + " does not have a default value");
                    }
                    return defaultValue;
                }
                return this.parse(literalValue, annotationMethod.getReturnType());
            }
            catch (Exception e) {
                throw InspectorException.newException((Throwable)e);
            }
        }

        private Object parse(String literalValue, Class<?> returnType) throws ClassNotFoundException {
            if (Byte.TYPE.equals(returnType)) {
                return Byte.valueOf(literalValue);
            }
            if (Short.TYPE.equals(returnType)) {
                return Short.valueOf(literalValue);
            }
            if (Integer.TYPE.equals(returnType)) {
                return Integer.valueOf(literalValue);
            }
            if (Long.TYPE.equals(returnType)) {
                String valueToUse = literalValue;
                if (valueToUse.endsWith("l") || valueToUse.endsWith("L")) {
                    valueToUse = valueToUse.substring(0, valueToUse.length() - 1);
                }
                return Long.valueOf(valueToUse);
            }
            if (Float.TYPE.equals(returnType)) {
                String valueToUse = literalValue;
                if (valueToUse.endsWith("f") || valueToUse.endsWith("F")) {
                    valueToUse = valueToUse.substring(0, valueToUse.length() - 1);
                }
                return Float.valueOf(valueToUse);
            }
            if (Double.TYPE.equals(returnType)) {
                String valueToUse = literalValue;
                if (valueToUse.endsWith("d") || valueToUse.endsWith("D")) {
                    valueToUse = literalValue.substring(0, valueToUse.length() - 1);
                }
                return Double.valueOf(valueToUse);
            }
            if (Boolean.TYPE.equals(returnType)) {
                return Boolean.valueOf(literalValue);
            }
            if (Character.TYPE.equals(returnType)) {
                return Character.valueOf(literalValue.charAt(1));
            }
            if (returnType.isArray()) {
                String[] values = literalValue.substring(1, literalValue.length() - 1).split(",");
                int length = values.length;
                Class<?> componentType = returnType.getComponentType();
                Object array = Array.newInstance(componentType, length);
                for (int loop = 0; loop < length; ++loop) {
                    Array.set(array, loop, this.parse(values[loop], componentType));
                }
                return array;
            }
            if (returnType.isEnum()) {
                Enum[] constants = (Enum[])returnType.getEnumConstants();
                String valueToUse = StringUtils.substringAfterLast((String)literalValue, (char)'.');
                for (Enum inst : constants) {
                    if (!inst.name().equals(valueToUse)) continue;
                    return inst;
                }
                return null;
            }
            if (String.class.equals(returnType)) {
                return literalValue.substring(1, literalValue.length() - 1);
            }
            if (Class.class.equals(returnType)) {
                String resolvedType = StringUtils.substringBefore((String)literalValue, (String)".class");
                resolvedType = ((JavaSource)this.annotationSource.getOrigin()).resolveType(resolvedType);
                return Class.forName(resolvedType);
            }
            if (java.lang.annotation.Annotation.class.isAssignableFrom(returnType)) {
                String resolvedType = StringUtils.substringAfter((String)literalValue, (String)"@");
                resolvedType = ((JavaSource)this.annotationSource.getOrigin()).resolveType(resolvedType);
                return AnnotationProxy.newInstance(this.annotationSource);
            }
            throw new UnsupportedOperationException(returnType.getSimpleName());
        }
    }

    public static class ForgeProperty
    extends BaseProperty {
        private final Method<?> readMethod;
        private final Method<?> writeMethod;
        private final Field<?> privateField;
        private final Project project;

        public ForgeProperty(String name, String type, Method<?> readMethod, Method<?> writeMethod, Field<?> privateField, Project project) {
            super(name, type);
            this.readMethod = readMethod;
            this.writeMethod = writeMethod;
            if (this.readMethod == null && this.writeMethod == null) {
                throw InspectorException.newException((String)("Property '" + name + "' has no getter and no setter"));
            }
            this.privateField = privateField;
            this.project = project;
        }

        public boolean isReadable() {
            return this.readMethod != null;
        }

        public Object read(Object obj) {
            throw new UnsupportedOperationException();
        }

        public boolean isWritable() {
            return this.writeMethod != null;
        }

        public void write(Object obj, Object value) {
            throw new UnsupportedOperationException();
        }

        public <T extends java.lang.annotation.Annotation> T getAnnotation(Class<T> annotationClass) {
            Annotation annotation = null;
            if (this.readMethod != null) {
                annotation = this.readMethod.getAnnotation(annotationClass.getName());
            }
            if (annotation == null && this.privateField != null) {
                annotation = this.privateField.getAnnotation(annotationClass.getName());
            }
            if (annotation != null) {
                Object annotationProxy = AnnotationProxy.newInstance(annotation);
                return annotationProxy;
            }
            return null;
        }

        public List<EnumConstant<JavaEnum>> getEnumConstants() {
            JavaSource<?> source = ForgePropertyStyle.sourceForName(this.project, this.getType());
            if (source instanceof JavaEnum) {
                return ((JavaEnum)source).getEnumConstants();
            }
            return null;
        }

        public String getGenericType() {
            List typeArguments;
            if (this.readMethod != null && !(typeArguments = this.readMethod.getReturnTypeInspector().getTypeArguments()).isEmpty()) {
                return ((Type)typeArguments.get(0)).getQualifiedName();
            }
            if (this.privateField != null && !(typeArguments = this.privateField.getTypeInspector().getTypeArguments()).isEmpty()) {
                return ((Type)typeArguments.get(0)).getQualifiedName();
            }
            return null;
        }

        public Method<?> getReadMethod() {
            return this.readMethod;
        }

        public Method<?> getWriteMethod() {
            return this.writeMethod;
        }
    }
}

