/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.scaffold.faces.util;

import java.io.FileNotFoundException;
import org.jboss.forge.parser.java.Field;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.Member;
import org.jboss.forge.parser.java.Method;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.metawidget.util.simple.StringUtils;

public class AnnotationLookup {
    public static final String JAVA_EXTENSION = ".java";
    private Project project;

    public AnnotationLookup(Project project) {
        this.project = project;
    }

    public Member lookup(Class annotation, String qualifiedType) throws FileNotFoundException {
        JavaSourceFacet java = (JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class);
        JavaSource javaSource = java.getJavaResource(qualifiedType).getJavaSource();
        Member member = this.lookup((JavaSource<? extends JavaSource>)javaSource, annotation);
        return member;
    }

    public String getFieldName(Member member) {
        if (null == member) {
            return null;
        }
        if (member instanceof Method) {
            String methodName = member.getName();
            return StringUtils.decapitalize((String)methodName.substring(3));
        }
        if (member instanceof Field) {
            return member.getName();
        }
        return null;
    }

    public String getFieldName(Class annotation, String qualifiedType) throws FileNotFoundException {
        Member member = this.lookup(annotation, qualifiedType);
        return this.getFieldName(member);
    }

    public Member lookup(JavaSource<? extends JavaSource> javaSource, Class ann) {
        for (Member member : javaSource.getMembers()) {
            if (!member.hasAnnotation(ann)) continue;
            return member;
        }
        return null;
    }
}

