/*
 * JBoss, the OpenSource EJB server
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */
package javax.resource.spi;

/**
 * A marker interface holding the configuration of a message endpoint.
 * 
 * An instance must be a javabean and be serializable.
 */
public interface ActivationSpec extends ResourceAdapterAssociation
{
   /**
	 * Optional method that can be used to check configuration by a deployment
	 * tool.
	 * 
	 * @throws InvalidPropertyException for invalid configuration
	 */
   void validate() throws InvalidPropertyException;
}