/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.function;

import java.util.HashMap;
import java.util.List;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;
import org.jaxen.function.StringFunction;

public class TranslateFunction
implements Function {
    public Object call(Context context, List args) throws FunctionCallException {
        if (args.size() == 3) {
            return TranslateFunction.evaluate(args.get(0), args.get(1), args.get(2), context.getNavigator());
        }
        throw new FunctionCallException("translate() requires three arguments.");
    }

    public static String evaluate(Object strArg, Object fromArg, Object toArg, Navigator nav) {
        String inStr = StringFunction.evaluate(strArg, nav);
        String fromStr = StringFunction.evaluate(fromArg, nav);
        String toStr = StringFunction.evaluate(toArg, nav);
        HashMap<String, Character> charMap = new HashMap<String, Character>();
        int fromLen = fromStr.length();
        int toLen = toStr.length();
        for (int i = 0; i < fromLen; ++i) {
            String cFrom = fromStr.substring(i, i + 1).intern();
            if (charMap.containsKey(cFrom)) continue;
            if (i < toLen) {
                Character cTo = new Character(toStr.charAt(i));
                charMap.put(cFrom, cTo);
                continue;
            }
            charMap.put(cFrom, null);
        }
        StringBuffer outStr = new StringBuffer(inStr.length());
        int inLen = inStr.length();
        for (int i = 0; i < inLen; ++i) {
            String cIn = inStr.substring(i, i + 1);
            if (charMap.containsKey(cIn)) {
                Character cTo = (Character)charMap.get(cIn);
                if (cTo == null) continue;
                outStr.append(cTo.charValue());
                continue;
            }
            outStr.append(cIn);
        }
        return new String(outStr);
    }
}

