/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.twiddle.command;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.beans.PropertyEditor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.jboss.console.twiddle.command.CommandException;
import org.jboss.console.twiddle.command.MBeanServerCommand;
import org.jboss.util.Strings;
import org.jboss.util.propertyeditor.PropertyEditors;

public class SetAttrsCommand
extends MBeanServerCommand {
    private ObjectName objectName;
    private List attributeNames = new ArrayList(5);

    public SetAttrsCommand() {
        super("setattrs", "Set the values of one or more MBean attributes");
    }

    public void displayHelp() {
        PrintWriter out = this.context.getWriter();
        out.println(this.desc);
        out.println();
        out.println("usage: " + this.name + " [options] <name> [<attr value>+]");
        out.println("options:");
        out.println("    --noprefix    Do not display attribute name prefixes");
        out.println("    --            Stop processing options");
        out.flush();
    }

    private boolean processArguments(String[] args) throws CommandException {
        int code;
        this.log.debug((Object)("processing arguments: " + Strings.join((Object[])args, (String)",")));
        if (args.length == 0) {
            throw new CommandException("Command requires arguments");
        }
        String sopts = "-:";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("noprefix", 0, null, 4096)};
        Getopt getopt = new Getopt(null, args, sopts, lopts);
        getopt.setOpterr(false);
        int argidx = 0;
        while ((code = getopt.getopt()) != -1) {
            block0 : switch (code) {
                case 58: {
                    throw new CommandException("Option requires an argument: " + args[getopt.getOptind() - 1]);
                }
                case 63: {
                    throw new CommandException("Invalid (or ambiguous) option: " + args[getopt.getOptind() - 1]);
                }
                case 4096: {
                    break;
                }
                case 1: {
                    String arg = getopt.getOptarg();
                    switch (argidx++) {
                        case 0: {
                            this.objectName = this.createObjectName(arg);
                            this.log.debug((Object)("mbean name: " + this.objectName));
                            break block0;
                        }
                    }
                    this.log.debug((Object)("adding attribute name: " + arg));
                    this.attributeNames.add(arg);
                    break;
                }
            }
        }
        return true;
    }

    public void execute(String[] args) throws Exception {
        this.processArguments(args);
        if (this.objectName == null) {
            throw new CommandException("Missing object name");
        }
        this.log.debug((Object)("attribute names: " + this.attributeNames));
        MBeanServerConnection server = this.getMBeanServer();
        if (this.attributeNames.size() == 0) {
            throw new CommandException("at least 1 attribute and value needs to be defined");
        }
        MBeanInfo info = server.getMBeanInfo(this.objectName);
        MBeanAttributeInfo[] attribute_info = info.getAttributes();
        AttributeList attrs = new AttributeList(this.attributeNames.size());
        Iterator it = this.attributeNames.iterator();
        while (it.hasNext()) {
            String attr_name = (String)it.next();
            Object attr_value = it.next();
            MBeanAttributeInfo attr_info = this.findAttribute(attr_name, attribute_info);
            if (attr_info == null) {
                throw new CommandException("attribute " + attr_name + " not found");
            }
            String type = attr_info.getType();
            PropertyEditor editor = PropertyEditors.getEditor((String)type);
            editor.setAsText((String)attr_value);
            Object real_value = editor.getValue();
            Attribute attr = new Attribute(attr_name, real_value);
            attrs.add(attr);
        }
        AttributeList ret = server.setAttributes(this.objectName, attrs);
        System.out.println("The following attributes were set successfuly:");
        if (ret.size() > 0) {
            for (Attribute a : ret) {
                System.out.println(a.getName() + "=" + a.getValue());
            }
        }
    }

    private MBeanAttributeInfo findAttribute(String attr_name, MBeanAttributeInfo[] attribute_info) {
        for (int i = 0; i < attribute_info.length; ++i) {
            MBeanAttributeInfo mBeanAttributeInfo = attribute_info[i];
            if (!mBeanAttributeInfo.getName().equals(attr_name)) continue;
            return mBeanAttributeInfo;
        }
        return null;
    }
}

