/**
 * Copyright (c) Red Hat, Inc., contributors and others 2013 - 2014. All rights reserved
 *
 * Licensed under the Eclipse Public License version 1.0, available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.jboss.tools.forge.ui.internal.ext.control;

import org.eclipse.swt.widgets.Control;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.tools.forge.ui.internal.ext.control.many.CheckboxTableControlBuilder;
import org.jboss.tools.forge.ui.internal.ext.control.many.DirectoryChooserMultipleControlBuilder;
import org.jboss.tools.forge.ui.internal.ext.control.many.FileChooserMultipleControlBuilder;
import org.jboss.tools.forge.ui.internal.ext.control.many.JavaClassChooserMultipleControlBuilder;
import org.jboss.tools.forge.ui.internal.ext.control.many.TextBoxMultipleControlBuilder;

/**
 * A factory for {@link ControlBuilder} instances.
 *
 * @author <a href="mailto:ggastald@redhat.com">George Gastaldi</a>
 *
 */
public class ControlBuilderRegistry {

	private static final ControlBuilder<?>[] CONTROL_BUILDERS = {
			new CheckboxControlBuilder(), new ComboControlBuilder(),
			new RadioControlBuilder(), new FileChooserControlBuilder(),
			new DirectoryChooserControlBuilder(),
			new CheckboxTableControlBuilder(), new TextBoxControlBuilder(),
			new SpinnerControlBuilder(), new PasswordTextBoxControlBuilder(),
			new JavaPackageChooserControlBuilder(),
			new JavaClassChooserControlBuilder(),
			new TextBoxMultipleControlBuilder(),
			new TextAreaBoxControlBuilder(),
			new FileChooserMultipleControlBuilder(),
			new DirectoryChooserMultipleControlBuilder(),
			new JavaClassChooserMultipleControlBuilder(),
			new FallbackTextBoxControlBuilder() };

	@SuppressWarnings("unchecked")
	public static <T extends Control> ControlBuilder<T> getBuilderFor(
			InputComponent<?, ?> input) {
		for (ControlBuilder<?> builder : CONTROL_BUILDERS) {
			if (builder.handles(input)) {
				return (ControlBuilder<T>) builder;
			}
		}
		throw new IllegalArgumentException(
				"No UI component found for input type of "
						+ input.getValueType());
	}
}
