/*******************************************************************************
 * Copyright (c) 2007 Exadel, Inc. and Red Hat, Inc.
 * Distributed under license by Red Hat, Inc. All rights reserved.
 * This program is made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Exadel, Inc. and Red Hat, Inc. - initial API and implementation
 ******************************************************************************/ 
package org.jboss.tools.jsf.vpe.ajax4jsf.template;


import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
/**
 * 
 * @author Dzmitry Sakovich (dsakovich@exadel.com)
 * @author yradtsevich
 */

public class Ajax4JSFReapeatTemplate extends VpeAbstractTemplate {

	public VpeCreationData create(VpePageContext pageContext, Node sourceNode,
			nsIDOMDocument visualDocument) {		
		VpeCreationData vpeCreationData = new VpeCreationData(null);
		VpeChildrenInfo vpeChildrenInfo = new VpeChildrenInfo(null);
		vpeCreationData.addChildrenInfo(vpeChildrenInfo);
		
		NodeList children = sourceNode.getChildNodes();
		int childrenLength = children.getLength();
		for (int i = 0; i < childrenLength; i++) {
			Node child = children.item(i);
			if (child.getNodeType() == Node.ELEMENT_NODE) {
				vpeChildrenInfo.addSourceChild(child);
			}
		}
		
		return vpeCreationData;
	}
		
}
