/******************************************************************************* 
 * Copyright (c) 2013 Red Hat, Inc. 
 * Distributed under license by Red Hat, Inc. All rights reserved. 
 * This program is made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, 
 * and is available at http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors: 
 * Red Hat, Inc. - initial API and implementation 
 ******************************************************************************/ 
package org.jboss.tools.jst.web.ui.palette.html.jquery.wizard;

import org.jboss.tools.common.model.ui.editors.dnd.DropWizardMessages;
import org.jboss.tools.common.model.ui.editors.dnd.IElementGenerator.ElementNode;
import org.jboss.tools.jst.web.ui.JSTWebUIImages;

/**
 * 
 * @author Viacheslav Kabanovich
 *
 */
public class NewCheckBoxWizard extends NewJQueryWidgetWizard<NewCheckBoxWizardPage> implements JQueryConstants {
	static String prefixName = "checkbox-";
	static String prefixId = "checkbox-";

	public NewCheckBoxWizard() {
		setWindowTitle(DropWizardMessages.Wizard_Window_Title);
		setDefaultPageImageDescriptor(JSTWebUIImages.getInstance()
				.getOrCreateImageDescriptor(JSTWebUIImages.CHECKBOX_IMAGE));
	}

	protected NewCheckBoxWizardPage createPage() {
		return new NewCheckBoxWizardPage();
	}

	protected void addContent(ElementNode parent) {
		String themeValue = page.getEditorValue(EDITOR_ID_THEME);
		ElementNode input = null;
		if(isMini()) {
			String name = prefixName + generateIndex(prefixName, "", 1);
			input = parent.addChild(TAG_INPUT);
			input.addAttribute(ATTR_TYPE, TYPE_CHECKBOX);
			input.addAttribute(ATTR_NAME, name);
			String id = addID(prefixId, input);
			input.addAttribute(ATTR_CLASS, CLASS_CUSTOM);
			input.addAttribute(ATTR_DATA_MINI, TRUE);
			ElementNode label = parent.addChild(TAG_LABEL, page.getEditorValue(EDITOR_ID_LABEL));
			label.addAttribute(ATTR_FOR, id);
		} else {
			ElementNode label = parent.addChild(TAG_LABEL, page.getEditorValue(EDITOR_ID_LABEL));
			String name = prefixName + generateIndex(prefixName, "", 1);
			input = label.addChild(TAG_INPUT);
			input.addAttribute(ATTR_TYPE, TYPE_CHECKBOX);
			input.addAttribute(ATTR_NAME, name);
			addID(prefixId, input);
		}
		String iconpos = page.getEditorValue(EDITOR_ID_ICON_POS);
		if(iconpos.length() > 0) {
			input.addAttribute(ATTR_DATA_ICONPOS, iconpos);
		}
		if(themeValue.length() > 0) {
			input.addAttribute(ATTR_DATA_THEME, themeValue);
		}
	}

	protected void createBodyForBrowser(ElementNode body) {
		ElementNode form = getFormNode(body);
		ElementNode div = form.addChild(TAG_DIV);
		div.addAttribute(ATTR_STYLE, "padding: 20px 20px 20px 20px;");
		addContent(div);
	}
	
}
