/*
 * JBoss, the OpenSource EJB server
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */
package javax.resource.spi;

import java.util.Set;

import javax.resource.ResourceException;

/**
 * A mixin interface for connection factories that can validate their managed connections
 */
public interface ValidatingManagedConnectionFactory
{
   /**
    * Returns the invalid connections in a set
    *
    * @param connectionSet the set of connections to validate
    * @return the set of invalid connections
    * @throws ResourceException for a generic error
    */
   Set getInvalidConnections(Set connectionSet) throws ResourceException;
}