/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.twiddle.command;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.jboss.console.twiddle.command.CommandException;
import org.jboss.console.twiddle.command.MBeanServerCommand;
import org.jboss.util.Strings;

public class GetCommand
extends MBeanServerCommand {
    private ObjectName objectName;
    private List attributeNames = new ArrayList(5);
    private boolean prefix = true;

    public GetCommand() {
        super("get", "Get the values of one or more MBean attributes");
    }

    public void displayHelp() {
        PrintWriter out = this.context.getWriter();
        out.println(this.desc);
        out.println();
        out.println("usage: " + this.name + " [options] <name> [<attr>+]");
        out.println("  If no attribute names are given all readable attributes are retrieved");
        out.println("options:");
        out.println("    --noprefix    Do not display attribute name prefixes");
        out.println("    --            Stop processing options");
        out.flush();
    }

    private boolean processArguments(String[] args) throws CommandException {
        int code;
        this.log.debug((Object)("processing arguments: " + Strings.join((Object[])args, (String)",")));
        if (args.length == 0) {
            throw new CommandException("Command requires arguments");
        }
        String sopts = "-:";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("noprefix", 0, null, 4096)};
        Getopt getopt = new Getopt(null, args, sopts, lopts);
        getopt.setOpterr(false);
        int argidx = 0;
        while ((code = getopt.getopt()) != -1) {
            block0 : switch (code) {
                case 58: {
                    throw new CommandException("Option requires an argument: " + args[getopt.getOptind() - 1]);
                }
                case 63: {
                    throw new CommandException("Invalid (or ambiguous) option: " + args[getopt.getOptind() - 1]);
                }
                case 4096: {
                    this.prefix = false;
                    break;
                }
                case 1: {
                    String arg = getopt.getOptarg();
                    switch (argidx++) {
                        case 0: {
                            this.objectName = this.createObjectName(arg);
                            this.log.debug((Object)("mbean name: " + this.objectName));
                            break block0;
                        }
                    }
                    this.log.debug((Object)("adding attribute name: " + arg));
                    this.attributeNames.add(arg);
                    break;
                }
            }
        }
        return true;
    }

    public void execute(String[] args) throws Exception {
        this.processArguments(args);
        if (this.objectName == null) {
            throw new CommandException("Missing object name");
        }
        this.log.debug((Object)("attribute names: " + this.attributeNames));
        MBeanServerConnection server = this.getMBeanServer();
        if (this.attributeNames.size() == 0) {
            this.attributeNames.clear();
            MBeanInfo info = server.getMBeanInfo(this.objectName);
            MBeanAttributeInfo[] attrInfos = info.getAttributes();
            for (int a = 0; a < attrInfos.length; ++a) {
                MBeanAttributeInfo attrInfo = attrInfos[a];
                if (!attrInfo.isReadable()) continue;
                this.attributeNames.add(attrInfo.getName());
            }
        }
        Object[] names = new String[this.attributeNames.size()];
        this.attributeNames.toArray(names);
        this.log.debug((Object)("as string[]: " + Strings.join((Object[])names, (String)",")));
        AttributeList attrList = server.getAttributes(this.objectName, (String[])names);
        this.log.debug((Object)("attribute list: " + attrList));
        if (attrList.size() == 0) {
            throw new CommandException("No matching attributes");
        }
        if (attrList.size() != names.length) {
            this.log.warn((Object)"Not all specified attributes were found");
        }
        PrintWriter out = this.context.getWriter();
        for (Attribute attr : attrList) {
            if (this.prefix) {
                out.print(attr.getName());
                out.print("=");
            }
            out.println(attr.getValue());
        }
    }
}

