/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.twiddle.command;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.beans.PropertyEditor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.jboss.console.twiddle.command.CommandException;
import org.jboss.console.twiddle.command.MBeanServerCommand;
import org.jboss.util.Strings;
import org.jboss.util.propertyeditor.PropertyEditors;

public class SetCommand
extends MBeanServerCommand {
    private ObjectName objectName;
    private List attributeNames = new ArrayList(5);
    private boolean prefix = true;
    private String query;

    public SetCommand() {
        super("set", "Set the value of one MBean attribute");
    }

    public void displayHelp() {
        PrintWriter out = this.context.getWriter();
        out.println(this.desc);
        out.println();
        out.println("usage: " + this.name + " [options] <name> <attr> <val>");
        out.println("options:");
        out.println("    --noprefix    Do not display attribute name prefixes");
        out.println("    --            Stop processing options");
        out.flush();
    }

    private boolean processArguments(String[] args) throws CommandException {
        int code;
        this.log.debug((Object)("processing arguments: " + Strings.join((Object[])args, (String)",")));
        if (args.length == 0) {
            throw new CommandException("Command requires arguments");
        }
        String sopts = "-:";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("noprefix", 0, null, 4096)};
        Getopt getopt = new Getopt(null, args, sopts, lopts);
        getopt.setOpterr(false);
        int argidx = 0;
        while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: {
                    throw new CommandException("Option requires an argument: " + args[getopt.getOptind() - 1]);
                }
                case 63: {
                    String arg = args[getopt.getOptind() - 1];
                    argidx = this.setArgValues(argidx, arg);
                    break;
                }
                case 4096: {
                    this.prefix = false;
                    break;
                }
                case 1: {
                    String arg = getopt.getOptarg();
                    argidx = this.setArgValues(argidx, arg);
                    break;
                }
            }
        }
        return true;
    }

    public void execute(String[] args) throws Exception {
        this.processArguments(args);
        String theAttr = (String)this.attributeNames.toArray()[0];
        String theVal = (String)this.attributeNames.toArray()[1];
        if (this.objectName == null) {
            throw new CommandException("Missing object name");
        }
        this.log.debug((Object)("attribute names: " + this.attributeNames));
        if (this.attributeNames.size() != 2) {
            throw new CommandException("Wrong number of arguments");
        }
        MBeanServerConnection server = this.getMBeanServer();
        MBeanInfo info = server.getMBeanInfo(this.objectName);
        MBeanAttributeInfo[] attrs = info.getAttributes();
        MBeanAttributeInfo attr = null;
        boolean found = false;
        for (int i = 0; i < attrs.length; ++i) {
            if (!attrs[i].getName().equals(theAttr) || !attrs[i].isWritable()) continue;
            found = true;
            attr = attrs[i];
            break;
        }
        if (!found) {
            throw new CommandException("No matching attribute found");
        }
        Object oVal = this.convert(theVal, attr.getType());
        Attribute at = new Attribute(theAttr, oVal);
        server.setAttribute(this.objectName, at);
        if (!this.context.isQuiet()) {
            PrintWriter out = this.context.getWriter();
            Object nat = server.getAttribute(this.objectName, theAttr);
            if (nat == null) {
                out.println("null");
            } else if (this.prefix) {
                out.print(theAttr + "=");
            }
            out.println(nat.toString());
        }
    }

    private int setArgValues(int argdixValue, String argValue) throws CommandException {
        switch (argdixValue++) {
            case 0: {
                this.objectName = this.createObjectName(argValue);
                this.log.debug((Object)("mbean name: " + this.objectName));
                break;
            }
            default: {
                this.log.debug((Object)("adding attribute name: " + argValue));
                this.attributeNames.add(argValue);
            }
        }
        return argdixValue;
    }

    private Object convert(String val, String oType) throws Exception {
        PropertyEditor editor = PropertyEditors.getEditor((String)oType);
        editor.setAsText(val);
        return editor.getValue();
    }
}

