/*
 * JBoss, the OpenSource EJB server
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */
package javax.resource.spi.endpoint;

import java.lang.reflect.Method;

import javax.resource.spi.UnavailableException;
import javax.transaction.xa.XAResource;

/**
 * A factory for message end points
 */
public interface MessageEndpointFactory
{
   /**
    * Creates a message endpoint
    *
    * @param resource the xa resource
    * @return the message endpoint
    * @throws UnavailableException a transient failure in the endpoint
    */
   MessageEndpoint createEndpoint(XAResource resource) throws UnavailableException;

   /**
    * Tests whether the delivery is transactional for the given method
    *
    * @param method the method to test
    * @return true for transacted delivery, false otherwise
    * @throws NoSuchMethodException if there is no such method for the endpoint
    */
   boolean isDeliveryTransacted(Method method) throws NoSuchMethodException;
}