/******************************************************************************* 
 * Copyright (c) 2014 Red Hat, Inc. 
 * Distributed under license by Red Hat, Inc. All rights reserved. 
 * This program is made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, 
 * and is available at http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors: 
 * Red Hat, Inc. - initial API and implementation 
 ******************************************************************************/ 
package org.jboss.tools.jst.web.ui.palette.internal;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jboss.tools.common.model.ui.internal.editors.PaletteItemResult;
import org.jboss.tools.common.text.IExecutableTextProposal;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPMultiPageEditor;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPTextEditor;
import org.jboss.tools.jst.web.ui.palette.html.wizard.AbstractNewHTMLWidgetWizard;

/**
 * Objects of this class are returned by PaletteManager. and items of Palette.
 * It contains category name, version name, item name,
 * and can compute result generated by wizard with default settings.
 * 
 * @author Viacheslav Kabanovich
 *
 */
public class RunnablePaletteItem implements IExecutableTextProposal {
	String category;
	String version;
	String name;
	List<String> alternatives = new ArrayList<String>();

	public RunnablePaletteItem(String category, String version, String name) {
		this.category = category;
		this.version = version;
		this.name = name;
	}

	/**
	 * 
	 * @return category of palette item
	 */
	public String getCategory() {
		return category;
	}

	/**
	 * 
	 * @return category version of palette item 
	 */
	public String getVersion() {
		return version;
	}

	/**
	 * 
	 * @return name of palette item
	 */
	public String getName() {
		return name;
	}

	/**
	 * List of logic names by which this item can be invoked.
	 * @return
	 */
	public List<String> getAlternatives() {
		return alternatives;
	}

	/**
	 * 
	 * @param textEditor
	 * @return result of generation of palette item wizard with default settings
	 */
	public PaletteItemResult getResult(JSPTextEditor textEditor) {
		return AbstractNewHTMLWidgetWizard.runWithoutUi(textEditor, category, version, name);
	}

	@Override
	public void apply(ITextEditor textEditor, int startOffset, int endOffset) {
		JSPTextEditor jsp = null;
		if(textEditor instanceof JSPTextEditor) {
			jsp = (JSPTextEditor)textEditor;
		} else if(textEditor instanceof JSPMultiPageEditor) {
			jsp = ((JSPMultiPageEditor)textEditor).getJspEditor();
		} else {
			return;
		}
		IDocument document = jsp.getTextViewer().getDocument();
		try {
			if(endOffset > startOffset) {
				document.replace(startOffset, endOffset - startOffset, "");
			}
		} catch (BadLocationException e) {
			WebUiPlugin.getDefault().logError(e);
		} catch (StringIndexOutOfBoundsException e) {
			WebUiPlugin.getDefault().logError(e);
		}

		AbstractNewHTMLWidgetWizard.applyWithoutUi(jsp, this);
	}

}
