/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2016, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.as.clustering.infinispan.subsystem.remote;

import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheConfiguration;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.jboss.as.clustering.infinispan.subsystem.ComponentBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.service.Builder;

/**
 * @author Radoslav Husar
 */
public class InvalidationNearCacheBuilder extends ComponentBuilder<NearCacheConfiguration> {

    private volatile int maxEntries;

    InvalidationNearCacheBuilder(PathAddress address) {
        super(RemoteCacheContainerComponent.NEAR_CACHE, address);
    }

    @Override
    public Builder<NearCacheConfiguration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.maxEntries = InvalidationNearCacheResourceDefinition.Attribute.MAX_ENTRIES.resolveModelAttribute(context, model).asInt();
        return this;
    }

    @Override
    public NearCacheConfiguration getValue() {
        return new ConfigurationBuilder().nearCache()
                .mode(NearCacheMode.INVALIDATED)
                .maxEntries(this.maxEntries)
                .create();
    }
}
