package org.jboss.eap.util.xp.patch.stream.manager;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

import org.jboss.dmr.ModelNode;

/**
 * @author <a href="mailto:kabir.khan@jboss.com">Kabir Khan</a>
 */
public class OperationBuilder {
    private final String name;
    private Map<String, String> address = new LinkedHashMap<>();
    private Map<String, String> parameters = new HashMap<>();

    public OperationBuilder(String name) {
        this.name = name;
    }

    public OperationBuilder addr(String key, String value) {
        address.put(key, value);
        return this;
    }

    public OperationBuilder param(String key, String value) {
        parameters.put(key, value);
        return this;
    }

    public ModelNode build() {
        ModelNode op = new ModelNode();
        op.get("operation").set(name);

        ModelNode addr = new ModelNode().setEmptyList();
        for (Map.Entry<String, String> entry : address.entrySet()) {
            addr.add(entry.getKey(), entry.getValue());
        }
        op.get("address").set(addr);

        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            op.get(entry.getKey()).set(entry.getValue());
        }

        return op;
    }
}
