package org.jboss.eap.util.xp.patch.stream.manager;

/**
 * @author <a href="mailto:kabir.khan@jboss.com">Kabir Khan</a>
 */
public class ServerVersion implements Comparable<ServerVersion> {
    private final int major;
    private final int minor;
    private final int micro;
    private final String qualifier;

    private ServerVersion(int major, int minor, int micro, String qualifier) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.qualifier = qualifier;
    }

    public static ServerVersion parse(String input) {
        String[] parts = input.split("\\.");
        return new ServerVersion(
                Integer.valueOf(parts[0]),
                Integer.valueOf(parts[1]),
                Integer.valueOf(parts[2]),
                parts.length > 3 ? parts[3] : "GA");
    }

    @Override
    public String toString() {
        return major + "." + minor + "." + micro + "." + qualifier;
    }

    @Override
    public int compareTo(ServerVersion o) {

        if (major < o.major) {
            return -1;
        } else if (major > o.major) {
            return 1;
        }

        if (minor < o.minor) {
            return -1;
        } else if (minor > o.minor) {
            return 1;
        }

        if (micro < o.micro) {
            return -1;
        } else if (micro > o.micro) {
            return 1;
        }

        return 0;
    }

}
