/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.quarkus.component.aws2.kinesis.it;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.apache.camel.CamelContext;
import org.jboss.logging.Logger;

@Path("/aws2-kinesis")
@ApplicationScoped
public class Aws2KinesisResource {

    private static final Logger LOG = Logger.getLogger(Aws2KinesisResource.class);

    private static final String COMPONENT_AWS2_KINESIS = "aws2-kinesis";
    private static final String COMPONENT_AWS2_KINESIS_FIREHOSE = "aws2-kinesis-firehose";
    @Inject
    CamelContext context;

    @Path("/load/component/aws2-kinesis")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentAws2Kinesis() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_AWS2_KINESIS) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_AWS2_KINESIS);
        return Response.status(500, COMPONENT_AWS2_KINESIS + " could not be loaded from the Camel context").build();
    }

    @Path("/load/component/aws2-kinesis-firehose")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentAws2KinesisFirehose() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_AWS2_KINESIS_FIREHOSE) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_AWS2_KINESIS_FIREHOSE);
        return Response.status(500, COMPONENT_AWS2_KINESIS_FIREHOSE + " could not be loaded from the Camel context").build();
    }
}
