/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.quarkus.component.openstack.it;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.apache.camel.CamelContext;
import org.jboss.logging.Logger;

@Path("/openstack")
@ApplicationScoped
public class OpenstackResource {

    private static final Logger LOG = Logger.getLogger(OpenstackResource.class);

    private static final String COMPONENT_OPENSTACK_CINDER = "openstack-cinder";
    private static final String COMPONENT_OPENSTACK_GLANCE = "openstack-glance";
    private static final String COMPONENT_OPENSTACK_KEYSTONE = "openstack-keystone";
    private static final String COMPONENT_OPENSTACK_NEUTRON = "openstack-neutron";
    private static final String COMPONENT_OPENSTACK_NOVA = "openstack-nova";
    private static final String COMPONENT_OPENSTACK_SWIFT = "openstack-swift";
    @Inject
    CamelContext context;

    @Path("/load/component/openstack-cinder")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentOpenstackCinder() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_OPENSTACK_CINDER) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_OPENSTACK_CINDER);
        return Response.status(500, COMPONENT_OPENSTACK_CINDER + " could not be loaded from the Camel context").build();
    }

    @Path("/load/component/openstack-glance")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentOpenstackGlance() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_OPENSTACK_GLANCE) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_OPENSTACK_GLANCE);
        return Response.status(500, COMPONENT_OPENSTACK_GLANCE + " could not be loaded from the Camel context").build();
    }

    @Path("/load/component/openstack-keystone")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentOpenstackKeystone() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_OPENSTACK_KEYSTONE) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_OPENSTACK_KEYSTONE);
        return Response.status(500, COMPONENT_OPENSTACK_KEYSTONE + " could not be loaded from the Camel context").build();
    }

    @Path("/load/component/openstack-neutron")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentOpenstackNeutron() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_OPENSTACK_NEUTRON) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_OPENSTACK_NEUTRON);
        return Response.status(500, COMPONENT_OPENSTACK_NEUTRON + " could not be loaded from the Camel context").build();
    }

    @Path("/load/component/openstack-nova")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentOpenstackNova() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_OPENSTACK_NOVA) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_OPENSTACK_NOVA);
        return Response.status(500, COMPONENT_OPENSTACK_NOVA + " could not be loaded from the Camel context").build();
    }

    @Path("/load/component/openstack-swift")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentOpenstackSwift() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_OPENSTACK_SWIFT) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_OPENSTACK_SWIFT);
        return Response.status(500, COMPONENT_OPENSTACK_SWIFT + " could not be loaded from the Camel context").build();
    }
}
