/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.List;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * Azure Cosmos DB is Microsofts globally distributed, multi-model database
 * service for operational and analytics workloads. It offers multi-mastering
 * feature by automatically scaling throughput, compute, and storage. This
 * component interacts with Azure CosmosDB through Azure SQL API
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface CosmosDbEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Azure CosmosDB component.
     */
    public interface CosmosDbEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedCosmosDbEndpointConsumerBuilder advanced() {
            return (AdvancedCosmosDbEndpointConsumerBuilder) this;
        }
        /**
         * Sets the flag to enable client telemetry which will periodically
         * collect database operations aggregation statistics, system
         * information like cpu/memory and send it to cosmos monitoring service,
         * which will be helpful during debugging. DEFAULT value is false
         * indicating this is opt in feature, by default no telemetry
         * collection.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param clientTelemetryEnabled the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder clientTelemetryEnabled(
                boolean clientTelemetryEnabled) {
            doSetProperty("clientTelemetryEnabled", clientTelemetryEnabled);
            return this;
        }
        /**
         * Sets the flag to enable client telemetry which will periodically
         * collect database operations aggregation statistics, system
         * information like cpu/memory and send it to cosmos monitoring service,
         * which will be helpful during debugging. DEFAULT value is false
         * indicating this is opt in feature, by default no telemetry
         * collection.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param clientTelemetryEnabled the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder clientTelemetryEnabled(
                String clientTelemetryEnabled) {
            doSetProperty("clientTelemetryEnabled", clientTelemetryEnabled);
            return this;
        }
        /**
         * Enables connections sharing across multiple Cosmos Clients. The
         * default is false. When you have multiple instances of Cosmos Client
         * in the same JVM interacting to multiple Cosmos accounts, enabling
         * this allows connection sharing in Direct mode if possible between
         * instances of Cosmos Client. Please note, when setting this option,
         * the connection configuration (e.g., socket timeout config, idle
         * timeout config) of the first instantiated client will be used for all
         * other client instances.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param connectionSharingAcrossClientsEnabled the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder connectionSharingAcrossClientsEnabled(
                boolean connectionSharingAcrossClientsEnabled) {
            doSetProperty("connectionSharingAcrossClientsEnabled", connectionSharingAcrossClientsEnabled);
            return this;
        }
        /**
         * Enables connections sharing across multiple Cosmos Clients. The
         * default is false. When you have multiple instances of Cosmos Client
         * in the same JVM interacting to multiple Cosmos accounts, enabling
         * this allows connection sharing in Direct mode if possible between
         * instances of Cosmos Client. Please note, when setting this option,
         * the connection configuration (e.g., socket timeout config, idle
         * timeout config) of the first instantiated client will be used for all
         * other client instances.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param connectionSharingAcrossClientsEnabled the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder connectionSharingAcrossClientsEnabled(
                String connectionSharingAcrossClientsEnabled) {
            doSetProperty("connectionSharingAcrossClientsEnabled", connectionSharingAcrossClientsEnabled);
            return this;
        }
        /**
         * Sets the consistency levels supported for Azure Cosmos DB client
         * operations in the Azure Cosmos DB service. The requested
         * ConsistencyLevel must match or be weaker than that provisioned for
         * the database account. Consistency levels by order of strength are
         * STRONG, BOUNDED_STALENESS, SESSION and EVENTUAL. Refer to consistency
         * level documentation for additional details:
         * https://docs.microsoft.com/en-us/azure/cosmos-db/consistency-levels.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.cosmos.ConsistencyLevel&lt;/code&gt; type.
         * 
         * Default: SESSION
         * Group: common
         * 
         * @param consistencyLevel the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder consistencyLevel(
                ConsistencyLevel consistencyLevel) {
            doSetProperty("consistencyLevel", consistencyLevel);
            return this;
        }
        /**
         * Sets the consistency levels supported for Azure Cosmos DB client
         * operations in the Azure Cosmos DB service. The requested
         * ConsistencyLevel must match or be weaker than that provisioned for
         * the database account. Consistency levels by order of strength are
         * STRONG, BOUNDED_STALENESS, SESSION and EVENTUAL. Refer to consistency
         * level documentation for additional details:
         * https://docs.microsoft.com/en-us/azure/cosmos-db/consistency-levels.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.cosmos.ConsistencyLevel&lt;/code&gt; type.
         * 
         * Default: SESSION
         * Group: common
         * 
         * @param consistencyLevel the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder consistencyLevel(
                String consistencyLevel) {
            doSetProperty("consistencyLevel", consistencyLevel);
            return this;
        }
        /**
         * Sets the container partition key path.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param containerPartitionKeyPath the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder containerPartitionKeyPath(
                String containerPartitionKeyPath) {
            doSetProperty("containerPartitionKeyPath", containerPartitionKeyPath);
            return this;
        }
        /**
         * Sets the boolean to only return the headers and status code in Cosmos
         * DB response in case of Create, Update and Delete operations on
         * CosmosItem. In Consumer, it is enabled by default because of the
         * ChangeFeed in the consumer that needs this flag to be enabled and
         * thus is shouldn't be overridden. In Producer, it advised to disable
         * it since it reduces the network overhead.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param contentResponseOnWriteEnabled the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder contentResponseOnWriteEnabled(
                boolean contentResponseOnWriteEnabled) {
            doSetProperty("contentResponseOnWriteEnabled", contentResponseOnWriteEnabled);
            return this;
        }
        /**
         * Sets the boolean to only return the headers and status code in Cosmos
         * DB response in case of Create, Update and Delete operations on
         * CosmosItem. In Consumer, it is enabled by default because of the
         * ChangeFeed in the consumer that needs this flag to be enabled and
         * thus is shouldn't be overridden. In Producer, it advised to disable
         * it since it reduces the network overhead.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param contentResponseOnWriteEnabled the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder contentResponseOnWriteEnabled(
                String contentResponseOnWriteEnabled) {
            doSetProperty("contentResponseOnWriteEnabled", contentResponseOnWriteEnabled);
            return this;
        }
        /**
         * Inject an external CosmosAsyncClient into the component which
         * provides a client-side logical representation of the Azure Cosmos DB
         * service. This asynchronous client is used to configure and execute
         * requests against the service.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.cosmos.CosmosAsyncClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param cosmosAsyncClient the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder cosmosAsyncClient(
                Object cosmosAsyncClient) {
            doSetProperty("cosmosAsyncClient", cosmosAsyncClient);
            return this;
        }
        /**
         * Inject an external CosmosAsyncClient into the component which
         * provides a client-side logical representation of the Azure Cosmos DB
         * service. This asynchronous client is used to configure and execute
         * requests against the service.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.cosmos.CosmosAsyncClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param cosmosAsyncClient the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder cosmosAsyncClient(
                String cosmosAsyncClient) {
            doSetProperty("cosmosAsyncClient", cosmosAsyncClient);
            return this;
        }
        /**
         * Sets if the component should create Cosmos container automatically in
         * case it doesn't exist in Cosmos database.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param createContainerIfNotExists the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder createContainerIfNotExists(
                boolean createContainerIfNotExists) {
            doSetProperty("createContainerIfNotExists", createContainerIfNotExists);
            return this;
        }
        /**
         * Sets if the component should create Cosmos container automatically in
         * case it doesn't exist in Cosmos database.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param createContainerIfNotExists the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder createContainerIfNotExists(
                String createContainerIfNotExists) {
            doSetProperty("createContainerIfNotExists", createContainerIfNotExists);
            return this;
        }
        /**
         * Sets if the component should create Cosmos database automatically in
         * case it doesn't exist in Cosmos account.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param createDatabaseIfNotExists the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder createDatabaseIfNotExists(
                boolean createDatabaseIfNotExists) {
            doSetProperty("createDatabaseIfNotExists", createDatabaseIfNotExists);
            return this;
        }
        /**
         * Sets if the component should create Cosmos database automatically in
         * case it doesn't exist in Cosmos account.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param createDatabaseIfNotExists the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder createDatabaseIfNotExists(
                String createDatabaseIfNotExists) {
            doSetProperty("createDatabaseIfNotExists", createDatabaseIfNotExists);
            return this;
        }
        /**
         * Sets the Azure Cosmos database endpoint the component will connect
         * to.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: common
         * 
         * @param databaseEndpoint the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder databaseEndpoint(
                String databaseEndpoint) {
            doSetProperty("databaseEndpoint", databaseEndpoint);
            return this;
        }
        /**
         * Sets the flag to enable writes on any regions for geo-replicated
         * database accounts in the Azure Cosmos DB service. When the value of
         * this property is true, the SDK will direct write operations to
         * available writable regions of geo-replicated database account.
         * Writable regions are ordered by PreferredRegions property. Setting
         * the property value to true has no effect until
         * EnableMultipleWriteRegions in DatabaseAccount is also set to true.
         * DEFAULT value is true indicating that writes are directed to
         * available writable regions of geo-replicated database account.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param multipleWriteRegionsEnabled the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder multipleWriteRegionsEnabled(
                boolean multipleWriteRegionsEnabled) {
            doSetProperty("multipleWriteRegionsEnabled", multipleWriteRegionsEnabled);
            return this;
        }
        /**
         * Sets the flag to enable writes on any regions for geo-replicated
         * database accounts in the Azure Cosmos DB service. When the value of
         * this property is true, the SDK will direct write operations to
         * available writable regions of geo-replicated database account.
         * Writable regions are ordered by PreferredRegions property. Setting
         * the property value to true has no effect until
         * EnableMultipleWriteRegions in DatabaseAccount is also set to true.
         * DEFAULT value is true indicating that writes are directed to
         * available writable regions of geo-replicated database account.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param multipleWriteRegionsEnabled the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder multipleWriteRegionsEnabled(
                String multipleWriteRegionsEnabled) {
            doSetProperty("multipleWriteRegionsEnabled", multipleWriteRegionsEnabled);
            return this;
        }
        /**
         * Sets the preferred regions for geo-replicated database accounts. For
         * example, East US as the preferred region. When
         * EnableEndpointDiscovery is true and PreferredRegions is non-empty,
         * the SDK will prefer to use the regions in the container in the order
         * they are specified to perform operations.
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param preferredRegions the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder preferredRegions(
                List<String> preferredRegions) {
            doSetProperty("preferredRegions", preferredRegions);
            return this;
        }
        /**
         * Sets the preferred regions for geo-replicated database accounts. For
         * example, East US as the preferred region. When
         * EnableEndpointDiscovery is true and PreferredRegions is non-empty,
         * the SDK will prefer to use the regions in the container in the order
         * they are specified to perform operations.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param preferredRegions the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder preferredRegions(
                String preferredRegions) {
            doSetProperty("preferredRegions", preferredRegions);
            return this;
        }
        /**
         * Sets whether to allow for reads to go to multiple regions configured
         * on an account of Azure Cosmos DB service. DEFAULT value is true. If
         * this property is not set, the default is true for all Consistency
         * Levels other than Bounded Staleness, The default is false for Bounded
         * Staleness. 1. endpointDiscoveryEnabled is true 2. the Azure Cosmos DB
         * account has more than one region.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param readRequestsFallbackEnabled the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder readRequestsFallbackEnabled(
                boolean readRequestsFallbackEnabled) {
            doSetProperty("readRequestsFallbackEnabled", readRequestsFallbackEnabled);
            return this;
        }
        /**
         * Sets whether to allow for reads to go to multiple regions configured
         * on an account of Azure Cosmos DB service. DEFAULT value is true. If
         * this property is not set, the default is true for all Consistency
         * Levels other than Bounded Staleness, The default is false for Bounded
         * Staleness. 1. endpointDiscoveryEnabled is true 2. the Azure Cosmos DB
         * account has more than one region.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param readRequestsFallbackEnabled the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder readRequestsFallbackEnabled(
                String readRequestsFallbackEnabled) {
            doSetProperty("readRequestsFallbackEnabled", readRequestsFallbackEnabled);
            return this;
        }
        /**
         * Sets throughput of the resources in the Azure Cosmos DB service.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.cosmos.models.ThroughputProperties&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param throughputProperties the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder throughputProperties(
                Object throughputProperties) {
            doSetProperty("throughputProperties", throughputProperties);
            return this;
        }
        /**
         * Sets throughput of the resources in the Azure Cosmos DB service.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.cosmos.models.ThroughputProperties&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param throughputProperties the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder throughputProperties(
                String throughputProperties) {
            doSetProperty("throughputProperties", throughputProperties);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Sets the ChangeFeedProcessorOptions to be used. Unless specifically
         * set the default values that will be used are: maximum items per page
         * or FeedResponse: 100 lease renew interval: 17 seconds lease acquire
         * interval: 13 seconds lease expiration interval: 60 seconds feed poll
         * delay: 5 seconds maximum scale count: unlimited.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.cosmos.models.ChangeFeedProcessorOptions&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param changeFeedProcessorOptions the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder changeFeedProcessorOptions(
                Object changeFeedProcessorOptions) {
            doSetProperty("changeFeedProcessorOptions", changeFeedProcessorOptions);
            return this;
        }
        /**
         * Sets the ChangeFeedProcessorOptions to be used. Unless specifically
         * set the default values that will be used are: maximum items per page
         * or FeedResponse: 100 lease renew interval: 17 seconds lease acquire
         * interval: 13 seconds lease expiration interval: 60 seconds feed poll
         * delay: 5 seconds maximum scale count: unlimited.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.cosmos.models.ChangeFeedProcessorOptions&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param changeFeedProcessorOptions the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder changeFeedProcessorOptions(
                String changeFeedProcessorOptions) {
            doSetProperty("changeFeedProcessorOptions", changeFeedProcessorOptions);
            return this;
        }
        /**
         * Sets if the component should create Cosmos lease container for the
         * consumer automatically in case it doesn't exist in Cosmos database.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param createLeaseContainerIfNotExists the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder createLeaseContainerIfNotExists(
                boolean createLeaseContainerIfNotExists) {
            doSetProperty("createLeaseContainerIfNotExists", createLeaseContainerIfNotExists);
            return this;
        }
        /**
         * Sets if the component should create Cosmos lease container for the
         * consumer automatically in case it doesn't exist in Cosmos database.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param createLeaseContainerIfNotExists the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder createLeaseContainerIfNotExists(
                String createLeaseContainerIfNotExists) {
            doSetProperty("createLeaseContainerIfNotExists", createLeaseContainerIfNotExists);
            return this;
        }
        /**
         * Sets if the component should create Cosmos lease database for the
         * consumer automatically in case it doesn't exist in Cosmos account.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param createLeaseDatabaseIfNotExists the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder createLeaseDatabaseIfNotExists(
                boolean createLeaseDatabaseIfNotExists) {
            doSetProperty("createLeaseDatabaseIfNotExists", createLeaseDatabaseIfNotExists);
            return this;
        }
        /**
         * Sets if the component should create Cosmos lease database for the
         * consumer automatically in case it doesn't exist in Cosmos account.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param createLeaseDatabaseIfNotExists the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder createLeaseDatabaseIfNotExists(
                String createLeaseDatabaseIfNotExists) {
            doSetProperty("createLeaseDatabaseIfNotExists", createLeaseDatabaseIfNotExists);
            return this;
        }
        /**
         * Sets the hostname. The host: a host is an application instance that
         * uses the change feed processor to listen for changes. Multiple
         * instances with the same lease configuration can run in parallel, but
         * each instance should have a different instance name. If not
         * specified, this will be a generated random hostname.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param hostName the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder hostName(String hostName) {
            doSetProperty("hostName", hostName);
            return this;
        }
        /**
         * Sets the lease container which acts as a state storage and
         * coordinates processing the change feed across multiple workers. The
         * lease container can be stored in the same account as the monitored
         * container or in a separate account. It will be auto created if
         * createLeaseContainerIfNotExists is set to true.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: camel-lease
         * Group: consumer
         * 
         * @param leaseContainerName the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder leaseContainerName(
                String leaseContainerName) {
            doSetProperty("leaseContainerName", leaseContainerName);
            return this;
        }
        /**
         * Sets the lease database where the leaseContainerName will be stored.
         * If it is not specified, this component will store the lease container
         * in the same database that is specified in databaseName. It will be
         * auto created if createLeaseDatabaseIfNotExists is set to true.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param leaseDatabaseName the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder leaseDatabaseName(
                String leaseDatabaseName) {
            doSetProperty("leaseDatabaseName", leaseDatabaseName);
            return this;
        }
        /**
         * Sets either a master or readonly key used to perform authentication
         * for accessing resource.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: security
         * 
         * @param accountKey the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointConsumerBuilder accountKey(String accountKey) {
            doSetProperty("accountKey", accountKey);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Azure CosmosDB component.
     */
    public interface AdvancedCosmosDbEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default CosmosDbEndpointConsumerBuilder basic() {
            return (CosmosDbEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedCosmosDbEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedCosmosDbEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedCosmosDbEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedCosmosDbEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Azure CosmosDB component.
     */
    public interface CosmosDbEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedCosmosDbEndpointProducerBuilder advanced() {
            return (AdvancedCosmosDbEndpointProducerBuilder) this;
        }
        /**
         * Sets the flag to enable client telemetry which will periodically
         * collect database operations aggregation statistics, system
         * information like cpu/memory and send it to cosmos monitoring service,
         * which will be helpful during debugging. DEFAULT value is false
         * indicating this is opt in feature, by default no telemetry
         * collection.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param clientTelemetryEnabled the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointProducerBuilder clientTelemetryEnabled(
                boolean clientTelemetryEnabled) {
            doSetProperty("clientTelemetryEnabled", clientTelemetryEnabled);
            return this;
        }
        /**
         * Sets the flag to enable client telemetry which will periodically
         * collect database operations aggregation statistics, system
         * information like cpu/memory and send it to cosmos monitoring service,
         * which will be helpful during debugging. DEFAULT value is false
         * indicating this is opt in feature, by default no telemetry
         * collection.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param clientTelemetryEnabled the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointProducerBuilder clientTelemetryEnabled(
                String clientTelemetryEnabled) {
            doSetProperty("clientTelemetryEnabled", clientTelemetryEnabled);
            return this;
        }
        /**
         * Enables connections sharing across multiple Cosmos Clients. The
         * default is false. When you have multiple instances of Cosmos Client
         * in the same JVM interacting to multiple Cosmos accounts, enabling
         * this allows connection sharing in Direct mode if possible between
         * instances of Cosmos Client. Please note, when setting this option,
         * the connection configuration (e.g., socket timeout config, idle
         * timeout config) of the first instantiated client will be used for all
         * other client instances.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param connectionSharingAcrossClientsEnabled the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointProducerBuilder connectionSharingAcrossClientsEnabled(
                boolean connectionSharingAcrossClientsEnabled) {
            doSetProperty("connectionSharingAcrossClientsEnabled", connectionSharingAcrossClientsEnabled);
            return this;
        }
        /**
         * Enables connections sharing across multiple Cosmos Clients. The
         * default is false. When you have multiple instances of Cosmos Client
         * in the same JVM interacting to multiple Cosmos accounts, enabling
         * this allows connection sharing in Direct mode if possible between
         * instances of Cosmos Client. Please note, when setting this option,
         * the connection configuration (e.g., socket timeout config, idle
         * timeout config) of the first instantiated client will be used for all
         * other client instances.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param connectionSharingAcrossClientsEnabled the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointProducerBuilder connectionSharingAcrossClientsEnabled(
                String connectionSharingAcrossClientsEnabled) {
            doSetProperty("connectionSharingAcrossClientsEnabled", connectionSharingAcrossClientsEnabled);
            return this;
        }
        /**
         * Sets the consistency levels supported for Azure Cosmos DB client
         * operations in the Azure Cosmos DB service. The requested
         * ConsistencyLevel must match or be weaker than that provisioned for
         * the database account. Consistency levels by order of strength are
         * STRONG, BOUNDED_STALENESS, SESSION and EVENTUAL. Refer to consistency
         * level documentation for additional details:
         * https://docs.microsoft.com/en-us/azure/cosmos-db/consistency-levels.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.cosmos.ConsistencyLevel&lt;/code&gt; type.
         * 
         * Default: SESSION
         * Group: common
         * 
         * @param consistencyLevel the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointProducerBuilder consistencyLevel(
                ConsistencyLevel consistencyLevel) {
            doSetProperty("consistencyLevel", consistencyLevel);
            return this;
        }
        /**
         * Sets the consistency levels supported for Azure Cosmos DB client
         * operations in the Azure Cosmos DB service. The requested
         * ConsistencyLevel must match or be weaker than that provisioned for
         * the database account. Consistency levels by order of strength are
         * STRONG, BOUNDED_STALENESS, SESSION and EVENTUAL. Refer to consistency
         * level documentation for additional details:
         * https://docs.microsoft.com/en-us/azure/cosmos-db/consistency-levels.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.cosmos.ConsistencyLevel&lt;/code&gt; type.
         * 
         * Default: SESSION
         * Group: common
         * 
         * @param consistencyLevel the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointProducerBuilder consistencyLevel(
                String consistencyLevel) {
            doSetProperty("consistencyLevel", consistencyLevel);
            return this;
        }
        /**
         * Sets the container partition key path.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param containerPartitionKeyPath the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointProducerBuilder containerPartitionKeyPath(
                String containerPartitionKeyPath) {
            doSetProperty("containerPartitionKeyPath", containerPartitionKeyPath);
            return this;
        }
        /**
         * Sets the boolean to only return the headers and status code in Cosmos
         * DB response in case of Create, Update and Delete operations on
         * CosmosItem. In Consumer, it is enabled by default because of the
         * ChangeFeed in the consumer that needs this flag to be enabled and
         * thus is shouldn't be overridden. In Producer, it advised to disable
         * it since it reduces the network overhead.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param contentResponseOnWriteEnabled the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointProducerBuilder contentResponseOnWriteEnabled(
                boolean contentResponseOnWriteEnabled) {
            doSetProperty("contentResponseOnWriteEnabled", contentResponseOnWriteEnabled);
            return this;
        }
        /**
         * Sets the boolean to only return the headers and status code in Cosmos
         * DB response in case of Create, Update and Delete operations on
         * CosmosItem. In Consumer, it is enabled by default because of the
         * ChangeFeed in the consumer that needs this flag to be enabled and
         * thus is shouldn't be overridden. In Producer, it advised to disable
         * it since it reduces the network overhead.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param contentResponseOnWriteEnabled the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointProducerBuilder contentResponseOnWriteEnabled(
                String contentResponseOnWriteEnabled) {
            doSetProperty("contentResponseOnWriteEnabled", contentResponseOnWriteEnabled);
            return this;
        }
        /**
         * Inject an external CosmosAsyncClient into the component which
         * provides a client-side logical representation of the Azure Cosmos DB
         * service. This asynchronous client is used to configure and execute
         * requests against the service.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.cosmos.CosmosAsyncClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param cosmosAsyncClient the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointProducerBuilder cosmosAsyncClient(
                Object cosmosAsyncClient) {
            doSetProperty("cosmosAsyncClient", cosmosAsyncClient);
            return this;
        }
        /**
         * Inject an external CosmosAsyncClient into the component which
         * provides a client-side logical representation of the Azure Cosmos DB
         * service. This asynchronous client is used to configure and execute
         * requests against the service.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.cosmos.CosmosAsyncClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param cosmosAsyncClient the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointProducerBuilder cosmosAsyncClient(
                String cosmosAsyncClient) {
            doSetProperty("cosmosAsyncClient", cosmosAsyncClient);
            return this;
        }
        /**
         * Sets if the component should create Cosmos container automatically in
         * case it doesn't exist in Cosmos database.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param createContainerIfNotExists the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointProducerBuilder createContainerIfNotExists(
                boolean createContainerIfNotExists) {
            doSetProperty("createContainerIfNotExists", createContainerIfNotExists);
            return this;
        }
        /**
         * Sets if the component should create Cosmos container automatically in
         * case it doesn't exist in Cosmos database.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param createContainerIfNotExists the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointProducerBuilder createContainerIfNotExists(
                String createContainerIfNotExists) {
            doSetProperty("createContainerIfNotExists", createContainerIfNotExists);
            return this;
        }
        /**
         * Sets if the component should create Cosmos database automatically in
         * case it doesn't exist in Cosmos account.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param createDatabaseIfNotExists the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointProducerBuilder createDatabaseIfNotExists(
                boolean createDatabaseIfNotExists) {
            doSetProperty("createDatabaseIfNotExists", createDatabaseIfNotExists);
            return this;
        }
        /**
         * Sets if the component should create Cosmos database automatically in
         * case it doesn't exist in Cosmos account.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param createDatabaseIfNotExists the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointProducerBuilder createDatabaseIfNotExists(
                String createDatabaseIfNotExists) {
            doSetProperty("createDatabaseIfNotExists", createDatabaseIfNotExists);
            return this;
        }
        /**
         * Sets the Azure Cosmos database endpoint the component will connect
         * to.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: common
         * 
         * @param databaseEndpoint the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointProducerBuilder databaseEndpoint(
                String databaseEndpoint) {
            doSetProperty("databaseEndpoint", databaseEndpoint);
            return this;
        }
        /**
         * Sets the flag to enable writes on any regions for geo-replicated
         * database accounts in the Azure Cosmos DB service. When the value of
         * this property is true, the SDK will direct write operations to
         * available writable regions of geo-replicated database account.
         * Writable regions are ordered by PreferredRegions property. Setting
         * the property value to true has no effect until
         * EnableMultipleWriteRegions in DatabaseAccount is also set to true.
         * DEFAULT value is true indicating that writes are directed to
         * available writable regions of geo-replicated database account.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param multipleWriteRegionsEnabled the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointProducerBuilder multipleWriteRegionsEnabled(
                boolean multipleWriteRegionsEnabled) {
            doSetProperty("multipleWriteRegionsEnabled", multipleWriteRegionsEnabled);
            return this;
        }
        /**
         * Sets the flag to enable writes on any regions for geo-replicated
         * database accounts in the Azure Cosmos DB service. When the value of
         * this property is true, the SDK will direct write operations to
         * available writable regions of geo-replicated database account.
         * Writable regions are ordered by PreferredRegions property. Setting
         * the property value to true has no effect until
         * EnableMultipleWriteRegions in DatabaseAccount is also set to true.
         * DEFAULT value is true indicating that writes are directed to
         * available writable regions of geo-replicated database account.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param multipleWriteRegionsEnabled the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointProducerBuilder multipleWriteRegionsEnabled(
                String multipleWriteRegionsEnabled) {
            doSetProperty("multipleWriteRegionsEnabled", multipleWriteRegionsEnabled);
            return this;
        }
        /**
         * Sets the preferred regions for geo-replicated database accounts. For
         * example, East US as the preferred region. When
         * EnableEndpointDiscovery is true and PreferredRegions is non-empty,
         * the SDK will prefer to use the regions in the container in the order
         * they are specified to perform operations.
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param preferredRegions the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointProducerBuilder preferredRegions(
                List<String> preferredRegions) {
            doSetProperty("preferredRegions", preferredRegions);
            return this;
        }
        /**
         * Sets the preferred regions for geo-replicated database accounts. For
         * example, East US as the preferred region. When
         * EnableEndpointDiscovery is true and PreferredRegions is non-empty,
         * the SDK will prefer to use the regions in the container in the order
         * they are specified to perform operations.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param preferredRegions the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointProducerBuilder preferredRegions(
                String preferredRegions) {
            doSetProperty("preferredRegions", preferredRegions);
            return this;
        }
        /**
         * Sets whether to allow for reads to go to multiple regions configured
         * on an account of Azure Cosmos DB service. DEFAULT value is true. If
         * this property is not set, the default is true for all Consistency
         * Levels other than Bounded Staleness, The default is false for Bounded
         * Staleness. 1. endpointDiscoveryEnabled is true 2. the Azure Cosmos DB
         * account has more than one region.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param readRequestsFallbackEnabled the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointProducerBuilder readRequestsFallbackEnabled(
                boolean readRequestsFallbackEnabled) {
            doSetProperty("readRequestsFallbackEnabled", readRequestsFallbackEnabled);
            return this;
        }
        /**
         * Sets whether to allow for reads to go to multiple regions configured
         * on an account of Azure Cosmos DB service. DEFAULT value is true. If
         * this property is not set, the default is true for all Consistency
         * Levels other than Bounded Staleness, The default is false for Bounded
         * Staleness. 1. endpointDiscoveryEnabled is true 2. the Azure Cosmos DB
         * account has more than one region.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param readRequestsFallbackEnabled the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointProducerBuilder readRequestsFallbackEnabled(
                String readRequestsFallbackEnabled) {
            doSetProperty("readRequestsFallbackEnabled", readRequestsFallbackEnabled);
            return this;
        }
        /**
         * Sets throughput of the resources in the Azure Cosmos DB service.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.cosmos.models.ThroughputProperties&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param throughputProperties the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointProducerBuilder throughputProperties(
                Object throughputProperties) {
            doSetProperty("throughputProperties", throughputProperties);
            return this;
        }
        /**
         * Sets throughput of the resources in the Azure Cosmos DB service.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.cosmos.models.ThroughputProperties&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param throughputProperties the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointProducerBuilder throughputProperties(
                String throughputProperties) {
            doSetProperty("throughputProperties", throughputProperties);
            return this;
        }
        /**
         * Sets the itemId in case needed for operation on item like delete,
         * replace.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param itemId the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointProducerBuilder itemId(String itemId) {
            doSetProperty("itemId", itemId);
            return this;
        }
        /**
         * Sets partition key. Represents a partition key value in the Azure
         * Cosmos DB database service. A partition key identifies the partition
         * where the item is stored in.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.cosmos.models.PartitionKey&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param itemPartitionKey the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointProducerBuilder itemPartitionKey(
                Object itemPartitionKey) {
            doSetProperty("itemPartitionKey", itemPartitionKey);
            return this;
        }
        /**
         * Sets partition key. Represents a partition key value in the Azure
         * Cosmos DB database service. A partition key identifies the partition
         * where the item is stored in.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.cosmos.models.PartitionKey&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param itemPartitionKey the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointProducerBuilder itemPartitionKey(
                String itemPartitionKey) {
            doSetProperty("itemPartitionKey", itemPartitionKey);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The CosmosDB operation that can be used with this component on the
         * producer.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.azure.cosmosdb.CosmosDbOperationsDefinition&lt;/code&gt; type.
         * 
         * Default: listDatabases
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointProducerBuilder operation(
                CosmosDbOperationsDefinition operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The CosmosDB operation that can be used with this component on the
         * producer.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.azure.cosmosdb.CosmosDbOperationsDefinition&lt;/code&gt; type.
         * 
         * Default: listDatabases
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointProducerBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * An SQL query to execute on a given resources. To learn more about
         * Cosmos SQL API, check this link {link
         * https://docs.microsoft.com/en-us/azure/cosmos-db/sql-query-getting-started}.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param query the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointProducerBuilder query(String query) {
            doSetProperty("query", query);
            return this;
        }
        /**
         * Set additional QueryRequestOptions that can be used with queryItems,
         * queryContainers, queryDatabases, listDatabases, listItems,
         * listContainers operations.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.cosmos.models.CosmosQueryRequestOptions&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param queryRequestOptions the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointProducerBuilder queryRequestOptions(
                Object queryRequestOptions) {
            doSetProperty("queryRequestOptions", queryRequestOptions);
            return this;
        }
        /**
         * Set additional QueryRequestOptions that can be used with queryItems,
         * queryContainers, queryDatabases, listDatabases, listItems,
         * listContainers operations.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.cosmos.models.CosmosQueryRequestOptions&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param queryRequestOptions the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointProducerBuilder queryRequestOptions(
                String queryRequestOptions) {
            doSetProperty("queryRequestOptions", queryRequestOptions);
            return this;
        }
        /**
         * Sets either a master or readonly key used to perform authentication
         * for accessing resource.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: security
         * 
         * @param accountKey the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointProducerBuilder accountKey(String accountKey) {
            doSetProperty("accountKey", accountKey);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Azure CosmosDB component.
     */
    public interface AdvancedCosmosDbEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default CosmosDbEndpointProducerBuilder basic() {
            return (CosmosDbEndpointProducerBuilder) this;
        }
    }

    /**
     * Builder for endpoint for the Azure CosmosDB component.
     */
    public interface CosmosDbEndpointBuilder
            extends
                CosmosDbEndpointConsumerBuilder,
                CosmosDbEndpointProducerBuilder {
        default AdvancedCosmosDbEndpointBuilder advanced() {
            return (AdvancedCosmosDbEndpointBuilder) this;
        }
        /**
         * Sets the flag to enable client telemetry which will periodically
         * collect database operations aggregation statistics, system
         * information like cpu/memory and send it to cosmos monitoring service,
         * which will be helpful during debugging. DEFAULT value is false
         * indicating this is opt in feature, by default no telemetry
         * collection.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param clientTelemetryEnabled the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointBuilder clientTelemetryEnabled(
                boolean clientTelemetryEnabled) {
            doSetProperty("clientTelemetryEnabled", clientTelemetryEnabled);
            return this;
        }
        /**
         * Sets the flag to enable client telemetry which will periodically
         * collect database operations aggregation statistics, system
         * information like cpu/memory and send it to cosmos monitoring service,
         * which will be helpful during debugging. DEFAULT value is false
         * indicating this is opt in feature, by default no telemetry
         * collection.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param clientTelemetryEnabled the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointBuilder clientTelemetryEnabled(
                String clientTelemetryEnabled) {
            doSetProperty("clientTelemetryEnabled", clientTelemetryEnabled);
            return this;
        }
        /**
         * Enables connections sharing across multiple Cosmos Clients. The
         * default is false. When you have multiple instances of Cosmos Client
         * in the same JVM interacting to multiple Cosmos accounts, enabling
         * this allows connection sharing in Direct mode if possible between
         * instances of Cosmos Client. Please note, when setting this option,
         * the connection configuration (e.g., socket timeout config, idle
         * timeout config) of the first instantiated client will be used for all
         * other client instances.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param connectionSharingAcrossClientsEnabled the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointBuilder connectionSharingAcrossClientsEnabled(
                boolean connectionSharingAcrossClientsEnabled) {
            doSetProperty("connectionSharingAcrossClientsEnabled", connectionSharingAcrossClientsEnabled);
            return this;
        }
        /**
         * Enables connections sharing across multiple Cosmos Clients. The
         * default is false. When you have multiple instances of Cosmos Client
         * in the same JVM interacting to multiple Cosmos accounts, enabling
         * this allows connection sharing in Direct mode if possible between
         * instances of Cosmos Client. Please note, when setting this option,
         * the connection configuration (e.g., socket timeout config, idle
         * timeout config) of the first instantiated client will be used for all
         * other client instances.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param connectionSharingAcrossClientsEnabled the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointBuilder connectionSharingAcrossClientsEnabled(
                String connectionSharingAcrossClientsEnabled) {
            doSetProperty("connectionSharingAcrossClientsEnabled", connectionSharingAcrossClientsEnabled);
            return this;
        }
        /**
         * Sets the consistency levels supported for Azure Cosmos DB client
         * operations in the Azure Cosmos DB service. The requested
         * ConsistencyLevel must match or be weaker than that provisioned for
         * the database account. Consistency levels by order of strength are
         * STRONG, BOUNDED_STALENESS, SESSION and EVENTUAL. Refer to consistency
         * level documentation for additional details:
         * https://docs.microsoft.com/en-us/azure/cosmos-db/consistency-levels.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.cosmos.ConsistencyLevel&lt;/code&gt; type.
         * 
         * Default: SESSION
         * Group: common
         * 
         * @param consistencyLevel the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointBuilder consistencyLevel(
                ConsistencyLevel consistencyLevel) {
            doSetProperty("consistencyLevel", consistencyLevel);
            return this;
        }
        /**
         * Sets the consistency levels supported for Azure Cosmos DB client
         * operations in the Azure Cosmos DB service. The requested
         * ConsistencyLevel must match or be weaker than that provisioned for
         * the database account. Consistency levels by order of strength are
         * STRONG, BOUNDED_STALENESS, SESSION and EVENTUAL. Refer to consistency
         * level documentation for additional details:
         * https://docs.microsoft.com/en-us/azure/cosmos-db/consistency-levels.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.cosmos.ConsistencyLevel&lt;/code&gt; type.
         * 
         * Default: SESSION
         * Group: common
         * 
         * @param consistencyLevel the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointBuilder consistencyLevel(String consistencyLevel) {
            doSetProperty("consistencyLevel", consistencyLevel);
            return this;
        }
        /**
         * Sets the container partition key path.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param containerPartitionKeyPath the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointBuilder containerPartitionKeyPath(
                String containerPartitionKeyPath) {
            doSetProperty("containerPartitionKeyPath", containerPartitionKeyPath);
            return this;
        }
        /**
         * Sets the boolean to only return the headers and status code in Cosmos
         * DB response in case of Create, Update and Delete operations on
         * CosmosItem. In Consumer, it is enabled by default because of the
         * ChangeFeed in the consumer that needs this flag to be enabled and
         * thus is shouldn't be overridden. In Producer, it advised to disable
         * it since it reduces the network overhead.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param contentResponseOnWriteEnabled the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointBuilder contentResponseOnWriteEnabled(
                boolean contentResponseOnWriteEnabled) {
            doSetProperty("contentResponseOnWriteEnabled", contentResponseOnWriteEnabled);
            return this;
        }
        /**
         * Sets the boolean to only return the headers and status code in Cosmos
         * DB response in case of Create, Update and Delete operations on
         * CosmosItem. In Consumer, it is enabled by default because of the
         * ChangeFeed in the consumer that needs this flag to be enabled and
         * thus is shouldn't be overridden. In Producer, it advised to disable
         * it since it reduces the network overhead.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param contentResponseOnWriteEnabled the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointBuilder contentResponseOnWriteEnabled(
                String contentResponseOnWriteEnabled) {
            doSetProperty("contentResponseOnWriteEnabled", contentResponseOnWriteEnabled);
            return this;
        }
        /**
         * Inject an external CosmosAsyncClient into the component which
         * provides a client-side logical representation of the Azure Cosmos DB
         * service. This asynchronous client is used to configure and execute
         * requests against the service.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.cosmos.CosmosAsyncClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param cosmosAsyncClient the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointBuilder cosmosAsyncClient(
                Object cosmosAsyncClient) {
            doSetProperty("cosmosAsyncClient", cosmosAsyncClient);
            return this;
        }
        /**
         * Inject an external CosmosAsyncClient into the component which
         * provides a client-side logical representation of the Azure Cosmos DB
         * service. This asynchronous client is used to configure and execute
         * requests against the service.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.cosmos.CosmosAsyncClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param cosmosAsyncClient the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointBuilder cosmosAsyncClient(
                String cosmosAsyncClient) {
            doSetProperty("cosmosAsyncClient", cosmosAsyncClient);
            return this;
        }
        /**
         * Sets if the component should create Cosmos container automatically in
         * case it doesn't exist in Cosmos database.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param createContainerIfNotExists the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointBuilder createContainerIfNotExists(
                boolean createContainerIfNotExists) {
            doSetProperty("createContainerIfNotExists", createContainerIfNotExists);
            return this;
        }
        /**
         * Sets if the component should create Cosmos container automatically in
         * case it doesn't exist in Cosmos database.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param createContainerIfNotExists the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointBuilder createContainerIfNotExists(
                String createContainerIfNotExists) {
            doSetProperty("createContainerIfNotExists", createContainerIfNotExists);
            return this;
        }
        /**
         * Sets if the component should create Cosmos database automatically in
         * case it doesn't exist in Cosmos account.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param createDatabaseIfNotExists the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointBuilder createDatabaseIfNotExists(
                boolean createDatabaseIfNotExists) {
            doSetProperty("createDatabaseIfNotExists", createDatabaseIfNotExists);
            return this;
        }
        /**
         * Sets if the component should create Cosmos database automatically in
         * case it doesn't exist in Cosmos account.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param createDatabaseIfNotExists the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointBuilder createDatabaseIfNotExists(
                String createDatabaseIfNotExists) {
            doSetProperty("createDatabaseIfNotExists", createDatabaseIfNotExists);
            return this;
        }
        /**
         * Sets the Azure Cosmos database endpoint the component will connect
         * to.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: common
         * 
         * @param databaseEndpoint the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointBuilder databaseEndpoint(String databaseEndpoint) {
            doSetProperty("databaseEndpoint", databaseEndpoint);
            return this;
        }
        /**
         * Sets the flag to enable writes on any regions for geo-replicated
         * database accounts in the Azure Cosmos DB service. When the value of
         * this property is true, the SDK will direct write operations to
         * available writable regions of geo-replicated database account.
         * Writable regions are ordered by PreferredRegions property. Setting
         * the property value to true has no effect until
         * EnableMultipleWriteRegions in DatabaseAccount is also set to true.
         * DEFAULT value is true indicating that writes are directed to
         * available writable regions of geo-replicated database account.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param multipleWriteRegionsEnabled the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointBuilder multipleWriteRegionsEnabled(
                boolean multipleWriteRegionsEnabled) {
            doSetProperty("multipleWriteRegionsEnabled", multipleWriteRegionsEnabled);
            return this;
        }
        /**
         * Sets the flag to enable writes on any regions for geo-replicated
         * database accounts in the Azure Cosmos DB service. When the value of
         * this property is true, the SDK will direct write operations to
         * available writable regions of geo-replicated database account.
         * Writable regions are ordered by PreferredRegions property. Setting
         * the property value to true has no effect until
         * EnableMultipleWriteRegions in DatabaseAccount is also set to true.
         * DEFAULT value is true indicating that writes are directed to
         * available writable regions of geo-replicated database account.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param multipleWriteRegionsEnabled the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointBuilder multipleWriteRegionsEnabled(
                String multipleWriteRegionsEnabled) {
            doSetProperty("multipleWriteRegionsEnabled", multipleWriteRegionsEnabled);
            return this;
        }
        /**
         * Sets the preferred regions for geo-replicated database accounts. For
         * example, East US as the preferred region. When
         * EnableEndpointDiscovery is true and PreferredRegions is non-empty,
         * the SDK will prefer to use the regions in the container in the order
         * they are specified to perform operations.
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param preferredRegions the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointBuilder preferredRegions(
                List<String> preferredRegions) {
            doSetProperty("preferredRegions", preferredRegions);
            return this;
        }
        /**
         * Sets the preferred regions for geo-replicated database accounts. For
         * example, East US as the preferred region. When
         * EnableEndpointDiscovery is true and PreferredRegions is non-empty,
         * the SDK will prefer to use the regions in the container in the order
         * they are specified to perform operations.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param preferredRegions the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointBuilder preferredRegions(String preferredRegions) {
            doSetProperty("preferredRegions", preferredRegions);
            return this;
        }
        /**
         * Sets whether to allow for reads to go to multiple regions configured
         * on an account of Azure Cosmos DB service. DEFAULT value is true. If
         * this property is not set, the default is true for all Consistency
         * Levels other than Bounded Staleness, The default is false for Bounded
         * Staleness. 1. endpointDiscoveryEnabled is true 2. the Azure Cosmos DB
         * account has more than one region.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param readRequestsFallbackEnabled the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointBuilder readRequestsFallbackEnabled(
                boolean readRequestsFallbackEnabled) {
            doSetProperty("readRequestsFallbackEnabled", readRequestsFallbackEnabled);
            return this;
        }
        /**
         * Sets whether to allow for reads to go to multiple regions configured
         * on an account of Azure Cosmos DB service. DEFAULT value is true. If
         * this property is not set, the default is true for all Consistency
         * Levels other than Bounded Staleness, The default is false for Bounded
         * Staleness. 1. endpointDiscoveryEnabled is true 2. the Azure Cosmos DB
         * account has more than one region.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param readRequestsFallbackEnabled the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointBuilder readRequestsFallbackEnabled(
                String readRequestsFallbackEnabled) {
            doSetProperty("readRequestsFallbackEnabled", readRequestsFallbackEnabled);
            return this;
        }
        /**
         * Sets throughput of the resources in the Azure Cosmos DB service.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.cosmos.models.ThroughputProperties&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param throughputProperties the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointBuilder throughputProperties(
                Object throughputProperties) {
            doSetProperty("throughputProperties", throughputProperties);
            return this;
        }
        /**
         * Sets throughput of the resources in the Azure Cosmos DB service.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.cosmos.models.ThroughputProperties&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param throughputProperties the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointBuilder throughputProperties(
                String throughputProperties) {
            doSetProperty("throughputProperties", throughputProperties);
            return this;
        }
        /**
         * Sets either a master or readonly key used to perform authentication
         * for accessing resource.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: security
         * 
         * @param accountKey the value to set
         * @return the dsl builder
         */
        default CosmosDbEndpointBuilder accountKey(String accountKey) {
            doSetProperty("accountKey", accountKey);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Azure CosmosDB component.
     */
    public interface AdvancedCosmosDbEndpointBuilder
            extends
                AdvancedCosmosDbEndpointConsumerBuilder,
                AdvancedCosmosDbEndpointProducerBuilder {
        default CosmosDbEndpointBuilder basic() {
            return (CosmosDbEndpointBuilder) this;
        }
    }

    /**
     * Proxy enum for <code>com.azure.cosmos.ConsistencyLevel</code> enum.
     */
    enum ConsistencyLevel {
        STRONG,
        BOUNDED_STALENESS,
        SESSION,
        EVENTUAL,
        CONSISTENT_PREFIX;
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.azure.cosmosdb.CosmosDbOperationsDefinition</code> enum.
     */
    enum CosmosDbOperationsDefinition {
        listDatabases,
        createDatabase,
        queryDatabases,
        deleteDatabase,
        createContainer,
        replaceDatabaseThroughput,
        listContainers,
        queryContainers,
        deleteContainer,
        replaceContainerThroughput,
        createItem,
        upsertItem,
        deleteItem,
        replaceItem,
        readItem,
        readAllItems,
        queryItems;
    }

    public interface CosmosDbBuilders {
        /**
         * Azure CosmosDB (camel-azure-cosmosdb)
         * Azure Cosmos DB is Microsofts globally distributed, multi-model
         * database service for operational and analytics workloads. It offers
         * multi-mastering feature by automatically scaling throughput, compute,
         * and storage. This component interacts with Azure CosmosDB through
         * Azure SQL API
         * 
         * Category: cloud,database
         * Since: 3.10
         * Maven coordinates: org.apache.camel:camel-azure-cosmosdb
         * 
         * Syntax: <code>azure-cosmosdb:databaseName/containerName</code>
         * 
         * Path parameter: databaseName
         * The name of the Cosmos database that component should connect to. In
         * case you are producing data and have createDatabaseIfNotExists=true,
         * the component will automatically auto create a Cosmos database.
         * 
         * Path parameter: containerName
         * The name of the Cosmos container that component should connect to. In
         * case you are producing data and have createContainerIfNotExists=true,
         * the component will automatically auto create a Cosmos container.
         * 
         * @param path databaseName/containerName
         * @return the dsl builder
         */
        default CosmosDbEndpointBuilder azureCosmosdb(String path) {
            return CosmosDbEndpointBuilderFactory.endpointBuilder("azure-cosmosdb", path);
        }
        /**
         * Azure CosmosDB (camel-azure-cosmosdb)
         * Azure Cosmos DB is Microsofts globally distributed, multi-model
         * database service for operational and analytics workloads. It offers
         * multi-mastering feature by automatically scaling throughput, compute,
         * and storage. This component interacts with Azure CosmosDB through
         * Azure SQL API
         * 
         * Category: cloud,database
         * Since: 3.10
         * Maven coordinates: org.apache.camel:camel-azure-cosmosdb
         * 
         * Syntax: <code>azure-cosmosdb:databaseName/containerName</code>
         * 
         * Path parameter: databaseName
         * The name of the Cosmos database that component should connect to. In
         * case you are producing data and have createDatabaseIfNotExists=true,
         * the component will automatically auto create a Cosmos database.
         * 
         * Path parameter: containerName
         * The name of the Cosmos container that component should connect to. In
         * case you are producing data and have createContainerIfNotExists=true,
         * the component will automatically auto create a Cosmos container.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path databaseName/containerName
         * @return the dsl builder
         */
        default CosmosDbEndpointBuilder azureCosmosdb(
                String componentName,
                String path) {
            return CosmosDbEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static CosmosDbEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class CosmosDbEndpointBuilderImpl extends AbstractEndpointBuilder implements CosmosDbEndpointBuilder, AdvancedCosmosDbEndpointBuilder {
            public CosmosDbEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new CosmosDbEndpointBuilderImpl(path);
    }
}