/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Autogenerated by Thrift Compiler (0.10.0)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
package org.apache.camel.component.thrift.generated;

@SuppressWarnings({ "cast", "rawtypes", "serial", "unchecked", "unused" })
@javax.annotation.Generated(value = "Autogenerated by Thrift Compiler (0.10.0)", date = "2017-06-14")
public class Calculator {

    /**
     * Ahh, now onto the cool part, defining a service. Services just need a name and can optionally inherit from
     * another service using the extends keyword.
     */
    public interface Iface {

        /**
         * A method definition looks like C code. It has a return type, arguments, and optionally a list of exceptions
         * that it may throw. Note that argument lists and exception lists are specified using the exact same syntax as
         * field lists in struct or exception definitions.
         */
        void ping() throws org.apache.thrift.TException;

        int add(int num1, int num2) throws org.apache.thrift.TException;

        int calculate(int logid, Work w) throws InvalidOperation, org.apache.thrift.TException;

        /**
         * This method has a oneway modifier. That means the client only makes a request and does not listen for any
         * response at all. Oneway methods must be void.
         */
        void zip() throws org.apache.thrift.TException;

        /**
         * This method echoed input object as return value.
         *
         * @param w
         */
        Work echo(Work w) throws org.apache.thrift.TException;

        /**
         * This method contains all possible simple, special, struct and container types as input parameters
         *
         * @param v1
         * @param v2
         * @param v3
         * @param v4
         * @param v5
         * @param v6
         * @param v7
         * @param v8
         * @param v9
         * @param v10
         * @param v11
         * @param v12
         */
        int alltypes(
                boolean v1, byte v2, short v3, int v4, long v5, double v6, java.lang.String v7, java.nio.ByteBuffer v8, Work v9,
                java.util.List<java.lang.Integer> v10, java.util.Set<java.lang.String> v11,
                java.util.Map<java.lang.String, java.lang.Long> v12)
                throws org.apache.thrift.TException;

    }

    public interface AsyncIface {

        void ping(org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

        void add(int num1, int num2, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler)
                throws org.apache.thrift.TException;

        void calculate(int logid, Work w, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler)
                throws org.apache.thrift.TException;

        void zip(org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

        void echo(Work w, org.apache.thrift.async.AsyncMethodCallback<Work> resultHandler) throws org.apache.thrift.TException;

        void alltypes(
                boolean v1, byte v2, short v3, int v4, long v5, double v6, java.lang.String v7, java.nio.ByteBuffer v8, Work v9,
                java.util.List<java.lang.Integer> v10, java.util.Set<java.lang.String> v11,
                java.util.Map<java.lang.String, java.lang.Long> v12,
                org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler)
                throws org.apache.thrift.TException;

    }

    public static class Client extends org.apache.thrift.TServiceClient implements Iface {
        public static class Factory implements org.apache.thrift.TServiceClientFactory<Client> {
            public Factory() {
            }

            public Client getClient(org.apache.thrift.protocol.TProtocol prot) {
                return new Client(prot);
            }

            public Client getClient(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
                return new Client(iprot, oprot);
            }
        }

        public Client(org.apache.thrift.protocol.TProtocol prot) {
            super(prot, prot);
        }

        public Client(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
            super(iprot, oprot);
        }

        public void ping() throws org.apache.thrift.TException {
            send_ping();
            recv_ping();
        }

        public void send_ping() throws org.apache.thrift.TException {
            ping_args args = new ping_args();
            sendBase("ping", args);
        }

        public void recv_ping() throws org.apache.thrift.TException {
            ping_result result = new ping_result();
            receiveBase(result, "ping");
            return;
        }

        public int add(int num1, int num2) throws org.apache.thrift.TException {
            send_add(num1, num2);
            return recv_add();
        }

        public void send_add(int num1, int num2) throws org.apache.thrift.TException {
            add_args args = new add_args();
            args.setNum1(num1);
            args.setNum2(num2);
            sendBase("add", args);
        }

        public int recv_add() throws org.apache.thrift.TException {
            add_result result = new add_result();
            receiveBase(result, "add");
            if (result.isSetSuccess()) {
                return result.success;
            }
            throw new org.apache.thrift.TApplicationException(
                    org.apache.thrift.TApplicationException.MISSING_RESULT, "add failed: unknown result");
        }

        public int calculate(int logid, Work w) throws InvalidOperation, org.apache.thrift.TException {
            send_calculate(logid, w);
            return recv_calculate();
        }

        public void send_calculate(int logid, Work w) throws org.apache.thrift.TException {
            calculate_args args = new calculate_args();
            args.setLogid(logid);
            args.setW(w);
            sendBase("calculate", args);
        }

        public int recv_calculate() throws InvalidOperation, org.apache.thrift.TException {
            calculate_result result = new calculate_result();
            receiveBase(result, "calculate");
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.ouch != null) {
                throw result.ouch;
            }
            throw new org.apache.thrift.TApplicationException(
                    org.apache.thrift.TApplicationException.MISSING_RESULT, "calculate failed: unknown result");
        }

        public void zip() throws org.apache.thrift.TException {
            send_zip();
        }

        public void send_zip() throws org.apache.thrift.TException {
            zip_args args = new zip_args();
            sendBaseOneway("zip", args);
        }

        public Work echo(Work w) throws org.apache.thrift.TException {
            send_echo(w);
            return recv_echo();
        }

        public void send_echo(Work w) throws org.apache.thrift.TException {
            echo_args args = new echo_args();
            args.setW(w);
            sendBase("echo", args);
        }

        public Work recv_echo() throws org.apache.thrift.TException {
            echo_result result = new echo_result();
            receiveBase(result, "echo");
            if (result.isSetSuccess()) {
                return result.success;
            }
            throw new org.apache.thrift.TApplicationException(
                    org.apache.thrift.TApplicationException.MISSING_RESULT, "echo failed: unknown result");
        }

        public int alltypes(
                boolean v1, byte v2, short v3, int v4, long v5, double v6, java.lang.String v7, java.nio.ByteBuffer v8, Work v9,
                java.util.List<java.lang.Integer> v10, java.util.Set<java.lang.String> v11,
                java.util.Map<java.lang.String, java.lang.Long> v12)
                throws org.apache.thrift.TException {
            send_alltypes(v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, v11, v12);
            return recv_alltypes();
        }

        public void send_alltypes(
                boolean v1, byte v2, short v3, int v4, long v5, double v6, java.lang.String v7, java.nio.ByteBuffer v8, Work v9,
                java.util.List<java.lang.Integer> v10, java.util.Set<java.lang.String> v11,
                java.util.Map<java.lang.String, java.lang.Long> v12)
                throws org.apache.thrift.TException {
            alltypes_args args = new alltypes_args();
            args.setV1(v1);
            args.setV2(v2);
            args.setV3(v3);
            args.setV4(v4);
            args.setV5(v5);
            args.setV6(v6);
            args.setV7(v7);
            args.setV8(v8);
            args.setV9(v9);
            args.setV10(v10);
            args.setV11(v11);
            args.setV12(v12);
            sendBase("alltypes", args);
        }

        public int recv_alltypes() throws org.apache.thrift.TException {
            alltypes_result result = new alltypes_result();
            receiveBase(result, "alltypes");
            if (result.isSetSuccess()) {
                return result.success;
            }
            throw new org.apache.thrift.TApplicationException(
                    org.apache.thrift.TApplicationException.MISSING_RESULT, "alltypes failed: unknown result");
        }

    }

    public static class AsyncClient extends org.apache.thrift.async.TAsyncClient implements AsyncIface {
        public static class Factory implements org.apache.thrift.async.TAsyncClientFactory<AsyncClient> {
            private org.apache.thrift.async.TAsyncClientManager clientManager;
            private org.apache.thrift.protocol.TProtocolFactory protocolFactory;

            public Factory(org.apache.thrift.async.TAsyncClientManager clientManager,
                           org.apache.thrift.protocol.TProtocolFactory protocolFactory) {
                this.clientManager = clientManager;
                this.protocolFactory = protocolFactory;
            }

            public AsyncClient getAsyncClient(org.apache.thrift.transport.TNonblockingTransport transport) {
                return new AsyncClient(protocolFactory, clientManager, transport);
            }
        }

        public AsyncClient(org.apache.thrift.protocol.TProtocolFactory protocolFactory,
                           org.apache.thrift.async.TAsyncClientManager clientManager,
                           org.apache.thrift.transport.TNonblockingTransport transport) {
            super(protocolFactory, clientManager, transport);
        }

        public void ping(org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
            checkReady();
            ping_call method_call = new ping_call(resultHandler, this, ___protocolFactory, ___transport);
            this.___currentMethod = method_call;
            ___manager.call(method_call);
        }

        public static class ping_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
            public ping_call(org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler,
                             org.apache.thrift.async.TAsyncClient client,
                             org.apache.thrift.protocol.TProtocolFactory protocolFactory,
                             org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
                super(client, protocolFactory, transport, resultHandler, false);
            }

            public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
                prot.writeMessageBegin(
                        new org.apache.thrift.protocol.TMessage("ping", org.apache.thrift.protocol.TMessageType.CALL, 0));
                ping_args args = new ping_args();
                args.write(prot);
                prot.writeMessageEnd();
            }

            public Void getResult() throws org.apache.thrift.TException {
                if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
                    throw new java.lang.IllegalStateException("Method call not finished!");
                }
                org.apache.thrift.transport.TMemoryInputTransport memoryTransport
                        = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
                org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
                return null;
            }
        }

        public void add(int num1, int num2, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler)
                throws org.apache.thrift.TException {
            checkReady();
            add_call method_call = new add_call(num1, num2, resultHandler, this, ___protocolFactory, ___transport);
            this.___currentMethod = method_call;
            ___manager.call(method_call);
        }

        public static class add_call extends org.apache.thrift.async.TAsyncMethodCall<java.lang.Integer> {
            private int num1;
            private int num2;

            public add_call(int num1, int num2, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler,
                            org.apache.thrift.async.TAsyncClient client,
                            org.apache.thrift.protocol.TProtocolFactory protocolFactory,
                            org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
                super(client, protocolFactory, transport, resultHandler, false);
                this.num1 = num1;
                this.num2 = num2;
            }

            public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
                prot.writeMessageBegin(
                        new org.apache.thrift.protocol.TMessage("add", org.apache.thrift.protocol.TMessageType.CALL, 0));
                add_args args = new add_args();
                args.setNum1(num1);
                args.setNum2(num2);
                args.write(prot);
                prot.writeMessageEnd();
            }

            public java.lang.Integer getResult() throws org.apache.thrift.TException {
                if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
                    throw new java.lang.IllegalStateException("Method call not finished!");
                }
                org.apache.thrift.transport.TMemoryInputTransport memoryTransport
                        = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
                org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
                return (new Client(prot)).recv_add();
            }
        }

        public void calculate(int logid, Work w, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler)
                throws org.apache.thrift.TException {
            checkReady();
            calculate_call method_call = new calculate_call(logid, w, resultHandler, this, ___protocolFactory, ___transport);
            this.___currentMethod = method_call;
            ___manager.call(method_call);
        }

        public static class calculate_call extends org.apache.thrift.async.TAsyncMethodCall<java.lang.Integer> {
            private int logid;
            private Work w;

            public calculate_call(int logid, Work w,
                                  org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler,
                                  org.apache.thrift.async.TAsyncClient client,
                                  org.apache.thrift.protocol.TProtocolFactory protocolFactory,
                                  org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
                super(client, protocolFactory, transport, resultHandler, false);
                this.logid = logid;
                this.w = w;
            }

            public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
                prot.writeMessageBegin(
                        new org.apache.thrift.protocol.TMessage("calculate", org.apache.thrift.protocol.TMessageType.CALL, 0));
                calculate_args args = new calculate_args();
                args.setLogid(logid);
                args.setW(w);
                args.write(prot);
                prot.writeMessageEnd();
            }

            public java.lang.Integer getResult() throws InvalidOperation, org.apache.thrift.TException {
                if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
                    throw new java.lang.IllegalStateException("Method call not finished!");
                }
                org.apache.thrift.transport.TMemoryInputTransport memoryTransport
                        = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
                org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
                return (new Client(prot)).recv_calculate();
            }
        }

        public void zip(org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
            checkReady();
            zip_call method_call = new zip_call(resultHandler, this, ___protocolFactory, ___transport);
            this.___currentMethod = method_call;
            ___manager.call(method_call);
        }

        public static class zip_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
            public zip_call(org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler,
                            org.apache.thrift.async.TAsyncClient client,
                            org.apache.thrift.protocol.TProtocolFactory protocolFactory,
                            org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
                super(client, protocolFactory, transport, resultHandler, true);
            }

            public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
                prot.writeMessageBegin(
                        new org.apache.thrift.protocol.TMessage("zip", org.apache.thrift.protocol.TMessageType.ONEWAY, 0));
                zip_args args = new zip_args();
                args.write(prot);
                prot.writeMessageEnd();
            }

            public Void getResult() throws org.apache.thrift.TException {
                if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
                    throw new java.lang.IllegalStateException("Method call not finished!");
                }
                org.apache.thrift.transport.TMemoryInputTransport memoryTransport
                        = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
                org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
                return null;
            }
        }

        public void echo(Work w, org.apache.thrift.async.AsyncMethodCallback<Work> resultHandler)
                throws org.apache.thrift.TException {
            checkReady();
            echo_call method_call = new echo_call(w, resultHandler, this, ___protocolFactory, ___transport);
            this.___currentMethod = method_call;
            ___manager.call(method_call);
        }

        public static class echo_call extends org.apache.thrift.async.TAsyncMethodCall<Work> {
            private Work w;

            public echo_call(Work w, org.apache.thrift.async.AsyncMethodCallback<Work> resultHandler,
                             org.apache.thrift.async.TAsyncClient client,
                             org.apache.thrift.protocol.TProtocolFactory protocolFactory,
                             org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
                super(client, protocolFactory, transport, resultHandler, false);
                this.w = w;
            }

            public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
                prot.writeMessageBegin(
                        new org.apache.thrift.protocol.TMessage("echo", org.apache.thrift.protocol.TMessageType.CALL, 0));
                echo_args args = new echo_args();
                args.setW(w);
                args.write(prot);
                prot.writeMessageEnd();
            }

            public Work getResult() throws org.apache.thrift.TException {
                if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
                    throw new java.lang.IllegalStateException("Method call not finished!");
                }
                org.apache.thrift.transport.TMemoryInputTransport memoryTransport
                        = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
                org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
                return (new Client(prot)).recv_echo();
            }
        }

        public void alltypes(
                boolean v1, byte v2, short v3, int v4, long v5, double v6, java.lang.String v7, java.nio.ByteBuffer v8, Work v9,
                java.util.List<java.lang.Integer> v10, java.util.Set<java.lang.String> v11,
                java.util.Map<java.lang.String, java.lang.Long> v12,
                org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler)
                throws org.apache.thrift.TException {
            checkReady();
            alltypes_call method_call = new alltypes_call(
                    v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, v11, v12, resultHandler, this, ___protocolFactory, ___transport);
            this.___currentMethod = method_call;
            ___manager.call(method_call);
        }

        public static class alltypes_call extends org.apache.thrift.async.TAsyncMethodCall<java.lang.Integer> {
            private boolean v1;
            private byte v2;
            private short v3;
            private int v4;
            private long v5;
            private double v6;
            private java.lang.String v7;
            private java.nio.ByteBuffer v8;
            private Work v9;
            private java.util.List<java.lang.Integer> v10;
            private java.util.Set<java.lang.String> v11;
            private java.util.Map<java.lang.String, java.lang.Long> v12;

            public alltypes_call(boolean v1, byte v2, short v3, int v4, long v5, double v6, java.lang.String v7,
                                 java.nio.ByteBuffer v8, Work v9, java.util.List<java.lang.Integer> v10,
                                 java.util.Set<java.lang.String> v11, java.util.Map<java.lang.String, java.lang.Long> v12,
                                 org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler,
                                 org.apache.thrift.async.TAsyncClient client,
                                 org.apache.thrift.protocol.TProtocolFactory protocolFactory,
                                 org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
                super(client, protocolFactory, transport, resultHandler, false);
                this.v1 = v1;
                this.v2 = v2;
                this.v3 = v3;
                this.v4 = v4;
                this.v5 = v5;
                this.v6 = v6;
                this.v7 = v7;
                this.v8 = v8;
                this.v9 = v9;
                this.v10 = v10;
                this.v11 = v11;
                this.v12 = v12;
            }

            public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
                prot.writeMessageBegin(
                        new org.apache.thrift.protocol.TMessage("alltypes", org.apache.thrift.protocol.TMessageType.CALL, 0));
                alltypes_args args = new alltypes_args();
                args.setV1(v1);
                args.setV2(v2);
                args.setV3(v3);
                args.setV4(v4);
                args.setV5(v5);
                args.setV6(v6);
                args.setV7(v7);
                args.setV8(v8);
                args.setV9(v9);
                args.setV10(v10);
                args.setV11(v11);
                args.setV12(v12);
                args.write(prot);
                prot.writeMessageEnd();
            }

            public java.lang.Integer getResult() throws org.apache.thrift.TException {
                if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
                    throw new java.lang.IllegalStateException("Method call not finished!");
                }
                org.apache.thrift.transport.TMemoryInputTransport memoryTransport
                        = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
                org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
                return (new Client(prot)).recv_alltypes();
            }
        }

    }

    public static class Processor<I extends Iface> extends org.apache.thrift.TBaseProcessor<I>
            implements org.apache.thrift.TProcessor {
        private static final org.slf4j.Logger _LOGGER = org.slf4j.LoggerFactory.getLogger(Processor.class.getName());

        public Processor(I iface) {
            super(iface, getProcessMap(
                    new java.util.HashMap<java.lang.String, org.apache.thrift.ProcessFunction<I, ? extends org.apache.thrift.TBase>>()));
        }

        protected Processor(I iface,
                            java.util.Map<java.lang.String, org.apache.thrift.ProcessFunction<I, ? extends org.apache.thrift.TBase>> processMap) {
            super(iface, getProcessMap(processMap));
        }

        private static <
                I extends Iface> java.util.Map<java.lang.String, org.apache.thrift.ProcessFunction<I, ? extends org.apache.thrift.TBase>> getProcessMap(
                        java.util.Map<java.lang.String, org.apache.thrift.ProcessFunction<I, ? extends org.apache.thrift.TBase>> processMap) {
            processMap.put("ping", new ping());
            processMap.put("add", new add());
            processMap.put("calculate", new calculate());
            processMap.put("zip", new zip());
            processMap.put("echo", new echo());
            processMap.put("alltypes", new alltypes());
            return processMap;
        }

        public static class ping<I extends Iface> extends org.apache.thrift.ProcessFunction<I, ping_args> {
            public ping() {
                super("ping");
            }

            public ping_args getEmptyArgsInstance() {
                return new ping_args();
            }

            protected boolean isOneway() {
                return false;
            }

            public ping_result getResult(I iface, ping_args args) throws org.apache.thrift.TException {
                ping_result result = new ping_result();
                iface.ping();
                return result;
            }
        }

        public static class add<I extends Iface> extends org.apache.thrift.ProcessFunction<I, add_args> {
            public add() {
                super("add");
            }

            public add_args getEmptyArgsInstance() {
                return new add_args();
            }

            protected boolean isOneway() {
                return false;
            }

            public add_result getResult(I iface, add_args args) throws org.apache.thrift.TException {
                add_result result = new add_result();
                result.success = iface.add(args.num1, args.num2);
                result.setSuccessIsSet(true);
                return result;
            }
        }

        public static class calculate<I extends Iface> extends org.apache.thrift.ProcessFunction<I, calculate_args> {
            public calculate() {
                super("calculate");
            }

            public calculate_args getEmptyArgsInstance() {
                return new calculate_args();
            }

            protected boolean isOneway() {
                return false;
            }

            public calculate_result getResult(I iface, calculate_args args) throws org.apache.thrift.TException {
                calculate_result result = new calculate_result();
                try {
                    result.success = iface.calculate(args.logid, args.w);
                    result.setSuccessIsSet(true);
                } catch (InvalidOperation ouch) {
                    result.ouch = ouch;
                }
                return result;
            }
        }

        public static class zip<I extends Iface> extends org.apache.thrift.ProcessFunction<I, zip_args> {
            public zip() {
                super("zip");
            }

            public zip_args getEmptyArgsInstance() {
                return new zip_args();
            }

            protected boolean isOneway() {
                return true;
            }

            public org.apache.thrift.TBase getResult(I iface, zip_args args) throws org.apache.thrift.TException {
                iface.zip();
                return null;
            }
        }

        public static class echo<I extends Iface> extends org.apache.thrift.ProcessFunction<I, echo_args> {
            public echo() {
                super("echo");
            }

            public echo_args getEmptyArgsInstance() {
                return new echo_args();
            }

            protected boolean isOneway() {
                return false;
            }

            public echo_result getResult(I iface, echo_args args) throws org.apache.thrift.TException {
                echo_result result = new echo_result();
                result.success = iface.echo(args.w);
                return result;
            }
        }

        public static class alltypes<I extends Iface> extends org.apache.thrift.ProcessFunction<I, alltypes_args> {
            public alltypes() {
                super("alltypes");
            }

            public alltypes_args getEmptyArgsInstance() {
                return new alltypes_args();
            }

            protected boolean isOneway() {
                return false;
            }

            public alltypes_result getResult(I iface, alltypes_args args) throws org.apache.thrift.TException {
                alltypes_result result = new alltypes_result();
                result.success = iface.alltypes(args.v1, args.v2, args.v3, args.v4, args.v5, args.v6, args.v7, args.v8, args.v9,
                        args.v10, args.v11, args.v12);
                result.setSuccessIsSet(true);
                return result;
            }
        }

    }

    public static class AsyncProcessor<I extends AsyncIface> extends org.apache.thrift.TBaseAsyncProcessor<I> {
        private static final org.slf4j.Logger _LOGGER = org.slf4j.LoggerFactory.getLogger(AsyncProcessor.class.getName());

        public AsyncProcessor(I iface) {
            super(iface, getProcessMap(
                    new java.util.HashMap<java.lang.String, org.apache.thrift.AsyncProcessFunction<I, ? extends org.apache.thrift.TBase, ?>>()));
        }

        protected AsyncProcessor(I iface,
                                 java.util.Map<java.lang.String, org.apache.thrift.AsyncProcessFunction<I, ? extends org.apache.thrift.TBase, ?>> processMap) {
            super(iface, getProcessMap(processMap));
        }

        private static <
                I extends AsyncIface> java.util.Map<java.lang.String, org.apache.thrift.AsyncProcessFunction<I, ? extends org.apache.thrift.TBase, ?>> getProcessMap(
                        java.util.Map<java.lang.String, org.apache.thrift.AsyncProcessFunction<I, ? extends org.apache.thrift.TBase, ?>> processMap) {
            processMap.put("ping", new ping());
            processMap.put("add", new add());
            processMap.put("calculate", new calculate());
            processMap.put("zip", new zip());
            processMap.put("echo", new echo());
            processMap.put("alltypes", new alltypes());
            return processMap;
        }

        public static class ping<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, ping_args, Void> {
            public ping() {
                super("ping");
            }

            public ping_args getEmptyArgsInstance() {
                return new ping_args();
            }

            public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(
                    final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
                final org.apache.thrift.AsyncProcessFunction fcall = this;
                return new org.apache.thrift.async.AsyncMethodCallback<Void>() {
                    public void onComplete(Void o) {
                        ping_result result = new ping_result();
                        try {
                            fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY, seqid);
                        } catch (org.apache.thrift.transport.TTransportException e) {
                            _LOGGER.error("TTransportException writing to internal frame buffer", e);
                            fb.close();
                        } catch (java.lang.Exception e) {
                            _LOGGER.error("Exception writing to internal frame buffer", e);
                            onError(e);
                        }
                    }

                    public void onError(java.lang.Exception e) {
                        byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
                        org.apache.thrift.TSerializable msg;
                        ping_result result = new ping_result();
                        if (e instanceof org.apache.thrift.transport.TTransportException) {
                            _LOGGER.error("TTransportException inside handler", e);
                            fb.close();
                            return;
                        } else if (e instanceof org.apache.thrift.TApplicationException) {
                            _LOGGER.error("TApplicationException inside handler", e);
                            msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
                            msg = (org.apache.thrift.TApplicationException) e;
                        } else {
                            _LOGGER.error("Exception inside handler", e);
                            msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
                            msg = new org.apache.thrift.TApplicationException(
                                    org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
                        }
                        try {
                            fcall.sendResponse(fb, msg, msgType, seqid);
                        } catch (java.lang.Exception ex) {
                            _LOGGER.error("Exception writing to internal frame buffer", ex);
                            fb.close();
                        }
                    }
                };
            }

            protected boolean isOneway() {
                return false;
            }

            public void start(I iface, ping_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler)
                    throws org.apache.thrift.TException {
                iface.ping(resultHandler);
            }
        }

        public static class add<I extends AsyncIface>
                extends org.apache.thrift.AsyncProcessFunction<I, add_args, java.lang.Integer> {
            public add() {
                super("add");
            }

            public add_args getEmptyArgsInstance() {
                return new add_args();
            }

            public org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> getResultHandler(
                    final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
                final org.apache.thrift.AsyncProcessFunction fcall = this;
                return new org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer>() {
                    public void onComplete(java.lang.Integer o) {
                        add_result result = new add_result();
                        result.success = o;
                        result.setSuccessIsSet(true);
                        try {
                            fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY, seqid);
                        } catch (org.apache.thrift.transport.TTransportException e) {
                            _LOGGER.error("TTransportException writing to internal frame buffer", e);
                            fb.close();
                        } catch (java.lang.Exception e) {
                            _LOGGER.error("Exception writing to internal frame buffer", e);
                            onError(e);
                        }
                    }

                    public void onError(java.lang.Exception e) {
                        byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
                        org.apache.thrift.TSerializable msg;
                        add_result result = new add_result();
                        if (e instanceof org.apache.thrift.transport.TTransportException) {
                            _LOGGER.error("TTransportException inside handler", e);
                            fb.close();
                            return;
                        } else if (e instanceof org.apache.thrift.TApplicationException) {
                            _LOGGER.error("TApplicationException inside handler", e);
                            msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
                            msg = (org.apache.thrift.TApplicationException) e;
                        } else {
                            _LOGGER.error("Exception inside handler", e);
                            msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
                            msg = new org.apache.thrift.TApplicationException(
                                    org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
                        }
                        try {
                            fcall.sendResponse(fb, msg, msgType, seqid);
                        } catch (java.lang.Exception ex) {
                            _LOGGER.error("Exception writing to internal frame buffer", ex);
                            fb.close();
                        }
                    }
                };
            }

            protected boolean isOneway() {
                return false;
            }

            public void start(
                    I iface, add_args args, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler)
                    throws org.apache.thrift.TException {
                iface.add(args.num1, args.num2, resultHandler);
            }
        }

        public static class calculate<I extends AsyncIface>
                extends org.apache.thrift.AsyncProcessFunction<I, calculate_args, java.lang.Integer> {
            public calculate() {
                super("calculate");
            }

            public calculate_args getEmptyArgsInstance() {
                return new calculate_args();
            }

            public org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> getResultHandler(
                    final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
                final org.apache.thrift.AsyncProcessFunction fcall = this;
                return new org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer>() {
                    public void onComplete(java.lang.Integer o) {
                        calculate_result result = new calculate_result();
                        result.success = o;
                        result.setSuccessIsSet(true);
                        try {
                            fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY, seqid);
                        } catch (org.apache.thrift.transport.TTransportException e) {
                            _LOGGER.error("TTransportException writing to internal frame buffer", e);
                            fb.close();
                        } catch (java.lang.Exception e) {
                            _LOGGER.error("Exception writing to internal frame buffer", e);
                            onError(e);
                        }
                    }

                    public void onError(java.lang.Exception e) {
                        byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
                        org.apache.thrift.TSerializable msg;
                        calculate_result result = new calculate_result();
                        if (e instanceof InvalidOperation) {
                            result.ouch = (InvalidOperation) e;
                            result.setOuchIsSet(true);
                            msg = result;
                        } else if (e instanceof org.apache.thrift.transport.TTransportException) {
                            _LOGGER.error("TTransportException inside handler", e);
                            fb.close();
                            return;
                        } else if (e instanceof org.apache.thrift.TApplicationException) {
                            _LOGGER.error("TApplicationException inside handler", e);
                            msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
                            msg = (org.apache.thrift.TApplicationException) e;
                        } else {
                            _LOGGER.error("Exception inside handler", e);
                            msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
                            msg = new org.apache.thrift.TApplicationException(
                                    org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
                        }
                        try {
                            fcall.sendResponse(fb, msg, msgType, seqid);
                        } catch (java.lang.Exception ex) {
                            _LOGGER.error("Exception writing to internal frame buffer", ex);
                            fb.close();
                        }
                    }
                };
            }

            protected boolean isOneway() {
                return false;
            }

            public void start(
                    I iface, calculate_args args, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler)
                    throws org.apache.thrift.TException {
                iface.calculate(args.logid, args.w, resultHandler);
            }
        }

        public static class zip<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, zip_args, Void> {
            public zip() {
                super("zip");
            }

            public zip_args getEmptyArgsInstance() {
                return new zip_args();
            }

            public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(
                    final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
                final org.apache.thrift.AsyncProcessFunction fcall = this;
                return new org.apache.thrift.async.AsyncMethodCallback<Void>() {
                    public void onComplete(Void o) {
                    }

                    public void onError(java.lang.Exception e) {
                        if (e instanceof org.apache.thrift.transport.TTransportException) {
                            _LOGGER.error("TTransportException inside handler", e);
                            fb.close();
                        } else {
                            _LOGGER.error("Exception inside oneway handler", e);
                        }
                    }
                };
            }

            protected boolean isOneway() {
                return true;
            }

            public void start(I iface, zip_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler)
                    throws org.apache.thrift.TException {
                iface.zip(resultHandler);
            }
        }

        public static class echo<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, echo_args, Work> {
            public echo() {
                super("echo");
            }

            public echo_args getEmptyArgsInstance() {
                return new echo_args();
            }

            public org.apache.thrift.async.AsyncMethodCallback<Work> getResultHandler(
                    final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
                final org.apache.thrift.AsyncProcessFunction fcall = this;
                return new org.apache.thrift.async.AsyncMethodCallback<Work>() {
                    public void onComplete(Work o) {
                        echo_result result = new echo_result();
                        result.success = o;
                        try {
                            fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY, seqid);
                        } catch (org.apache.thrift.transport.TTransportException e) {
                            _LOGGER.error("TTransportException writing to internal frame buffer", e);
                            fb.close();
                        } catch (java.lang.Exception e) {
                            _LOGGER.error("Exception writing to internal frame buffer", e);
                            onError(e);
                        }
                    }

                    public void onError(java.lang.Exception e) {
                        byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
                        org.apache.thrift.TSerializable msg;
                        echo_result result = new echo_result();
                        if (e instanceof org.apache.thrift.transport.TTransportException) {
                            _LOGGER.error("TTransportException inside handler", e);
                            fb.close();
                            return;
                        } else if (e instanceof org.apache.thrift.TApplicationException) {
                            _LOGGER.error("TApplicationException inside handler", e);
                            msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
                            msg = (org.apache.thrift.TApplicationException) e;
                        } else {
                            _LOGGER.error("Exception inside handler", e);
                            msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
                            msg = new org.apache.thrift.TApplicationException(
                                    org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
                        }
                        try {
                            fcall.sendResponse(fb, msg, msgType, seqid);
                        } catch (java.lang.Exception ex) {
                            _LOGGER.error("Exception writing to internal frame buffer", ex);
                            fb.close();
                        }
                    }
                };
            }

            protected boolean isOneway() {
                return false;
            }

            public void start(I iface, echo_args args, org.apache.thrift.async.AsyncMethodCallback<Work> resultHandler)
                    throws org.apache.thrift.TException {
                iface.echo(args.w, resultHandler);
            }
        }

        public static class alltypes<I extends AsyncIface>
                extends org.apache.thrift.AsyncProcessFunction<I, alltypes_args, java.lang.Integer> {
            public alltypes() {
                super("alltypes");
            }

            public alltypes_args getEmptyArgsInstance() {
                return new alltypes_args();
            }

            public org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> getResultHandler(
                    final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
                final org.apache.thrift.AsyncProcessFunction fcall = this;
                return new org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer>() {
                    public void onComplete(java.lang.Integer o) {
                        alltypes_result result = new alltypes_result();
                        result.success = o;
                        result.setSuccessIsSet(true);
                        try {
                            fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY, seqid);
                        } catch (org.apache.thrift.transport.TTransportException e) {
                            _LOGGER.error("TTransportException writing to internal frame buffer", e);
                            fb.close();
                        } catch (java.lang.Exception e) {
                            _LOGGER.error("Exception writing to internal frame buffer", e);
                            onError(e);
                        }
                    }

                    public void onError(java.lang.Exception e) {
                        byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
                        org.apache.thrift.TSerializable msg;
                        alltypes_result result = new alltypes_result();
                        if (e instanceof org.apache.thrift.transport.TTransportException) {
                            _LOGGER.error("TTransportException inside handler", e);
                            fb.close();
                            return;
                        } else if (e instanceof org.apache.thrift.TApplicationException) {
                            _LOGGER.error("TApplicationException inside handler", e);
                            msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
                            msg = (org.apache.thrift.TApplicationException) e;
                        } else {
                            _LOGGER.error("Exception inside handler", e);
                            msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
                            msg = new org.apache.thrift.TApplicationException(
                                    org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
                        }
                        try {
                            fcall.sendResponse(fb, msg, msgType, seqid);
                        } catch (java.lang.Exception ex) {
                            _LOGGER.error("Exception writing to internal frame buffer", ex);
                            fb.close();
                        }
                    }
                };
            }

            protected boolean isOneway() {
                return false;
            }

            public void start(
                    I iface, alltypes_args args, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler)
                    throws org.apache.thrift.TException {
                iface.alltypes(args.v1, args.v2, args.v3, args.v4, args.v5, args.v6, args.v7, args.v8, args.v9, args.v10,
                        args.v11, args.v12, resultHandler);
            }
        }

    }

    public static class ping_args
            implements org.apache.thrift.TBase<ping_args, ping_args._Fields>, java.io.Serializable, Cloneable,
            Comparable<ping_args> {
        private static final org.apache.thrift.protocol.TStruct STRUCT_DESC
                = new org.apache.thrift.protocol.TStruct("ping_args");

        private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY
                = new ping_argsStandardSchemeFactory();
        private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new ping_argsTupleSchemeFactory();

        /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
        public enum _Fields implements org.apache.thrift.TFieldIdEnum {
            ;

            private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<>();

            static {
                for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, or null if its not found.
             */
            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    default:
                        return null;
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, throwing an exception if it is not found.
             */
            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = findByThriftId(fieldId);
                if (fields == null)
                    throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                return fields;
            }

            /**
             * Find the _Fields constant that matches name, or null if its not found.
             */
            public static _Fields findByName(java.lang.String name) {
                return byName.get(name);
            }

            private final short _thriftId;
            private final java.lang.String _fieldName;

            _Fields(short thriftId, java.lang.String fieldName) {
                _thriftId = thriftId;
                _fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return _thriftId;
            }

            public java.lang.String getFieldName() {
                return _fieldName;
            }
        }

        public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
        static {
            java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<>(_Fields.class);
            metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
            org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(ping_args.class, metaDataMap);
        }

        public ping_args() {
        }

        /**
         * Performs a deep copy on <i>other</i>.
         */
        public ping_args(ping_args other) {
        }

        public ping_args deepCopy() {
            return new ping_args(this);
        }

        @Override
        public void clear() {
        }

        public void setFieldValue(_Fields field, java.lang.Object value) {
            switch (field) {
            }
        }

        public java.lang.Object getFieldValue(_Fields field) {
            switch (field) {
            }
            throw new java.lang.IllegalStateException();
        }

        /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new java.lang.IllegalArgumentException();
            }

            switch (field) {
            }
            throw new java.lang.IllegalStateException();
        }

        @Override
        public boolean equals(java.lang.Object that) {
            if (that == null)
                return false;
            if (that instanceof ping_args)
                return this.equals((ping_args) that);
            return false;
        }

        public boolean equals(ping_args that) {
            if (that == null)
                return false;
            if (this == that)
                return true;

            return true;
        }

        @Override
        public int hashCode() {
            int hashCode = 1;

            return hashCode;
        }

        @Override
        public int compareTo(ping_args other) {
            if (!getClass().equals(other.getClass())) {
                return getClass().getName().compareTo(other.getClass().getName());
            }

            int lastComparison = 0;

            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
            scheme(iprot).read(iprot, this);
        }

        public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
            scheme(oprot).write(oprot, this);
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder sb = new java.lang.StringBuilder("ping_args(");
            boolean first = true;

            sb.append(")");
            return sb.toString();
        }

        public void validate() throws org.apache.thrift.TException {
            // check for required fields
            // check for sub-struct validity
        }

        private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
            try {
                write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
            try {
                read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private static class ping_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
            public ping_argsStandardScheme getScheme() {
                return new ping_argsStandardScheme();
            }
        }

        private static class ping_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<ping_args> {

            public void read(org.apache.thrift.protocol.TProtocol iprot, ping_args struct) throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TField schemeField;
                iprot.readStructBegin();
                while (true) {
                    schemeField = iprot.readFieldBegin();
                    if (schemeField.type == org.apache.thrift.protocol.TType.STOP) {
                        break;
                    }
                    switch (schemeField.id) {
                        default:
                            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();

                // check for required fields of primitive type, which can't be checked in the validate method
                struct.validate();
            }

            public void write(org.apache.thrift.protocol.TProtocol oprot, ping_args struct)
                    throws org.apache.thrift.TException {
                struct.validate();

                oprot.writeStructBegin(STRUCT_DESC);
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }

        }

        private static class ping_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
            public ping_argsTupleScheme getScheme() {
                return new ping_argsTupleScheme();
            }
        }

        private static class ping_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<ping_args> {

            @Override
            public void write(org.apache.thrift.protocol.TProtocol prot, ping_args struct) throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
            }

            @Override
            public void read(org.apache.thrift.protocol.TProtocol prot, ping_args struct) throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
            }
        }

        private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
            return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme())
                    ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
        }
    }

    public static class ping_result
            implements org.apache.thrift.TBase<ping_result, ping_result._Fields>, java.io.Serializable, Cloneable,
            Comparable<ping_result> {
        private static final org.apache.thrift.protocol.TStruct STRUCT_DESC
                = new org.apache.thrift.protocol.TStruct("ping_result");

        private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY
                = new ping_resultStandardSchemeFactory();
        private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new ping_resultTupleSchemeFactory();

        /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
        public enum _Fields implements org.apache.thrift.TFieldIdEnum {
            ;

            private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<>();

            static {
                for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, or null if its not found.
             */
            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    default:
                        return null;
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, throwing an exception if it is not found.
             */
            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = findByThriftId(fieldId);
                if (fields == null)
                    throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                return fields;
            }

            /**
             * Find the _Fields constant that matches name, or null if its not found.
             */
            public static _Fields findByName(java.lang.String name) {
                return byName.get(name);
            }

            private final short _thriftId;
            private final java.lang.String _fieldName;

            _Fields(short thriftId, java.lang.String fieldName) {
                _thriftId = thriftId;
                _fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return _thriftId;
            }

            public java.lang.String getFieldName() {
                return _fieldName;
            }
        }

        public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
        static {
            java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<>(_Fields.class);
            metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
            org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(ping_result.class, metaDataMap);
        }

        public ping_result() {
        }

        /**
         * Performs a deep copy on <i>other</i>.
         */
        public ping_result(ping_result other) {
        }

        public ping_result deepCopy() {
            return new ping_result(this);
        }

        @Override
        public void clear() {
        }

        public void setFieldValue(_Fields field, java.lang.Object value) {
            switch (field) {
            }
        }

        public java.lang.Object getFieldValue(_Fields field) {
            switch (field) {
            }
            throw new java.lang.IllegalStateException();
        }

        /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new java.lang.IllegalArgumentException();
            }

            switch (field) {
            }
            throw new java.lang.IllegalStateException();
        }

        @Override
        public boolean equals(java.lang.Object that) {
            if (that == null)
                return false;
            if (that instanceof ping_result)
                return this.equals((ping_result) that);
            return false;
        }

        public boolean equals(ping_result that) {
            if (that == null)
                return false;
            if (this == that)
                return true;

            return true;
        }

        @Override
        public int hashCode() {
            int hashCode = 1;

            return hashCode;
        }

        @Override
        public int compareTo(ping_result other) {
            if (!getClass().equals(other.getClass())) {
                return getClass().getName().compareTo(other.getClass().getName());
            }

            int lastComparison = 0;

            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
            scheme(iprot).read(iprot, this);
        }

        public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
            scheme(oprot).write(oprot, this);
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder sb = new java.lang.StringBuilder("ping_result(");
            boolean first = true;

            sb.append(")");
            return sb.toString();
        }

        public void validate() throws org.apache.thrift.TException {
            // check for required fields
            // check for sub-struct validity
        }

        private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
            try {
                write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
            try {
                read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private static class ping_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
            public ping_resultStandardScheme getScheme() {
                return new ping_resultStandardScheme();
            }
        }

        private static class ping_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<ping_result> {

            public void read(org.apache.thrift.protocol.TProtocol iprot, ping_result struct)
                    throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TField schemeField;
                iprot.readStructBegin();
                while (true) {
                    schemeField = iprot.readFieldBegin();
                    if (schemeField.type == org.apache.thrift.protocol.TType.STOP) {
                        break;
                    }
                    switch (schemeField.id) {
                        default:
                            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();

                // check for required fields of primitive type, which can't be checked in the validate method
                struct.validate();
            }

            public void write(org.apache.thrift.protocol.TProtocol oprot, ping_result struct)
                    throws org.apache.thrift.TException {
                struct.validate();

                oprot.writeStructBegin(STRUCT_DESC);
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }

        }

        private static class ping_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
            public ping_resultTupleScheme getScheme() {
                return new ping_resultTupleScheme();
            }
        }

        private static class ping_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<ping_result> {

            @Override
            public void write(org.apache.thrift.protocol.TProtocol prot, ping_result struct)
                    throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
            }

            @Override
            public void read(org.apache.thrift.protocol.TProtocol prot, ping_result struct)
                    throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
            }
        }

        private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
            return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme())
                    ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
        }
    }

    public static class add_args
            implements org.apache.thrift.TBase<add_args, add_args._Fields>, java.io.Serializable, Cloneable,
            Comparable<add_args> {
        private static final org.apache.thrift.protocol.TStruct STRUCT_DESC
                = new org.apache.thrift.protocol.TStruct("add_args");

        private static final org.apache.thrift.protocol.TField NUM1_FIELD_DESC
                = new org.apache.thrift.protocol.TField("num1", org.apache.thrift.protocol.TType.I32, (short) 1);
        private static final org.apache.thrift.protocol.TField NUM2_FIELD_DESC
                = new org.apache.thrift.protocol.TField("num2", org.apache.thrift.protocol.TType.I32, (short) 2);

        private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY
                = new add_argsStandardSchemeFactory();
        private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new add_argsTupleSchemeFactory();

        public int num1; // required
        public int num2; // required

        /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
        public enum _Fields implements org.apache.thrift.TFieldIdEnum {
            NUM1((short) 1, "num1"),
            NUM2((short) 2, "num2");

            private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<>();

            static {
                for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, or null if its not found.
             */
            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    case 1: // NUM1
                        return NUM1;
                    case 2: // NUM2
                        return NUM2;
                    default:
                        return null;
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, throwing an exception if it is not found.
             */
            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = findByThriftId(fieldId);
                if (fields == null)
                    throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                return fields;
            }

            /**
             * Find the _Fields constant that matches name, or null if its not found.
             */
            public static _Fields findByName(java.lang.String name) {
                return byName.get(name);
            }

            private final short _thriftId;
            private final java.lang.String _fieldName;

            _Fields(short thriftId, java.lang.String fieldName) {
                _thriftId = thriftId;
                _fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return _thriftId;
            }

            public java.lang.String getFieldName() {
                return _fieldName;
            }
        }

        // isset id assignments
        private static final int __NUM1_ISSET_ID = 0;
        private static final int __NUM2_ISSET_ID = 1;
        private byte __isset_bitfield = 0;
        public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
        static {
            java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<>(_Fields.class);
            tmpMap.put(_Fields.NUM1,
                    new org.apache.thrift.meta_data.FieldMetaData(
                            "num1", org.apache.thrift.TFieldRequirementType.DEFAULT,
                            new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
            tmpMap.put(_Fields.NUM2,
                    new org.apache.thrift.meta_data.FieldMetaData(
                            "num2", org.apache.thrift.TFieldRequirementType.DEFAULT,
                            new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
            metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
            org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(add_args.class, metaDataMap);
        }

        public add_args() {
        }

        public add_args(
                        int num1,
                        int num2) {
            this();
            this.num1 = num1;
            setNum1IsSet(true);
            this.num2 = num2;
            setNum2IsSet(true);
        }

        /**
         * Performs a deep copy on <i>other</i>.
         */
        public add_args(add_args other) {
            __isset_bitfield = other.__isset_bitfield;
            this.num1 = other.num1;
            this.num2 = other.num2;
        }

        public add_args deepCopy() {
            return new add_args(this);
        }

        @Override
        public void clear() {
            setNum1IsSet(false);
            this.num1 = 0;
            setNum2IsSet(false);
            this.num2 = 0;
        }

        public int getNum1() {
            return this.num1;
        }

        public add_args setNum1(int num1) {
            this.num1 = num1;
            setNum1IsSet(true);
            return this;
        }

        public void unsetNum1() {
            __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __NUM1_ISSET_ID);
        }

        /** Returns true if field num1 is set (has been assigned a value) and false otherwise */
        public boolean isSetNum1() {
            return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __NUM1_ISSET_ID);
        }

        public void setNum1IsSet(boolean value) {
            __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __NUM1_ISSET_ID, value);
        }

        public int getNum2() {
            return this.num2;
        }

        public add_args setNum2(int num2) {
            this.num2 = num2;
            setNum2IsSet(true);
            return this;
        }

        public void unsetNum2() {
            __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __NUM2_ISSET_ID);
        }

        /** Returns true if field num2 is set (has been assigned a value) and false otherwise */
        public boolean isSetNum2() {
            return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __NUM2_ISSET_ID);
        }

        public void setNum2IsSet(boolean value) {
            __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __NUM2_ISSET_ID, value);
        }

        public void setFieldValue(_Fields field, java.lang.Object value) {
            switch (field) {
                case NUM1:
                    if (value == null) {
                        unsetNum1();
                    } else {
                        setNum1((java.lang.Integer) value);
                    }
                    break;

                case NUM2:
                    if (value == null) {
                        unsetNum2();
                    } else {
                        setNum2((java.lang.Integer) value);
                    }
                    break;

            }
        }

        public java.lang.Object getFieldValue(_Fields field) {
            switch (field) {
                case NUM1:
                    return getNum1();

                case NUM2:
                    return getNum2();

            }
            throw new java.lang.IllegalStateException();
        }

        /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new java.lang.IllegalArgumentException();
            }

            switch (field) {
                case NUM1:
                    return isSetNum1();
                case NUM2:
                    return isSetNum2();
            }
            throw new java.lang.IllegalStateException();
        }

        @Override
        public boolean equals(java.lang.Object that) {
            if (that == null)
                return false;
            if (that instanceof add_args)
                return this.equals((add_args) that);
            return false;
        }

        public boolean equals(add_args that) {
            if (that == null)
                return false;
            if (this == that)
                return true;

            boolean this_present_num1 = true;
            boolean that_present_num1 = true;
            if (this_present_num1 || that_present_num1) {
                if (!(this_present_num1 && that_present_num1))
                    return false;
                if (this.num1 != that.num1)
                    return false;
            }

            boolean this_present_num2 = true;
            boolean that_present_num2 = true;
            if (this_present_num2 || that_present_num2) {
                if (!(this_present_num2 && that_present_num2))
                    return false;
                if (this.num2 != that.num2)
                    return false;
            }

            return true;
        }

        @Override
        public int hashCode() {
            int hashCode = 1;

            hashCode = hashCode * 8191 + num1;

            hashCode = hashCode * 8191 + num2;

            return hashCode;
        }

        @Override
        public int compareTo(add_args other) {
            if (!getClass().equals(other.getClass())) {
                return getClass().getName().compareTo(other.getClass().getName());
            }

            int lastComparison = 0;

            lastComparison = java.lang.Boolean.valueOf(isSetNum1()).compareTo(other.isSetNum1());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (isSetNum1()) {
                lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.num1, other.num1);
                if (lastComparison != 0) {
                    return lastComparison;
                }
            }
            lastComparison = java.lang.Boolean.valueOf(isSetNum2()).compareTo(other.isSetNum2());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (isSetNum2()) {
                lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.num2, other.num2);
                if (lastComparison != 0) {
                    return lastComparison;
                }
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
            scheme(iprot).read(iprot, this);
        }

        public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
            scheme(oprot).write(oprot, this);
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder sb = new java.lang.StringBuilder("add_args(");
            boolean first = true;

            sb.append("num1:");
            sb.append(this.num1);
            first = false;
            if (!first)
                sb.append(", ");
            sb.append("num2:");
            sb.append(this.num2);
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws org.apache.thrift.TException {
            // check for required fields
            // check for sub-struct validity
        }

        private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
            try {
                write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
            try {
                // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
                __isset_bitfield = 0;
                read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private static class add_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
            public add_argsStandardScheme getScheme() {
                return new add_argsStandardScheme();
            }
        }

        private static class add_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<add_args> {

            public void read(org.apache.thrift.protocol.TProtocol iprot, add_args struct) throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TField schemeField;
                iprot.readStructBegin();
                while (true) {
                    schemeField = iprot.readFieldBegin();
                    if (schemeField.type == org.apache.thrift.protocol.TType.STOP) {
                        break;
                    }
                    switch (schemeField.id) {
                        case 1: // NUM1
                            if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                                struct.num1 = iprot.readI32();
                                struct.setNum1IsSet(true);
                            } else {
                                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                            }
                            break;
                        case 2: // NUM2
                            if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                                struct.num2 = iprot.readI32();
                                struct.setNum2IsSet(true);
                            } else {
                                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                            }
                            break;
                        default:
                            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();

                // check for required fields of primitive type, which can't be checked in the validate method
                struct.validate();
            }

            public void write(org.apache.thrift.protocol.TProtocol oprot, add_args struct) throws org.apache.thrift.TException {
                struct.validate();

                oprot.writeStructBegin(STRUCT_DESC);
                oprot.writeFieldBegin(NUM1_FIELD_DESC);
                oprot.writeI32(struct.num1);
                oprot.writeFieldEnd();
                oprot.writeFieldBegin(NUM2_FIELD_DESC);
                oprot.writeI32(struct.num2);
                oprot.writeFieldEnd();
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }

        }

        private static class add_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
            public add_argsTupleScheme getScheme() {
                return new add_argsTupleScheme();
            }
        }

        private static class add_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<add_args> {

            @Override
            public void write(org.apache.thrift.protocol.TProtocol prot, add_args struct) throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
                java.util.BitSet optionals = new java.util.BitSet();
                if (struct.isSetNum1()) {
                    optionals.set(0);
                }
                if (struct.isSetNum2()) {
                    optionals.set(1);
                }
                oprot.writeBitSet(optionals, 2);
                if (struct.isSetNum1()) {
                    oprot.writeI32(struct.num1);
                }
                if (struct.isSetNum2()) {
                    oprot.writeI32(struct.num2);
                }
            }

            @Override
            public void read(org.apache.thrift.protocol.TProtocol prot, add_args struct) throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
                java.util.BitSet incoming = iprot.readBitSet(2);
                if (incoming.get(0)) {
                    struct.num1 = iprot.readI32();
                    struct.setNum1IsSet(true);
                }
                if (incoming.get(1)) {
                    struct.num2 = iprot.readI32();
                    struct.setNum2IsSet(true);
                }
            }
        }

        private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
            return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme())
                    ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
        }
    }

    public static class add_result
            implements org.apache.thrift.TBase<add_result, add_result._Fields>, java.io.Serializable, Cloneable,
            Comparable<add_result> {
        private static final org.apache.thrift.protocol.TStruct STRUCT_DESC
                = new org.apache.thrift.protocol.TStruct("add_result");

        private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC
                = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.I32, (short) 0);

        private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY
                = new add_resultStandardSchemeFactory();
        private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new add_resultTupleSchemeFactory();

        public int success; // required

        /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
        public enum _Fields implements org.apache.thrift.TFieldIdEnum {
            SUCCESS((short) 0, "success");

            private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<>();

            static {
                for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, or null if its not found.
             */
            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    case 0: // SUCCESS
                        return SUCCESS;
                    default:
                        return null;
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, throwing an exception if it is not found.
             */
            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = findByThriftId(fieldId);
                if (fields == null)
                    throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                return fields;
            }

            /**
             * Find the _Fields constant that matches name, or null if its not found.
             */
            public static _Fields findByName(java.lang.String name) {
                return byName.get(name);
            }

            private final short _thriftId;
            private final java.lang.String _fieldName;

            _Fields(short thriftId, java.lang.String fieldName) {
                _thriftId = thriftId;
                _fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return _thriftId;
            }

            public java.lang.String getFieldName() {
                return _fieldName;
            }
        }

        // isset id assignments
        private static final int __SUCCESS_ISSET_ID = 0;
        private byte __isset_bitfield = 0;
        public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
        static {
            java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<>(_Fields.class);
            tmpMap.put(_Fields.SUCCESS,
                    new org.apache.thrift.meta_data.FieldMetaData(
                            "success", org.apache.thrift.TFieldRequirementType.DEFAULT,
                            new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
            metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
            org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(add_result.class, metaDataMap);
        }

        public add_result() {
        }

        public add_result(
                          int success) {
            this();
            this.success = success;
            setSuccessIsSet(true);
        }

        /**
         * Performs a deep copy on <i>other</i>.
         */
        public add_result(add_result other) {
            __isset_bitfield = other.__isset_bitfield;
            this.success = other.success;
        }

        public add_result deepCopy() {
            return new add_result(this);
        }

        @Override
        public void clear() {
            setSuccessIsSet(false);
            this.success = 0;
        }

        public int getSuccess() {
            return this.success;
        }

        public add_result setSuccess(int success) {
            this.success = success;
            setSuccessIsSet(true);
            return this;
        }

        public void unsetSuccess() {
            __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
        }

        /** Returns true if field success is set (has been assigned a value) and false otherwise */
        public boolean isSetSuccess() {
            return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
        }

        public void setSuccessIsSet(boolean value) {
            __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
        }

        public void setFieldValue(_Fields field, java.lang.Object value) {
            switch (field) {
                case SUCCESS:
                    if (value == null) {
                        unsetSuccess();
                    } else {
                        setSuccess((java.lang.Integer) value);
                    }
                    break;

            }
        }

        public java.lang.Object getFieldValue(_Fields field) {
            switch (field) {
                case SUCCESS:
                    return getSuccess();

            }
            throw new java.lang.IllegalStateException();
        }

        /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new java.lang.IllegalArgumentException();
            }

            switch (field) {
                case SUCCESS:
                    return isSetSuccess();
            }
            throw new java.lang.IllegalStateException();
        }

        @Override
        public boolean equals(java.lang.Object that) {
            if (that == null)
                return false;
            if (that instanceof add_result)
                return this.equals((add_result) that);
            return false;
        }

        public boolean equals(add_result that) {
            if (that == null)
                return false;
            if (this == that)
                return true;

            boolean this_present_success = true;
            boolean that_present_success = true;
            if (this_present_success || that_present_success) {
                if (!(this_present_success && that_present_success))
                    return false;
                if (this.success != that.success)
                    return false;
            }

            return true;
        }

        @Override
        public int hashCode() {
            int hashCode = 1;

            hashCode = hashCode * 8191 + success;

            return hashCode;
        }

        @Override
        public int compareTo(add_result other) {
            if (!getClass().equals(other.getClass())) {
                return getClass().getName().compareTo(other.getClass().getName());
            }

            int lastComparison = 0;

            lastComparison = java.lang.Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (isSetSuccess()) {
                lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
                if (lastComparison != 0) {
                    return lastComparison;
                }
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
            scheme(iprot).read(iprot, this);
        }

        public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
            scheme(oprot).write(oprot, this);
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder sb = new java.lang.StringBuilder("add_result(");
            boolean first = true;

            sb.append("success:");
            sb.append(this.success);
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws org.apache.thrift.TException {
            // check for required fields
            // check for sub-struct validity
        }

        private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
            try {
                write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
            try {
                // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
                __isset_bitfield = 0;
                read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private static class add_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
            public add_resultStandardScheme getScheme() {
                return new add_resultStandardScheme();
            }
        }

        private static class add_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<add_result> {

            public void read(org.apache.thrift.protocol.TProtocol iprot, add_result struct)
                    throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TField schemeField;
                iprot.readStructBegin();
                while (true) {
                    schemeField = iprot.readFieldBegin();
                    if (schemeField.type == org.apache.thrift.protocol.TType.STOP) {
                        break;
                    }
                    switch (schemeField.id) {
                        case 0: // SUCCESS
                            if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                                struct.success = iprot.readI32();
                                struct.setSuccessIsSet(true);
                            } else {
                                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                            }
                            break;
                        default:
                            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();

                // check for required fields of primitive type, which can't be checked in the validate method
                struct.validate();
            }

            public void write(org.apache.thrift.protocol.TProtocol oprot, add_result struct)
                    throws org.apache.thrift.TException {
                struct.validate();

                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.isSetSuccess()) {
                    oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                    oprot.writeI32(struct.success);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }

        }

        private static class add_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
            public add_resultTupleScheme getScheme() {
                return new add_resultTupleScheme();
            }
        }

        private static class add_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<add_result> {

            @Override
            public void write(org.apache.thrift.protocol.TProtocol prot, add_result struct)
                    throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
                java.util.BitSet optionals = new java.util.BitSet();
                if (struct.isSetSuccess()) {
                    optionals.set(0);
                }
                oprot.writeBitSet(optionals, 1);
                if (struct.isSetSuccess()) {
                    oprot.writeI32(struct.success);
                }
            }

            @Override
            public void read(org.apache.thrift.protocol.TProtocol prot, add_result struct) throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
                java.util.BitSet incoming = iprot.readBitSet(1);
                if (incoming.get(0)) {
                    struct.success = iprot.readI32();
                    struct.setSuccessIsSet(true);
                }
            }
        }

        private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
            return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme())
                    ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
        }
    }

    public static class calculate_args
            implements org.apache.thrift.TBase<calculate_args, calculate_args._Fields>, java.io.Serializable, Cloneable,
            Comparable<calculate_args> {
        private static final org.apache.thrift.protocol.TStruct STRUCT_DESC
                = new org.apache.thrift.protocol.TStruct("calculate_args");

        private static final org.apache.thrift.protocol.TField LOGID_FIELD_DESC
                = new org.apache.thrift.protocol.TField("logid", org.apache.thrift.protocol.TType.I32, (short) 1);
        private static final org.apache.thrift.protocol.TField W_FIELD_DESC
                = new org.apache.thrift.protocol.TField("w", org.apache.thrift.protocol.TType.STRUCT, (short) 2);

        private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY
                = new calculate_argsStandardSchemeFactory();
        private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY
                = new calculate_argsTupleSchemeFactory();

        public int logid; // required
        public Work w; // required

        /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
        public enum _Fields implements org.apache.thrift.TFieldIdEnum {
            LOGID((short) 1, "logid"),
            W((short) 2, "w");

            private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<>();

            static {
                for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, or null if its not found.
             */
            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    case 1: // LOGID
                        return LOGID;
                    case 2: // W
                        return W;
                    default:
                        return null;
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, throwing an exception if it is not found.
             */
            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = findByThriftId(fieldId);
                if (fields == null)
                    throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                return fields;
            }

            /**
             * Find the _Fields constant that matches name, or null if its not found.
             */
            public static _Fields findByName(java.lang.String name) {
                return byName.get(name);
            }

            private final short _thriftId;
            private final java.lang.String _fieldName;

            _Fields(short thriftId, java.lang.String fieldName) {
                _thriftId = thriftId;
                _fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return _thriftId;
            }

            public java.lang.String getFieldName() {
                return _fieldName;
            }
        }

        // isset id assignments
        private static final int __LOGID_ISSET_ID = 0;
        private byte __isset_bitfield = 0;
        public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
        static {
            java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<>(_Fields.class);
            tmpMap.put(_Fields.LOGID,
                    new org.apache.thrift.meta_data.FieldMetaData(
                            "logid", org.apache.thrift.TFieldRequirementType.DEFAULT,
                            new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
            tmpMap.put(_Fields.W, new org.apache.thrift.meta_data.FieldMetaData(
                    "w", org.apache.thrift.TFieldRequirementType.DEFAULT,
                    new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Work.class)));
            metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
            org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(calculate_args.class, metaDataMap);
        }

        public calculate_args() {
        }

        public calculate_args(
                              int logid,
                              Work w) {
            this();
            this.logid = logid;
            setLogidIsSet(true);
            this.w = w;
        }

        /**
         * Performs a deep copy on <i>other</i>.
         */
        public calculate_args(calculate_args other) {
            __isset_bitfield = other.__isset_bitfield;
            this.logid = other.logid;
            if (other.isSetW()) {
                this.w = new Work(other.w);
            }
        }

        public calculate_args deepCopy() {
            return new calculate_args(this);
        }

        @Override
        public void clear() {
            setLogidIsSet(false);
            this.logid = 0;
            this.w = null;
        }

        public int getLogid() {
            return this.logid;
        }

        public calculate_args setLogid(int logid) {
            this.logid = logid;
            setLogidIsSet(true);
            return this;
        }

        public void unsetLogid() {
            __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __LOGID_ISSET_ID);
        }

        /** Returns true if field logid is set (has been assigned a value) and false otherwise */
        public boolean isSetLogid() {
            return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __LOGID_ISSET_ID);
        }

        public void setLogidIsSet(boolean value) {
            __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __LOGID_ISSET_ID, value);
        }

        public Work getW() {
            return this.w;
        }

        public calculate_args setW(Work w) {
            this.w = w;
            return this;
        }

        public void unsetW() {
            this.w = null;
        }

        /** Returns true if field w is set (has been assigned a value) and false otherwise */
        public boolean isSetW() {
            return this.w != null;
        }

        public void setWIsSet(boolean value) {
            if (!value) {
                this.w = null;
            }
        }

        public void setFieldValue(_Fields field, java.lang.Object value) {
            switch (field) {
                case LOGID:
                    if (value == null) {
                        unsetLogid();
                    } else {
                        setLogid((java.lang.Integer) value);
                    }
                    break;

                case W:
                    if (value == null) {
                        unsetW();
                    } else {
                        setW((Work) value);
                    }
                    break;

            }
        }

        public java.lang.Object getFieldValue(_Fields field) {
            switch (field) {
                case LOGID:
                    return getLogid();

                case W:
                    return getW();

            }
            throw new java.lang.IllegalStateException();
        }

        /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new java.lang.IllegalArgumentException();
            }

            switch (field) {
                case LOGID:
                    return isSetLogid();
                case W:
                    return isSetW();
            }
            throw new java.lang.IllegalStateException();
        }

        @Override
        public boolean equals(java.lang.Object that) {
            if (that == null)
                return false;
            if (that instanceof calculate_args)
                return this.equals((calculate_args) that);
            return false;
        }

        public boolean equals(calculate_args that) {
            if (that == null)
                return false;
            if (this == that)
                return true;

            boolean this_present_logid = true;
            boolean that_present_logid = true;
            if (this_present_logid || that_present_logid) {
                if (!(this_present_logid && that_present_logid))
                    return false;
                if (this.logid != that.logid)
                    return false;
            }

            boolean this_present_w = true && this.isSetW();
            boolean that_present_w = true && that.isSetW();
            if (this_present_w || that_present_w) {
                if (!(this_present_w && that_present_w))
                    return false;
                if (!this.w.equals(that.w))
                    return false;
            }

            return true;
        }

        @Override
        public int hashCode() {
            int hashCode = 1;

            hashCode = hashCode * 8191 + logid;

            hashCode = hashCode * 8191 + ((isSetW()) ? 131071 : 524287);
            if (isSetW())
                hashCode = hashCode * 8191 + w.hashCode();

            return hashCode;
        }

        @Override
        public int compareTo(calculate_args other) {
            if (!getClass().equals(other.getClass())) {
                return getClass().getName().compareTo(other.getClass().getName());
            }

            int lastComparison = 0;

            lastComparison = java.lang.Boolean.valueOf(isSetLogid()).compareTo(other.isSetLogid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (isSetLogid()) {
                lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.logid, other.logid);
                if (lastComparison != 0) {
                    return lastComparison;
                }
            }
            lastComparison = java.lang.Boolean.valueOf(isSetW()).compareTo(other.isSetW());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (isSetW()) {
                lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.w, other.w);
                if (lastComparison != 0) {
                    return lastComparison;
                }
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
            scheme(iprot).read(iprot, this);
        }

        public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
            scheme(oprot).write(oprot, this);
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder sb = new java.lang.StringBuilder("calculate_args(");
            boolean first = true;

            sb.append("logid:");
            sb.append(this.logid);
            first = false;
            if (!first)
                sb.append(", ");
            sb.append("w:");
            if (this.w == null) {
                sb.append("null");
            } else {
                sb.append(this.w);
            }
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws org.apache.thrift.TException {
            // check for required fields
            // check for sub-struct validity
            if (w != null) {
                w.validate();
            }
        }

        private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
            try {
                write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
            try {
                // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
                __isset_bitfield = 0;
                read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private static class calculate_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
            public calculate_argsStandardScheme getScheme() {
                return new calculate_argsStandardScheme();
            }
        }

        private static class calculate_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<calculate_args> {

            public void read(org.apache.thrift.protocol.TProtocol iprot, calculate_args struct)
                    throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TField schemeField;
                iprot.readStructBegin();
                while (true) {
                    schemeField = iprot.readFieldBegin();
                    if (schemeField.type == org.apache.thrift.protocol.TType.STOP) {
                        break;
                    }
                    switch (schemeField.id) {
                        case 1: // LOGID
                            if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                                struct.logid = iprot.readI32();
                                struct.setLogidIsSet(true);
                            } else {
                                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                            }
                            break;
                        case 2: // W
                            if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                                struct.w = new Work();
                                struct.w.read(iprot);
                                struct.setWIsSet(true);
                            } else {
                                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                            }
                            break;
                        default:
                            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();

                // check for required fields of primitive type, which can't be checked in the validate method
                struct.validate();
            }

            public void write(org.apache.thrift.protocol.TProtocol oprot, calculate_args struct)
                    throws org.apache.thrift.TException {
                struct.validate();

                oprot.writeStructBegin(STRUCT_DESC);
                oprot.writeFieldBegin(LOGID_FIELD_DESC);
                oprot.writeI32(struct.logid);
                oprot.writeFieldEnd();
                if (struct.w != null) {
                    oprot.writeFieldBegin(W_FIELD_DESC);
                    struct.w.write(oprot);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }

        }

        private static class calculate_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
            public calculate_argsTupleScheme getScheme() {
                return new calculate_argsTupleScheme();
            }
        }

        private static class calculate_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<calculate_args> {

            @Override
            public void write(org.apache.thrift.protocol.TProtocol prot, calculate_args struct)
                    throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
                java.util.BitSet optionals = new java.util.BitSet();
                if (struct.isSetLogid()) {
                    optionals.set(0);
                }
                if (struct.isSetW()) {
                    optionals.set(1);
                }
                oprot.writeBitSet(optionals, 2);
                if (struct.isSetLogid()) {
                    oprot.writeI32(struct.logid);
                }
                if (struct.isSetW()) {
                    struct.w.write(oprot);
                }
            }

            @Override
            public void read(org.apache.thrift.protocol.TProtocol prot, calculate_args struct)
                    throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
                java.util.BitSet incoming = iprot.readBitSet(2);
                if (incoming.get(0)) {
                    struct.logid = iprot.readI32();
                    struct.setLogidIsSet(true);
                }
                if (incoming.get(1)) {
                    struct.w = new Work();
                    struct.w.read(iprot);
                    struct.setWIsSet(true);
                }
            }
        }

        private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
            return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme())
                    ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
        }
    }

    public static class calculate_result
            implements org.apache.thrift.TBase<calculate_result, calculate_result._Fields>, java.io.Serializable, Cloneable,
            Comparable<calculate_result> {
        private static final org.apache.thrift.protocol.TStruct STRUCT_DESC
                = new org.apache.thrift.protocol.TStruct("calculate_result");

        private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC
                = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.I32, (short) 0);
        private static final org.apache.thrift.protocol.TField OUCH_FIELD_DESC
                = new org.apache.thrift.protocol.TField("ouch", org.apache.thrift.protocol.TType.STRUCT, (short) 1);

        private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY
                = new calculate_resultStandardSchemeFactory();
        private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY
                = new calculate_resultTupleSchemeFactory();

        public int success; // required
        public InvalidOperation ouch; // required

        /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
        public enum _Fields implements org.apache.thrift.TFieldIdEnum {
            SUCCESS((short) 0, "success"),
            OUCH((short) 1, "ouch");

            private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<>();

            static {
                for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, or null if its not found.
             */
            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    case 0: // SUCCESS
                        return SUCCESS;
                    case 1: // OUCH
                        return OUCH;
                    default:
                        return null;
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, throwing an exception if it is not found.
             */
            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = findByThriftId(fieldId);
                if (fields == null)
                    throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                return fields;
            }

            /**
             * Find the _Fields constant that matches name, or null if its not found.
             */
            public static _Fields findByName(java.lang.String name) {
                return byName.get(name);
            }

            private final short _thriftId;
            private final java.lang.String _fieldName;

            _Fields(short thriftId, java.lang.String fieldName) {
                _thriftId = thriftId;
                _fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return _thriftId;
            }

            public java.lang.String getFieldName() {
                return _fieldName;
            }
        }

        // isset id assignments
        private static final int __SUCCESS_ISSET_ID = 0;
        private byte __isset_bitfield = 0;
        public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
        static {
            java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<>(_Fields.class);
            tmpMap.put(_Fields.SUCCESS,
                    new org.apache.thrift.meta_data.FieldMetaData(
                            "success", org.apache.thrift.TFieldRequirementType.DEFAULT,
                            new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
            tmpMap.put(_Fields.OUCH,
                    new org.apache.thrift.meta_data.FieldMetaData(
                            "ouch", org.apache.thrift.TFieldRequirementType.DEFAULT,
                            new org.apache.thrift.meta_data.StructMetaData(
                                    org.apache.thrift.protocol.TType.STRUCT, InvalidOperation.class)));
            metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
            org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(calculate_result.class, metaDataMap);
        }

        public calculate_result() {
        }

        public calculate_result(
                                int success,
                                InvalidOperation ouch) {
            this();
            this.success = success;
            setSuccessIsSet(true);
            this.ouch = ouch;
        }

        /**
         * Performs a deep copy on <i>other</i>.
         */
        public calculate_result(calculate_result other) {
            __isset_bitfield = other.__isset_bitfield;
            this.success = other.success;
            if (other.isSetOuch()) {
                this.ouch = new InvalidOperation(other.ouch);
            }
        }

        public calculate_result deepCopy() {
            return new calculate_result(this);
        }

        @Override
        public void clear() {
            setSuccessIsSet(false);
            this.success = 0;
            this.ouch = null;
        }

        public int getSuccess() {
            return this.success;
        }

        public calculate_result setSuccess(int success) {
            this.success = success;
            setSuccessIsSet(true);
            return this;
        }

        public void unsetSuccess() {
            __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
        }

        /** Returns true if field success is set (has been assigned a value) and false otherwise */
        public boolean isSetSuccess() {
            return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
        }

        public void setSuccessIsSet(boolean value) {
            __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
        }

        public InvalidOperation getOuch() {
            return this.ouch;
        }

        public calculate_result setOuch(InvalidOperation ouch) {
            this.ouch = ouch;
            return this;
        }

        public void unsetOuch() {
            this.ouch = null;
        }

        /** Returns true if field ouch is set (has been assigned a value) and false otherwise */
        public boolean isSetOuch() {
            return this.ouch != null;
        }

        public void setOuchIsSet(boolean value) {
            if (!value) {
                this.ouch = null;
            }
        }

        public void setFieldValue(_Fields field, java.lang.Object value) {
            switch (field) {
                case SUCCESS:
                    if (value == null) {
                        unsetSuccess();
                    } else {
                        setSuccess((java.lang.Integer) value);
                    }
                    break;

                case OUCH:
                    if (value == null) {
                        unsetOuch();
                    } else {
                        setOuch((InvalidOperation) value);
                    }
                    break;

            }
        }

        public java.lang.Object getFieldValue(_Fields field) {
            switch (field) {
                case SUCCESS:
                    return getSuccess();

                case OUCH:
                    return getOuch();

            }
            throw new java.lang.IllegalStateException();
        }

        /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new java.lang.IllegalArgumentException();
            }

            switch (field) {
                case SUCCESS:
                    return isSetSuccess();
                case OUCH:
                    return isSetOuch();
            }
            throw new java.lang.IllegalStateException();
        }

        @Override
        public boolean equals(java.lang.Object that) {
            if (that == null)
                return false;
            if (that instanceof calculate_result)
                return this.equals((calculate_result) that);
            return false;
        }

        public boolean equals(calculate_result that) {
            if (that == null)
                return false;
            if (this == that)
                return true;

            boolean this_present_success = true;
            boolean that_present_success = true;
            if (this_present_success || that_present_success) {
                if (!(this_present_success && that_present_success))
                    return false;
                if (this.success != that.success)
                    return false;
            }

            boolean this_present_ouch = true && this.isSetOuch();
            boolean that_present_ouch = true && that.isSetOuch();
            if (this_present_ouch || that_present_ouch) {
                if (!(this_present_ouch && that_present_ouch))
                    return false;
                if (!this.ouch.equals(that.ouch))
                    return false;
            }

            return true;
        }

        @Override
        public int hashCode() {
            int hashCode = 1;

            hashCode = hashCode * 8191 + success;

            hashCode = hashCode * 8191 + ((isSetOuch()) ? 131071 : 524287);
            if (isSetOuch())
                hashCode = hashCode * 8191 + ouch.hashCode();

            return hashCode;
        }

        @Override
        public int compareTo(calculate_result other) {
            if (!getClass().equals(other.getClass())) {
                return getClass().getName().compareTo(other.getClass().getName());
            }

            int lastComparison = 0;

            lastComparison = java.lang.Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (isSetSuccess()) {
                lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
                if (lastComparison != 0) {
                    return lastComparison;
                }
            }
            lastComparison = java.lang.Boolean.valueOf(isSetOuch()).compareTo(other.isSetOuch());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (isSetOuch()) {
                lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ouch, other.ouch);
                if (lastComparison != 0) {
                    return lastComparison;
                }
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
            scheme(iprot).read(iprot, this);
        }

        public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
            scheme(oprot).write(oprot, this);
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder sb = new java.lang.StringBuilder("calculate_result(");
            boolean first = true;

            sb.append("success:");
            sb.append(this.success);
            first = false;
            if (!first)
                sb.append(", ");
            sb.append("ouch:");
            if (this.ouch == null) {
                sb.append("null");
            } else {
                sb.append(this.ouch);
            }
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws org.apache.thrift.TException {
            // check for required fields
            // check for sub-struct validity
        }

        private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
            try {
                write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
            try {
                // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
                __isset_bitfield = 0;
                read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private static class calculate_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
            public calculate_resultStandardScheme getScheme() {
                return new calculate_resultStandardScheme();
            }
        }

        private static class calculate_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<calculate_result> {

            public void read(org.apache.thrift.protocol.TProtocol iprot, calculate_result struct)
                    throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TField schemeField;
                iprot.readStructBegin();
                while (true) {
                    schemeField = iprot.readFieldBegin();
                    if (schemeField.type == org.apache.thrift.protocol.TType.STOP) {
                        break;
                    }
                    switch (schemeField.id) {
                        case 0: // SUCCESS
                            if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                                struct.success = iprot.readI32();
                                struct.setSuccessIsSet(true);
                            } else {
                                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                            }
                            break;
                        case 1: // OUCH
                            if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                                struct.ouch = new InvalidOperation();
                                struct.ouch.read(iprot);
                                struct.setOuchIsSet(true);
                            } else {
                                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                            }
                            break;
                        default:
                            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();

                // check for required fields of primitive type, which can't be checked in the validate method
                struct.validate();
            }

            public void write(org.apache.thrift.protocol.TProtocol oprot, calculate_result struct)
                    throws org.apache.thrift.TException {
                struct.validate();

                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.isSetSuccess()) {
                    oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                    oprot.writeI32(struct.success);
                    oprot.writeFieldEnd();
                }
                if (struct.ouch != null) {
                    oprot.writeFieldBegin(OUCH_FIELD_DESC);
                    struct.ouch.write(oprot);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }

        }

        private static class calculate_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
            public calculate_resultTupleScheme getScheme() {
                return new calculate_resultTupleScheme();
            }
        }

        private static class calculate_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<calculate_result> {

            @Override
            public void write(org.apache.thrift.protocol.TProtocol prot, calculate_result struct)
                    throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
                java.util.BitSet optionals = new java.util.BitSet();
                if (struct.isSetSuccess()) {
                    optionals.set(0);
                }
                if (struct.isSetOuch()) {
                    optionals.set(1);
                }
                oprot.writeBitSet(optionals, 2);
                if (struct.isSetSuccess()) {
                    oprot.writeI32(struct.success);
                }
                if (struct.isSetOuch()) {
                    struct.ouch.write(oprot);
                }
            }

            @Override
            public void read(org.apache.thrift.protocol.TProtocol prot, calculate_result struct)
                    throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
                java.util.BitSet incoming = iprot.readBitSet(2);
                if (incoming.get(0)) {
                    struct.success = iprot.readI32();
                    struct.setSuccessIsSet(true);
                }
                if (incoming.get(1)) {
                    struct.ouch = new InvalidOperation();
                    struct.ouch.read(iprot);
                    struct.setOuchIsSet(true);
                }
            }
        }

        private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
            return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme())
                    ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
        }
    }

    public static class zip_args
            implements org.apache.thrift.TBase<zip_args, zip_args._Fields>, java.io.Serializable, Cloneable,
            Comparable<zip_args> {
        private static final org.apache.thrift.protocol.TStruct STRUCT_DESC
                = new org.apache.thrift.protocol.TStruct("zip_args");

        private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY
                = new zip_argsStandardSchemeFactory();
        private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new zip_argsTupleSchemeFactory();

        /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
        public enum _Fields implements org.apache.thrift.TFieldIdEnum {
            ;

            private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<>();

            static {
                for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, or null if its not found.
             */
            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    default:
                        return null;
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, throwing an exception if it is not found.
             */
            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = findByThriftId(fieldId);
                if (fields == null)
                    throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                return fields;
            }

            /**
             * Find the _Fields constant that matches name, or null if its not found.
             */
            public static _Fields findByName(java.lang.String name) {
                return byName.get(name);
            }

            private final short _thriftId;
            private final java.lang.String _fieldName;

            _Fields(short thriftId, java.lang.String fieldName) {
                _thriftId = thriftId;
                _fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return _thriftId;
            }

            public java.lang.String getFieldName() {
                return _fieldName;
            }
        }

        public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
        static {
            java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<>(_Fields.class);
            metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
            org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(zip_args.class, metaDataMap);
        }

        public zip_args() {
        }

        /**
         * Performs a deep copy on <i>other</i>.
         */
        public zip_args(zip_args other) {
        }

        public zip_args deepCopy() {
            return new zip_args(this);
        }

        @Override
        public void clear() {
        }

        public void setFieldValue(_Fields field, java.lang.Object value) {
            switch (field) {
            }
        }

        public java.lang.Object getFieldValue(_Fields field) {
            switch (field) {
            }
            throw new java.lang.IllegalStateException();
        }

        /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new java.lang.IllegalArgumentException();
            }

            switch (field) {
            }
            throw new java.lang.IllegalStateException();
        }

        @Override
        public boolean equals(java.lang.Object that) {
            if (that == null)
                return false;
            if (that instanceof zip_args)
                return this.equals((zip_args) that);
            return false;
        }

        public boolean equals(zip_args that) {
            if (that == null)
                return false;
            if (this == that)
                return true;

            return true;
        }

        @Override
        public int hashCode() {
            int hashCode = 1;

            return hashCode;
        }

        @Override
        public int compareTo(zip_args other) {
            if (!getClass().equals(other.getClass())) {
                return getClass().getName().compareTo(other.getClass().getName());
            }

            int lastComparison = 0;

            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
            scheme(iprot).read(iprot, this);
        }

        public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
            scheme(oprot).write(oprot, this);
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder sb = new java.lang.StringBuilder("zip_args(");
            boolean first = true;

            sb.append(")");
            return sb.toString();
        }

        public void validate() throws org.apache.thrift.TException {
            // check for required fields
            // check for sub-struct validity
        }

        private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
            try {
                write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
            try {
                read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private static class zip_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
            public zip_argsStandardScheme getScheme() {
                return new zip_argsStandardScheme();
            }
        }

        private static class zip_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<zip_args> {

            public void read(org.apache.thrift.protocol.TProtocol iprot, zip_args struct) throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TField schemeField;
                iprot.readStructBegin();
                while (true) {
                    schemeField = iprot.readFieldBegin();
                    if (schemeField.type == org.apache.thrift.protocol.TType.STOP) {
                        break;
                    }
                    switch (schemeField.id) {
                        default:
                            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();

                // check for required fields of primitive type, which can't be checked in the validate method
                struct.validate();
            }

            public void write(org.apache.thrift.protocol.TProtocol oprot, zip_args struct) throws org.apache.thrift.TException {
                struct.validate();

                oprot.writeStructBegin(STRUCT_DESC);
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }

        }

        private static class zip_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
            public zip_argsTupleScheme getScheme() {
                return new zip_argsTupleScheme();
            }
        }

        private static class zip_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<zip_args> {

            @Override
            public void write(org.apache.thrift.protocol.TProtocol prot, zip_args struct) throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
            }

            @Override
            public void read(org.apache.thrift.protocol.TProtocol prot, zip_args struct) throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
            }
        }

        private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
            return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme())
                    ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
        }
    }

    public static class echo_args
            implements org.apache.thrift.TBase<echo_args, echo_args._Fields>, java.io.Serializable, Cloneable,
            Comparable<echo_args> {
        private static final org.apache.thrift.protocol.TStruct STRUCT_DESC
                = new org.apache.thrift.protocol.TStruct("echo_args");

        private static final org.apache.thrift.protocol.TField W_FIELD_DESC
                = new org.apache.thrift.protocol.TField("w", org.apache.thrift.protocol.TType.STRUCT, (short) 1);

        private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY
                = new echo_argsStandardSchemeFactory();
        private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new echo_argsTupleSchemeFactory();

        public Work w; // required

        /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
        public enum _Fields implements org.apache.thrift.TFieldIdEnum {
            W((short) 1, "w");

            private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<>();

            static {
                for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, or null if its not found.
             */
            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    case 1: // W
                        return W;
                    default:
                        return null;
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, throwing an exception if it is not found.
             */
            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = findByThriftId(fieldId);
                if (fields == null)
                    throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                return fields;
            }

            /**
             * Find the _Fields constant that matches name, or null if its not found.
             */
            public static _Fields findByName(java.lang.String name) {
                return byName.get(name);
            }

            private final short _thriftId;
            private final java.lang.String _fieldName;

            _Fields(short thriftId, java.lang.String fieldName) {
                _thriftId = thriftId;
                _fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return _thriftId;
            }

            public java.lang.String getFieldName() {
                return _fieldName;
            }
        }

        // isset id assignments
        public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
        static {
            java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<>(_Fields.class);
            tmpMap.put(_Fields.W, new org.apache.thrift.meta_data.FieldMetaData(
                    "w", org.apache.thrift.TFieldRequirementType.DEFAULT,
                    new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Work.class)));
            metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
            org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(echo_args.class, metaDataMap);
        }

        public echo_args() {
        }

        public echo_args(
                         Work w) {
            this();
            this.w = w;
        }

        /**
         * Performs a deep copy on <i>other</i>.
         */
        public echo_args(echo_args other) {
            if (other.isSetW()) {
                this.w = new Work(other.w);
            }
        }

        public echo_args deepCopy() {
            return new echo_args(this);
        }

        @Override
        public void clear() {
            this.w = null;
        }

        public Work getW() {
            return this.w;
        }

        public echo_args setW(Work w) {
            this.w = w;
            return this;
        }

        public void unsetW() {
            this.w = null;
        }

        /** Returns true if field w is set (has been assigned a value) and false otherwise */
        public boolean isSetW() {
            return this.w != null;
        }

        public void setWIsSet(boolean value) {
            if (!value) {
                this.w = null;
            }
        }

        public void setFieldValue(_Fields field, java.lang.Object value) {
            switch (field) {
                case W:
                    if (value == null) {
                        unsetW();
                    } else {
                        setW((Work) value);
                    }
                    break;

            }
        }

        public java.lang.Object getFieldValue(_Fields field) {
            switch (field) {
                case W:
                    return getW();

            }
            throw new java.lang.IllegalStateException();
        }

        /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new java.lang.IllegalArgumentException();
            }

            switch (field) {
                case W:
                    return isSetW();
            }
            throw new java.lang.IllegalStateException();
        }

        @Override
        public boolean equals(java.lang.Object that) {
            if (that == null)
                return false;
            if (that instanceof echo_args)
                return this.equals((echo_args) that);
            return false;
        }

        public boolean equals(echo_args that) {
            if (that == null)
                return false;
            if (this == that)
                return true;

            boolean this_present_w = true && this.isSetW();
            boolean that_present_w = true && that.isSetW();
            if (this_present_w || that_present_w) {
                if (!(this_present_w && that_present_w))
                    return false;
                if (!this.w.equals(that.w))
                    return false;
            }

            return true;
        }

        @Override
        public int hashCode() {
            int hashCode = 1;

            hashCode = hashCode * 8191 + ((isSetW()) ? 131071 : 524287);
            if (isSetW())
                hashCode = hashCode * 8191 + w.hashCode();

            return hashCode;
        }

        @Override
        public int compareTo(echo_args other) {
            if (!getClass().equals(other.getClass())) {
                return getClass().getName().compareTo(other.getClass().getName());
            }

            int lastComparison = 0;

            lastComparison = java.lang.Boolean.valueOf(isSetW()).compareTo(other.isSetW());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (isSetW()) {
                lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.w, other.w);
                if (lastComparison != 0) {
                    return lastComparison;
                }
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
            scheme(iprot).read(iprot, this);
        }

        public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
            scheme(oprot).write(oprot, this);
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder sb = new java.lang.StringBuilder("echo_args(");
            boolean first = true;

            sb.append("w:");
            if (this.w == null) {
                sb.append("null");
            } else {
                sb.append(this.w);
            }
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws org.apache.thrift.TException {
            // check for required fields
            // check for sub-struct validity
            if (w != null) {
                w.validate();
            }
        }

        private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
            try {
                write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
            try {
                read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private static class echo_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
            public echo_argsStandardScheme getScheme() {
                return new echo_argsStandardScheme();
            }
        }

        private static class echo_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<echo_args> {

            public void read(org.apache.thrift.protocol.TProtocol iprot, echo_args struct) throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TField schemeField;
                iprot.readStructBegin();
                while (true) {
                    schemeField = iprot.readFieldBegin();
                    if (schemeField.type == org.apache.thrift.protocol.TType.STOP) {
                        break;
                    }
                    switch (schemeField.id) {
                        case 1: // W
                            if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                                struct.w = new Work();
                                struct.w.read(iprot);
                                struct.setWIsSet(true);
                            } else {
                                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                            }
                            break;
                        default:
                            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();

                // check for required fields of primitive type, which can't be checked in the validate method
                struct.validate();
            }

            public void write(org.apache.thrift.protocol.TProtocol oprot, echo_args struct)
                    throws org.apache.thrift.TException {
                struct.validate();

                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.w != null) {
                    oprot.writeFieldBegin(W_FIELD_DESC);
                    struct.w.write(oprot);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }

        }

        private static class echo_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
            public echo_argsTupleScheme getScheme() {
                return new echo_argsTupleScheme();
            }
        }

        private static class echo_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<echo_args> {

            @Override
            public void write(org.apache.thrift.protocol.TProtocol prot, echo_args struct) throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
                java.util.BitSet optionals = new java.util.BitSet();
                if (struct.isSetW()) {
                    optionals.set(0);
                }
                oprot.writeBitSet(optionals, 1);
                if (struct.isSetW()) {
                    struct.w.write(oprot);
                }
            }

            @Override
            public void read(org.apache.thrift.protocol.TProtocol prot, echo_args struct) throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
                java.util.BitSet incoming = iprot.readBitSet(1);
                if (incoming.get(0)) {
                    struct.w = new Work();
                    struct.w.read(iprot);
                    struct.setWIsSet(true);
                }
            }
        }

        private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
            return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme())
                    ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
        }
    }

    public static class echo_result
            implements org.apache.thrift.TBase<echo_result, echo_result._Fields>, java.io.Serializable, Cloneable,
            Comparable<echo_result> {
        private static final org.apache.thrift.protocol.TStruct STRUCT_DESC
                = new org.apache.thrift.protocol.TStruct("echo_result");

        private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC
                = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short) 0);

        private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY
                = new echo_resultStandardSchemeFactory();
        private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new echo_resultTupleSchemeFactory();

        public Work success; // required

        /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
        public enum _Fields implements org.apache.thrift.TFieldIdEnum {
            SUCCESS((short) 0, "success");

            private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<>();

            static {
                for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, or null if its not found.
             */
            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    case 0: // SUCCESS
                        return SUCCESS;
                    default:
                        return null;
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, throwing an exception if it is not found.
             */
            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = findByThriftId(fieldId);
                if (fields == null)
                    throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                return fields;
            }

            /**
             * Find the _Fields constant that matches name, or null if its not found.
             */
            public static _Fields findByName(java.lang.String name) {
                return byName.get(name);
            }

            private final short _thriftId;
            private final java.lang.String _fieldName;

            _Fields(short thriftId, java.lang.String fieldName) {
                _thriftId = thriftId;
                _fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return _thriftId;
            }

            public java.lang.String getFieldName() {
                return _fieldName;
            }
        }

        // isset id assignments
        public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
        static {
            java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<>(_Fields.class);
            tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData(
                    "success", org.apache.thrift.TFieldRequirementType.DEFAULT,
                    new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Work.class)));
            metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
            org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(echo_result.class, metaDataMap);
        }

        public echo_result() {
        }

        public echo_result(
                           Work success) {
            this();
            this.success = success;
        }

        /**
         * Performs a deep copy on <i>other</i>.
         */
        public echo_result(echo_result other) {
            if (other.isSetSuccess()) {
                this.success = new Work(other.success);
            }
        }

        public echo_result deepCopy() {
            return new echo_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
        }

        public Work getSuccess() {
            return this.success;
        }

        public echo_result setSuccess(Work success) {
            this.success = success;
            return this;
        }

        public void unsetSuccess() {
            this.success = null;
        }

        /** Returns true if field success is set (has been assigned a value) and false otherwise */
        public boolean isSetSuccess() {
            return this.success != null;
        }

        public void setSuccessIsSet(boolean value) {
            if (!value) {
                this.success = null;
            }
        }

        public void setFieldValue(_Fields field, java.lang.Object value) {
            switch (field) {
                case SUCCESS:
                    if (value == null) {
                        unsetSuccess();
                    } else {
                        setSuccess((Work) value);
                    }
                    break;

            }
        }

        public java.lang.Object getFieldValue(_Fields field) {
            switch (field) {
                case SUCCESS:
                    return getSuccess();

            }
            throw new java.lang.IllegalStateException();
        }

        /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new java.lang.IllegalArgumentException();
            }

            switch (field) {
                case SUCCESS:
                    return isSetSuccess();
            }
            throw new java.lang.IllegalStateException();
        }

        @Override
        public boolean equals(java.lang.Object that) {
            if (that == null)
                return false;
            if (that instanceof echo_result)
                return this.equals((echo_result) that);
            return false;
        }

        public boolean equals(echo_result that) {
            if (that == null)
                return false;
            if (this == that)
                return true;

            boolean this_present_success = true && this.isSetSuccess();
            boolean that_present_success = true && that.isSetSuccess();
            if (this_present_success || that_present_success) {
                if (!(this_present_success && that_present_success))
                    return false;
                if (!this.success.equals(that.success))
                    return false;
            }

            return true;
        }

        @Override
        public int hashCode() {
            int hashCode = 1;

            hashCode = hashCode * 8191 + ((isSetSuccess()) ? 131071 : 524287);
            if (isSetSuccess())
                hashCode = hashCode * 8191 + success.hashCode();

            return hashCode;
        }

        @Override
        public int compareTo(echo_result other) {
            if (!getClass().equals(other.getClass())) {
                return getClass().getName().compareTo(other.getClass().getName());
            }

            int lastComparison = 0;

            lastComparison = java.lang.Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (isSetSuccess()) {
                lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
                if (lastComparison != 0) {
                    return lastComparison;
                }
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
            scheme(iprot).read(iprot, this);
        }

        public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
            scheme(oprot).write(oprot, this);
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder sb = new java.lang.StringBuilder("echo_result(");
            boolean first = true;

            sb.append("success:");
            if (this.success == null) {
                sb.append("null");
            } else {
                sb.append(this.success);
            }
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws org.apache.thrift.TException {
            // check for required fields
            // check for sub-struct validity
            if (success != null) {
                success.validate();
            }
        }

        private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
            try {
                write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
            try {
                read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private static class echo_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
            public echo_resultStandardScheme getScheme() {
                return new echo_resultStandardScheme();
            }
        }

        private static class echo_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<echo_result> {

            public void read(org.apache.thrift.protocol.TProtocol iprot, echo_result struct)
                    throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TField schemeField;
                iprot.readStructBegin();
                while (true) {
                    schemeField = iprot.readFieldBegin();
                    if (schemeField.type == org.apache.thrift.protocol.TType.STOP) {
                        break;
                    }
                    switch (schemeField.id) {
                        case 0: // SUCCESS
                            if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                                struct.success = new Work();
                                struct.success.read(iprot);
                                struct.setSuccessIsSet(true);
                            } else {
                                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                            }
                            break;
                        default:
                            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();

                // check for required fields of primitive type, which can't be checked in the validate method
                struct.validate();
            }

            public void write(org.apache.thrift.protocol.TProtocol oprot, echo_result struct)
                    throws org.apache.thrift.TException {
                struct.validate();

                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.success != null) {
                    oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                    struct.success.write(oprot);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }

        }

        private static class echo_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
            public echo_resultTupleScheme getScheme() {
                return new echo_resultTupleScheme();
            }
        }

        private static class echo_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<echo_result> {

            @Override
            public void write(org.apache.thrift.protocol.TProtocol prot, echo_result struct)
                    throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
                java.util.BitSet optionals = new java.util.BitSet();
                if (struct.isSetSuccess()) {
                    optionals.set(0);
                }
                oprot.writeBitSet(optionals, 1);
                if (struct.isSetSuccess()) {
                    struct.success.write(oprot);
                }
            }

            @Override
            public void read(org.apache.thrift.protocol.TProtocol prot, echo_result struct)
                    throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
                java.util.BitSet incoming = iprot.readBitSet(1);
                if (incoming.get(0)) {
                    struct.success = new Work();
                    struct.success.read(iprot);
                    struct.setSuccessIsSet(true);
                }
            }
        }

        private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
            return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme())
                    ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
        }
    }

    public static class alltypes_args
            implements org.apache.thrift.TBase<alltypes_args, alltypes_args._Fields>, java.io.Serializable, Cloneable,
            Comparable<alltypes_args> {
        private static final org.apache.thrift.protocol.TStruct STRUCT_DESC
                = new org.apache.thrift.protocol.TStruct("alltypes_args");

        private static final org.apache.thrift.protocol.TField V1_FIELD_DESC
                = new org.apache.thrift.protocol.TField("v1", org.apache.thrift.protocol.TType.BOOL, (short) 1);
        private static final org.apache.thrift.protocol.TField V2_FIELD_DESC
                = new org.apache.thrift.protocol.TField("v2", org.apache.thrift.protocol.TType.BYTE, (short) 2);
        private static final org.apache.thrift.protocol.TField V3_FIELD_DESC
                = new org.apache.thrift.protocol.TField("v3", org.apache.thrift.protocol.TType.I16, (short) 3);
        private static final org.apache.thrift.protocol.TField V4_FIELD_DESC
                = new org.apache.thrift.protocol.TField("v4", org.apache.thrift.protocol.TType.I32, (short) 4);
        private static final org.apache.thrift.protocol.TField V5_FIELD_DESC
                = new org.apache.thrift.protocol.TField("v5", org.apache.thrift.protocol.TType.I64, (short) 5);
        private static final org.apache.thrift.protocol.TField V6_FIELD_DESC
                = new org.apache.thrift.protocol.TField("v6", org.apache.thrift.protocol.TType.DOUBLE, (short) 6);
        private static final org.apache.thrift.protocol.TField V7_FIELD_DESC
                = new org.apache.thrift.protocol.TField("v7", org.apache.thrift.protocol.TType.STRING, (short) 7);
        private static final org.apache.thrift.protocol.TField V8_FIELD_DESC
                = new org.apache.thrift.protocol.TField("v8", org.apache.thrift.protocol.TType.STRING, (short) 8);
        private static final org.apache.thrift.protocol.TField V9_FIELD_DESC
                = new org.apache.thrift.protocol.TField("v9", org.apache.thrift.protocol.TType.STRUCT, (short) 9);
        private static final org.apache.thrift.protocol.TField V10_FIELD_DESC
                = new org.apache.thrift.protocol.TField("v10", org.apache.thrift.protocol.TType.LIST, (short) 10);
        private static final org.apache.thrift.protocol.TField V11_FIELD_DESC
                = new org.apache.thrift.protocol.TField("v11", org.apache.thrift.protocol.TType.SET, (short) 11);
        private static final org.apache.thrift.protocol.TField V12_FIELD_DESC
                = new org.apache.thrift.protocol.TField("v12", org.apache.thrift.protocol.TType.MAP, (short) 12);

        private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY
                = new alltypes_argsStandardSchemeFactory();
        private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY
                = new alltypes_argsTupleSchemeFactory();

        public boolean v1; // required
        public byte v2; // required
        public short v3; // required
        public int v4; // required
        public long v5; // required
        public double v6; // required
        public java.lang.String v7; // required
        public java.nio.ByteBuffer v8; // required
        public Work v9; // required
        public java.util.List<java.lang.Integer> v10; // required
        public java.util.Set<java.lang.String> v11; // required
        public java.util.Map<java.lang.String, java.lang.Long> v12; // required

        /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
        public enum _Fields implements org.apache.thrift.TFieldIdEnum {
            V1((short) 1, "v1"),
            V2((short) 2, "v2"),
            V3((short) 3, "v3"),
            V4((short) 4, "v4"),
            V5((short) 5, "v5"),
            V6((short) 6, "v6"),
            V7((short) 7, "v7"),
            V8((short) 8, "v8"),
            V9((short) 9, "v9"),
            V10((short) 10, "v10"),
            V11((short) 11, "v11"),
            V12((short) 12, "v12");

            private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<>();

            static {
                for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, or null if its not found.
             */
            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    case 1: // V1
                        return V1;
                    case 2: // V2
                        return V2;
                    case 3: // V3
                        return V3;
                    case 4: // V4
                        return V4;
                    case 5: // V5
                        return V5;
                    case 6: // V6
                        return V6;
                    case 7: // V7
                        return V7;
                    case 8: // V8
                        return V8;
                    case 9: // V9
                        return V9;
                    case 10: // V10
                        return V10;
                    case 11: // V11
                        return V11;
                    case 12: // V12
                        return V12;
                    default:
                        return null;
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, throwing an exception if it is not found.
             */
            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = findByThriftId(fieldId);
                if (fields == null)
                    throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                return fields;
            }

            /**
             * Find the _Fields constant that matches name, or null if its not found.
             */
            public static _Fields findByName(java.lang.String name) {
                return byName.get(name);
            }

            private final short _thriftId;
            private final java.lang.String _fieldName;

            _Fields(short thriftId, java.lang.String fieldName) {
                _thriftId = thriftId;
                _fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return _thriftId;
            }

            public java.lang.String getFieldName() {
                return _fieldName;
            }
        }

        // isset id assignments
        private static final int __V1_ISSET_ID = 0;
        private static final int __V2_ISSET_ID = 1;
        private static final int __V3_ISSET_ID = 2;
        private static final int __V4_ISSET_ID = 3;
        private static final int __V5_ISSET_ID = 4;
        private static final int __V6_ISSET_ID = 5;
        private byte __isset_bitfield = 0;
        public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
        static {
            java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<>(_Fields.class);
            tmpMap.put(_Fields.V1,
                    new org.apache.thrift.meta_data.FieldMetaData(
                            "v1", org.apache.thrift.TFieldRequirementType.DEFAULT,
                            new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
            tmpMap.put(_Fields.V2,
                    new org.apache.thrift.meta_data.FieldMetaData(
                            "v2", org.apache.thrift.TFieldRequirementType.DEFAULT,
                            new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BYTE)));
            tmpMap.put(_Fields.V3,
                    new org.apache.thrift.meta_data.FieldMetaData(
                            "v3", org.apache.thrift.TFieldRequirementType.DEFAULT,
                            new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I16)));
            tmpMap.put(_Fields.V4,
                    new org.apache.thrift.meta_data.FieldMetaData(
                            "v4", org.apache.thrift.TFieldRequirementType.DEFAULT,
                            new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
            tmpMap.put(_Fields.V5,
                    new org.apache.thrift.meta_data.FieldMetaData(
                            "v5", org.apache.thrift.TFieldRequirementType.DEFAULT,
                            new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
            tmpMap.put(_Fields.V6,
                    new org.apache.thrift.meta_data.FieldMetaData(
                            "v6", org.apache.thrift.TFieldRequirementType.DEFAULT,
                            new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.DOUBLE)));
            tmpMap.put(_Fields.V7,
                    new org.apache.thrift.meta_data.FieldMetaData(
                            "v7", org.apache.thrift.TFieldRequirementType.DEFAULT,
                            new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
            tmpMap.put(_Fields.V8,
                    new org.apache.thrift.meta_data.FieldMetaData(
                            "v8", org.apache.thrift.TFieldRequirementType.DEFAULT,
                            new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING, true)));
            tmpMap.put(_Fields.V9, new org.apache.thrift.meta_data.FieldMetaData(
                    "v9", org.apache.thrift.TFieldRequirementType.DEFAULT,
                    new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Work.class)));
            tmpMap.put(_Fields.V10,
                    new org.apache.thrift.meta_data.FieldMetaData(
                            "v10", org.apache.thrift.TFieldRequirementType.DEFAULT,
                            new org.apache.thrift.meta_data.ListMetaData(
                                    org.apache.thrift.protocol.TType.LIST,
                                    new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32))));
            tmpMap.put(_Fields.V11, new org.apache.thrift.meta_data.FieldMetaData(
                    "v11", org.apache.thrift.TFieldRequirementType.DEFAULT,
                    new org.apache.thrift.meta_data.SetMetaData(
                            org.apache.thrift.protocol.TType.SET,
                            new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING))));
            tmpMap.put(_Fields.V12,
                    new org.apache.thrift.meta_data.FieldMetaData(
                            "v12", org.apache.thrift.TFieldRequirementType.DEFAULT,
                            new org.apache.thrift.meta_data.MapMetaData(
                                    org.apache.thrift.protocol.TType.MAP,
                                    new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING),
                                    new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64))));
            metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
            org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(alltypes_args.class, metaDataMap);
        }

        public alltypes_args() {
        }

        public alltypes_args(
                             boolean v1,
                             byte v2,
                             short v3,
                             int v4,
                             long v5,
                             double v6,
                             java.lang.String v7,
                             java.nio.ByteBuffer v8,
                             Work v9,
                             java.util.List<java.lang.Integer> v10,
                             java.util.Set<java.lang.String> v11,
                             java.util.Map<java.lang.String, java.lang.Long> v12) {
            this();
            this.v1 = v1;
            setV1IsSet(true);
            this.v2 = v2;
            setV2IsSet(true);
            this.v3 = v3;
            setV3IsSet(true);
            this.v4 = v4;
            setV4IsSet(true);
            this.v5 = v5;
            setV5IsSet(true);
            this.v6 = v6;
            setV6IsSet(true);
            this.v7 = v7;
            this.v8 = org.apache.thrift.TBaseHelper.copyBinary(v8);
            this.v9 = v9;
            this.v10 = v10;
            this.v11 = v11;
            this.v12 = v12;
        }

        /**
         * Performs a deep copy on <i>other</i>.
         */
        public alltypes_args(alltypes_args other) {
            __isset_bitfield = other.__isset_bitfield;
            this.v1 = other.v1;
            this.v2 = other.v2;
            this.v3 = other.v3;
            this.v4 = other.v4;
            this.v5 = other.v5;
            this.v6 = other.v6;
            if (other.isSetV7()) {
                this.v7 = other.v7;
            }
            if (other.isSetV8()) {
                this.v8 = org.apache.thrift.TBaseHelper.copyBinary(other.v8);
            }
            if (other.isSetV9()) {
                this.v9 = new Work(other.v9);
            }
            if (other.isSetV10()) {
                java.util.List<java.lang.Integer> __this__v10 = new java.util.ArrayList<>(other.v10);
                this.v10 = __this__v10;
            }
            if (other.isSetV11()) {
                java.util.Set<java.lang.String> __this__v11 = new java.util.HashSet<>(other.v11);
                this.v11 = __this__v11;
            }
            if (other.isSetV12()) {
                java.util.Map<java.lang.String, java.lang.Long> __this__v12 = new java.util.HashMap<>(other.v12);
                this.v12 = __this__v12;
            }
        }

        public alltypes_args deepCopy() {
            return new alltypes_args(this);
        }

        @Override
        public void clear() {
            setV1IsSet(false);
            this.v1 = false;
            setV2IsSet(false);
            this.v2 = 0;
            setV3IsSet(false);
            this.v3 = 0;
            setV4IsSet(false);
            this.v4 = 0;
            setV5IsSet(false);
            this.v5 = 0;
            setV6IsSet(false);
            this.v6 = 0.0;
            this.v7 = null;
            this.v8 = null;
            this.v9 = null;
            this.v10 = null;
            this.v11 = null;
            this.v12 = null;
        }

        public boolean isV1() {
            return this.v1;
        }

        public alltypes_args setV1(boolean v1) {
            this.v1 = v1;
            setV1IsSet(true);
            return this;
        }

        public void unsetV1() {
            __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __V1_ISSET_ID);
        }

        /** Returns true if field v1 is set (has been assigned a value) and false otherwise */
        public boolean isSetV1() {
            return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __V1_ISSET_ID);
        }

        public void setV1IsSet(boolean value) {
            __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __V1_ISSET_ID, value);
        }

        public byte getV2() {
            return this.v2;
        }

        public alltypes_args setV2(byte v2) {
            this.v2 = v2;
            setV2IsSet(true);
            return this;
        }

        public void unsetV2() {
            __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __V2_ISSET_ID);
        }

        /** Returns true if field v2 is set (has been assigned a value) and false otherwise */
        public boolean isSetV2() {
            return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __V2_ISSET_ID);
        }

        public void setV2IsSet(boolean value) {
            __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __V2_ISSET_ID, value);
        }

        public short getV3() {
            return this.v3;
        }

        public alltypes_args setV3(short v3) {
            this.v3 = v3;
            setV3IsSet(true);
            return this;
        }

        public void unsetV3() {
            __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __V3_ISSET_ID);
        }

        /** Returns true if field v3 is set (has been assigned a value) and false otherwise */
        public boolean isSetV3() {
            return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __V3_ISSET_ID);
        }

        public void setV3IsSet(boolean value) {
            __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __V3_ISSET_ID, value);
        }

        public int getV4() {
            return this.v4;
        }

        public alltypes_args setV4(int v4) {
            this.v4 = v4;
            setV4IsSet(true);
            return this;
        }

        public void unsetV4() {
            __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __V4_ISSET_ID);
        }

        /** Returns true if field v4 is set (has been assigned a value) and false otherwise */
        public boolean isSetV4() {
            return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __V4_ISSET_ID);
        }

        public void setV4IsSet(boolean value) {
            __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __V4_ISSET_ID, value);
        }

        public long getV5() {
            return this.v5;
        }

        public alltypes_args setV5(long v5) {
            this.v5 = v5;
            setV5IsSet(true);
            return this;
        }

        public void unsetV5() {
            __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __V5_ISSET_ID);
        }

        /** Returns true if field v5 is set (has been assigned a value) and false otherwise */
        public boolean isSetV5() {
            return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __V5_ISSET_ID);
        }

        public void setV5IsSet(boolean value) {
            __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __V5_ISSET_ID, value);
        }

        public double getV6() {
            return this.v6;
        }

        public alltypes_args setV6(double v6) {
            this.v6 = v6;
            setV6IsSet(true);
            return this;
        }

        public void unsetV6() {
            __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __V6_ISSET_ID);
        }

        /** Returns true if field v6 is set (has been assigned a value) and false otherwise */
        public boolean isSetV6() {
            return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __V6_ISSET_ID);
        }

        public void setV6IsSet(boolean value) {
            __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __V6_ISSET_ID, value);
        }

        public java.lang.String getV7() {
            return this.v7;
        }

        public alltypes_args setV7(java.lang.String v7) {
            this.v7 = v7;
            return this;
        }

        public void unsetV7() {
            this.v7 = null;
        }

        /** Returns true if field v7 is set (has been assigned a value) and false otherwise */
        public boolean isSetV7() {
            return this.v7 != null;
        }

        public void setV7IsSet(boolean value) {
            if (!value) {
                this.v7 = null;
            }
        }

        public byte[] getV8() {
            setV8(org.apache.thrift.TBaseHelper.rightSize(v8));
            return v8 == null ? null : v8.array();
        }

        public java.nio.ByteBuffer bufferForV8() {
            return org.apache.thrift.TBaseHelper.copyBinary(v8);
        }

        public alltypes_args setV8(byte[] v8) {
            this.v8 = v8 == null ? (java.nio.ByteBuffer) null : java.nio.ByteBuffer.wrap(v8.clone());
            return this;
        }

        public alltypes_args setV8(java.nio.ByteBuffer v8) {
            this.v8 = org.apache.thrift.TBaseHelper.copyBinary(v8);
            return this;
        }

        public void unsetV8() {
            this.v8 = null;
        }

        /** Returns true if field v8 is set (has been assigned a value) and false otherwise */
        public boolean isSetV8() {
            return this.v8 != null;
        }

        public void setV8IsSet(boolean value) {
            if (!value) {
                this.v8 = null;
            }
        }

        public Work getV9() {
            return this.v9;
        }

        public alltypes_args setV9(Work v9) {
            this.v9 = v9;
            return this;
        }

        public void unsetV9() {
            this.v9 = null;
        }

        /** Returns true if field v9 is set (has been assigned a value) and false otherwise */
        public boolean isSetV9() {
            return this.v9 != null;
        }

        public void setV9IsSet(boolean value) {
            if (!value) {
                this.v9 = null;
            }
        }

        public int getV10Size() {
            return (this.v10 == null) ? 0 : this.v10.size();
        }

        public java.util.Iterator<java.lang.Integer> getV10Iterator() {
            return (this.v10 == null) ? null : this.v10.iterator();
        }

        public void addToV10(int elem) {
            if (this.v10 == null) {
                this.v10 = new java.util.ArrayList<>();
            }
            this.v10.add(elem);
        }

        public java.util.List<java.lang.Integer> getV10() {
            return this.v10;
        }

        public alltypes_args setV10(java.util.List<java.lang.Integer> v10) {
            this.v10 = v10;
            return this;
        }

        public void unsetV10() {
            this.v10 = null;
        }

        /** Returns true if field v10 is set (has been assigned a value) and false otherwise */
        public boolean isSetV10() {
            return this.v10 != null;
        }

        public void setV10IsSet(boolean value) {
            if (!value) {
                this.v10 = null;
            }
        }

        public int getV11Size() {
            return (this.v11 == null) ? 0 : this.v11.size();
        }

        public java.util.Iterator<java.lang.String> getV11Iterator() {
            return (this.v11 == null) ? null : this.v11.iterator();
        }

        public void addToV11(java.lang.String elem) {
            if (this.v11 == null) {
                this.v11 = new java.util.HashSet<>();
            }
            this.v11.add(elem);
        }

        public java.util.Set<java.lang.String> getV11() {
            return this.v11;
        }

        public alltypes_args setV11(java.util.Set<java.lang.String> v11) {
            this.v11 = v11;
            return this;
        }

        public void unsetV11() {
            this.v11 = null;
        }

        /** Returns true if field v11 is set (has been assigned a value) and false otherwise */
        public boolean isSetV11() {
            return this.v11 != null;
        }

        public void setV11IsSet(boolean value) {
            if (!value) {
                this.v11 = null;
            }
        }

        public int getV12Size() {
            return (this.v12 == null) ? 0 : this.v12.size();
        }

        public void putToV12(java.lang.String key, long val) {
            if (this.v12 == null) {
                this.v12 = new java.util.HashMap<>();
            }
            this.v12.put(key, val);
        }

        public java.util.Map<java.lang.String, java.lang.Long> getV12() {
            return this.v12;
        }

        public alltypes_args setV12(java.util.Map<java.lang.String, java.lang.Long> v12) {
            this.v12 = v12;
            return this;
        }

        public void unsetV12() {
            this.v12 = null;
        }

        /** Returns true if field v12 is set (has been assigned a value) and false otherwise */
        public boolean isSetV12() {
            return this.v12 != null;
        }

        public void setV12IsSet(boolean value) {
            if (!value) {
                this.v12 = null;
            }
        }

        public void setFieldValue(_Fields field, java.lang.Object value) {
            switch (field) {
                case V1:
                    if (value == null) {
                        unsetV1();
                    } else {
                        setV1((java.lang.Boolean) value);
                    }
                    break;

                case V2:
                    if (value == null) {
                        unsetV2();
                    } else {
                        setV2((java.lang.Byte) value);
                    }
                    break;

                case V3:
                    if (value == null) {
                        unsetV3();
                    } else {
                        setV3((java.lang.Short) value);
                    }
                    break;

                case V4:
                    if (value == null) {
                        unsetV4();
                    } else {
                        setV4((java.lang.Integer) value);
                    }
                    break;

                case V5:
                    if (value == null) {
                        unsetV5();
                    } else {
                        setV5((java.lang.Long) value);
                    }
                    break;

                case V6:
                    if (value == null) {
                        unsetV6();
                    } else {
                        setV6((java.lang.Double) value);
                    }
                    break;

                case V7:
                    if (value == null) {
                        unsetV7();
                    } else {
                        setV7((java.lang.String) value);
                    }
                    break;

                case V8:
                    if (value == null) {
                        unsetV8();
                    } else {
                        if (value instanceof byte[]) {
                            setV8((byte[]) value);
                        } else {
                            setV8((java.nio.ByteBuffer) value);
                        }
                    }
                    break;

                case V9:
                    if (value == null) {
                        unsetV9();
                    } else {
                        setV9((Work) value);
                    }
                    break;

                case V10:
                    if (value == null) {
                        unsetV10();
                    } else {
                        setV10((java.util.List<java.lang.Integer>) value);
                    }
                    break;

                case V11:
                    if (value == null) {
                        unsetV11();
                    } else {
                        setV11((java.util.Set<java.lang.String>) value);
                    }
                    break;

                case V12:
                    if (value == null) {
                        unsetV12();
                    } else {
                        setV12((java.util.Map<java.lang.String, java.lang.Long>) value);
                    }
                    break;

            }
        }

        public java.lang.Object getFieldValue(_Fields field) {
            switch (field) {
                case V1:
                    return isV1();

                case V2:
                    return getV2();

                case V3:
                    return getV3();

                case V4:
                    return getV4();

                case V5:
                    return getV5();

                case V6:
                    return getV6();

                case V7:
                    return getV7();

                case V8:
                    return getV8();

                case V9:
                    return getV9();

                case V10:
                    return getV10();

                case V11:
                    return getV11();

                case V12:
                    return getV12();

            }
            throw new java.lang.IllegalStateException();
        }

        /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new java.lang.IllegalArgumentException();
            }

            switch (field) {
                case V1:
                    return isSetV1();
                case V2:
                    return isSetV2();
                case V3:
                    return isSetV3();
                case V4:
                    return isSetV4();
                case V5:
                    return isSetV5();
                case V6:
                    return isSetV6();
                case V7:
                    return isSetV7();
                case V8:
                    return isSetV8();
                case V9:
                    return isSetV9();
                case V10:
                    return isSetV10();
                case V11:
                    return isSetV11();
                case V12:
                    return isSetV12();
            }
            throw new java.lang.IllegalStateException();
        }

        @Override
        public boolean equals(java.lang.Object that) {
            if (that == null)
                return false;
            if (that instanceof alltypes_args)
                return this.equals((alltypes_args) that);
            return false;
        }

        public boolean equals(alltypes_args that) {
            if (that == null)
                return false;
            if (this == that)
                return true;

            boolean this_present_v1 = true;
            boolean that_present_v1 = true;
            if (this_present_v1 || that_present_v1) {
                if (!(this_present_v1 && that_present_v1))
                    return false;
                if (this.v1 != that.v1)
                    return false;
            }

            boolean this_present_v2 = true;
            boolean that_present_v2 = true;
            if (this_present_v2 || that_present_v2) {
                if (!(this_present_v2 && that_present_v2))
                    return false;
                if (this.v2 != that.v2)
                    return false;
            }

            boolean this_present_v3 = true;
            boolean that_present_v3 = true;
            if (this_present_v3 || that_present_v3) {
                if (!(this_present_v3 && that_present_v3))
                    return false;
                if (this.v3 != that.v3)
                    return false;
            }

            boolean this_present_v4 = true;
            boolean that_present_v4 = true;
            if (this_present_v4 || that_present_v4) {
                if (!(this_present_v4 && that_present_v4))
                    return false;
                if (this.v4 != that.v4)
                    return false;
            }

            boolean this_present_v5 = true;
            boolean that_present_v5 = true;
            if (this_present_v5 || that_present_v5) {
                if (!(this_present_v5 && that_present_v5))
                    return false;
                if (this.v5 != that.v5)
                    return false;
            }

            boolean this_present_v6 = true;
            boolean that_present_v6 = true;
            if (this_present_v6 || that_present_v6) {
                if (!(this_present_v6 && that_present_v6))
                    return false;
                if (this.v6 != that.v6)
                    return false;
            }

            boolean this_present_v7 = true && this.isSetV7();
            boolean that_present_v7 = true && that.isSetV7();
            if (this_present_v7 || that_present_v7) {
                if (!(this_present_v7 && that_present_v7))
                    return false;
                if (!this.v7.equals(that.v7))
                    return false;
            }

            boolean this_present_v8 = true && this.isSetV8();
            boolean that_present_v8 = true && that.isSetV8();
            if (this_present_v8 || that_present_v8) {
                if (!(this_present_v8 && that_present_v8))
                    return false;
                if (!this.v8.equals(that.v8))
                    return false;
            }

            boolean this_present_v9 = true && this.isSetV9();
            boolean that_present_v9 = true && that.isSetV9();
            if (this_present_v9 || that_present_v9) {
                if (!(this_present_v9 && that_present_v9))
                    return false;
                if (!this.v9.equals(that.v9))
                    return false;
            }

            boolean this_present_v10 = true && this.isSetV10();
            boolean that_present_v10 = true && that.isSetV10();
            if (this_present_v10 || that_present_v10) {
                if (!(this_present_v10 && that_present_v10))
                    return false;
                if (!this.v10.equals(that.v10))
                    return false;
            }

            boolean this_present_v11 = true && this.isSetV11();
            boolean that_present_v11 = true && that.isSetV11();
            if (this_present_v11 || that_present_v11) {
                if (!(this_present_v11 && that_present_v11))
                    return false;
                if (!this.v11.equals(that.v11))
                    return false;
            }

            boolean this_present_v12 = true && this.isSetV12();
            boolean that_present_v12 = true && that.isSetV12();
            if (this_present_v12 || that_present_v12) {
                if (!(this_present_v12 && that_present_v12))
                    return false;
                if (!this.v12.equals(that.v12))
                    return false;
            }

            return true;
        }

        @Override
        public int hashCode() {
            int hashCode = 1;

            hashCode = hashCode * 8191 + ((v1) ? 131071 : 524287);

            hashCode = hashCode * 8191 + (v2);

            hashCode = hashCode * 8191 + v3;

            hashCode = hashCode * 8191 + v4;

            hashCode = hashCode * 8191 + org.apache.thrift.TBaseHelper.hashCode(v5);

            hashCode = hashCode * 8191 + org.apache.thrift.TBaseHelper.hashCode(v6);

            hashCode = hashCode * 8191 + ((isSetV7()) ? 131071 : 524287);
            if (isSetV7())
                hashCode = hashCode * 8191 + v7.hashCode();

            hashCode = hashCode * 8191 + ((isSetV8()) ? 131071 : 524287);
            if (isSetV8())
                hashCode = hashCode * 8191 + v8.hashCode();

            hashCode = hashCode * 8191 + ((isSetV9()) ? 131071 : 524287);
            if (isSetV9())
                hashCode = hashCode * 8191 + v9.hashCode();

            hashCode = hashCode * 8191 + ((isSetV10()) ? 131071 : 524287);
            if (isSetV10())
                hashCode = hashCode * 8191 + v10.hashCode();

            hashCode = hashCode * 8191 + ((isSetV11()) ? 131071 : 524287);
            if (isSetV11())
                hashCode = hashCode * 8191 + v11.hashCode();

            hashCode = hashCode * 8191 + ((isSetV12()) ? 131071 : 524287);
            if (isSetV12())
                hashCode = hashCode * 8191 + v12.hashCode();

            return hashCode;
        }

        @Override
        public int compareTo(alltypes_args other) {
            if (!getClass().equals(other.getClass())) {
                return getClass().getName().compareTo(other.getClass().getName());
            }

            int lastComparison = 0;

            lastComparison = java.lang.Boolean.valueOf(isSetV1()).compareTo(other.isSetV1());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (isSetV1()) {
                lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.v1, other.v1);
                if (lastComparison != 0) {
                    return lastComparison;
                }
            }
            lastComparison = java.lang.Boolean.valueOf(isSetV2()).compareTo(other.isSetV2());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (isSetV2()) {
                lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.v2, other.v2);
                if (lastComparison != 0) {
                    return lastComparison;
                }
            }
            lastComparison = java.lang.Boolean.valueOf(isSetV3()).compareTo(other.isSetV3());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (isSetV3()) {
                lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.v3, other.v3);
                if (lastComparison != 0) {
                    return lastComparison;
                }
            }
            lastComparison = java.lang.Boolean.valueOf(isSetV4()).compareTo(other.isSetV4());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (isSetV4()) {
                lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.v4, other.v4);
                if (lastComparison != 0) {
                    return lastComparison;
                }
            }
            lastComparison = java.lang.Boolean.valueOf(isSetV5()).compareTo(other.isSetV5());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (isSetV5()) {
                lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.v5, other.v5);
                if (lastComparison != 0) {
                    return lastComparison;
                }
            }
            lastComparison = java.lang.Boolean.valueOf(isSetV6()).compareTo(other.isSetV6());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (isSetV6()) {
                lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.v6, other.v6);
                if (lastComparison != 0) {
                    return lastComparison;
                }
            }
            lastComparison = java.lang.Boolean.valueOf(isSetV7()).compareTo(other.isSetV7());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (isSetV7()) {
                lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.v7, other.v7);
                if (lastComparison != 0) {
                    return lastComparison;
                }
            }
            lastComparison = java.lang.Boolean.valueOf(isSetV8()).compareTo(other.isSetV8());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (isSetV8()) {
                lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.v8, other.v8);
                if (lastComparison != 0) {
                    return lastComparison;
                }
            }
            lastComparison = java.lang.Boolean.valueOf(isSetV9()).compareTo(other.isSetV9());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (isSetV9()) {
                lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.v9, other.v9);
                if (lastComparison != 0) {
                    return lastComparison;
                }
            }
            lastComparison = java.lang.Boolean.valueOf(isSetV10()).compareTo(other.isSetV10());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (isSetV10()) {
                lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.v10, other.v10);
                if (lastComparison != 0) {
                    return lastComparison;
                }
            }
            lastComparison = java.lang.Boolean.valueOf(isSetV11()).compareTo(other.isSetV11());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (isSetV11()) {
                lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.v11, other.v11);
                if (lastComparison != 0) {
                    return lastComparison;
                }
            }
            lastComparison = java.lang.Boolean.valueOf(isSetV12()).compareTo(other.isSetV12());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (isSetV12()) {
                lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.v12, other.v12);
                if (lastComparison != 0) {
                    return lastComparison;
                }
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
            scheme(iprot).read(iprot, this);
        }

        public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
            scheme(oprot).write(oprot, this);
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder sb = new java.lang.StringBuilder("alltypes_args(");
            boolean first = true;

            sb.append("v1:");
            sb.append(this.v1);
            first = false;
            if (!first)
                sb.append(", ");
            sb.append("v2:");
            sb.append(this.v2);
            first = false;
            if (!first)
                sb.append(", ");
            sb.append("v3:");
            sb.append(this.v3);
            first = false;
            if (!first)
                sb.append(", ");
            sb.append("v4:");
            sb.append(this.v4);
            first = false;
            if (!first)
                sb.append(", ");
            sb.append("v5:");
            sb.append(this.v5);
            first = false;
            if (!first)
                sb.append(", ");
            sb.append("v6:");
            sb.append(this.v6);
            first = false;
            if (!first)
                sb.append(", ");
            sb.append("v7:");
            if (this.v7 == null) {
                sb.append("null");
            } else {
                sb.append(this.v7);
            }
            first = false;
            if (!first)
                sb.append(", ");
            sb.append("v8:");
            if (this.v8 == null) {
                sb.append("null");
            } else {
                org.apache.thrift.TBaseHelper.toString(this.v8, sb);
            }
            first = false;
            if (!first)
                sb.append(", ");
            sb.append("v9:");
            if (this.v9 == null) {
                sb.append("null");
            } else {
                sb.append(this.v9);
            }
            first = false;
            if (!first)
                sb.append(", ");
            sb.append("v10:");
            if (this.v10 == null) {
                sb.append("null");
            } else {
                sb.append(this.v10);
            }
            first = false;
            if (!first)
                sb.append(", ");
            sb.append("v11:");
            if (this.v11 == null) {
                sb.append("null");
            } else {
                sb.append(this.v11);
            }
            first = false;
            if (!first)
                sb.append(", ");
            sb.append("v12:");
            if (this.v12 == null) {
                sb.append("null");
            } else {
                sb.append(this.v12);
            }
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws org.apache.thrift.TException {
            // check for required fields
            // check for sub-struct validity
            if (v9 != null) {
                v9.validate();
            }
        }

        private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
            try {
                write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
            try {
                // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
                __isset_bitfield = 0;
                read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private static class alltypes_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
            public alltypes_argsStandardScheme getScheme() {
                return new alltypes_argsStandardScheme();
            }
        }

        private static class alltypes_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<alltypes_args> {

            public void read(org.apache.thrift.protocol.TProtocol iprot, alltypes_args struct)
                    throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TField schemeField;
                iprot.readStructBegin();
                while (true) {
                    schemeField = iprot.readFieldBegin();
                    if (schemeField.type == org.apache.thrift.protocol.TType.STOP) {
                        break;
                    }
                    switch (schemeField.id) {
                        case 1: // V1
                            if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                                struct.v1 = iprot.readBool();
                                struct.setV1IsSet(true);
                            } else {
                                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                            }
                            break;
                        case 2: // V2
                            if (schemeField.type == org.apache.thrift.protocol.TType.BYTE) {
                                struct.v2 = iprot.readByte();
                                struct.setV2IsSet(true);
                            } else {
                                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                            }
                            break;
                        case 3: // V3
                            if (schemeField.type == org.apache.thrift.protocol.TType.I16) {
                                struct.v3 = iprot.readI16();
                                struct.setV3IsSet(true);
                            } else {
                                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                            }
                            break;
                        case 4: // V4
                            if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                                struct.v4 = iprot.readI32();
                                struct.setV4IsSet(true);
                            } else {
                                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                            }
                            break;
                        case 5: // V5
                            if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                                struct.v5 = iprot.readI64();
                                struct.setV5IsSet(true);
                            } else {
                                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                            }
                            break;
                        case 6: // V6
                            if (schemeField.type == org.apache.thrift.protocol.TType.DOUBLE) {
                                struct.v6 = iprot.readDouble();
                                struct.setV6IsSet(true);
                            } else {
                                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                            }
                            break;
                        case 7: // V7
                            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                                struct.v7 = iprot.readString();
                                struct.setV7IsSet(true);
                            } else {
                                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                            }
                            break;
                        case 8: // V8
                            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                                struct.v8 = iprot.readBinary();
                                struct.setV8IsSet(true);
                            } else {
                                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                            }
                            break;
                        case 9: // V9
                            if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                                struct.v9 = new Work();
                                struct.v9.read(iprot);
                                struct.setV9IsSet(true);
                            } else {
                                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                            }
                            break;
                        case 10: // V10
                            if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                                {
                                    org.apache.thrift.protocol.TList _list0 = iprot.readListBegin();
                                    struct.v10 = new java.util.ArrayList<>(_list0.size);
                                    int _elem1;
                                    for (int _i2 = 0; _i2 < _list0.size; ++_i2) {
                                        _elem1 = iprot.readI32();
                                        struct.v10.add(_elem1);
                                    }
                                    iprot.readListEnd();
                                }
                                struct.setV10IsSet(true);
                            } else {
                                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                            }
                            break;
                        case 11: // V11
                            if (schemeField.type == org.apache.thrift.protocol.TType.SET) {
                                {
                                    org.apache.thrift.protocol.TSet _set3 = iprot.readSetBegin();
                                    struct.v11 = new java.util.HashSet<>(2 * _set3.size);
                                    java.lang.String _elem4;
                                    for (int _i5 = 0; _i5 < _set3.size; ++_i5) {
                                        _elem4 = iprot.readString();
                                        struct.v11.add(_elem4);
                                    }
                                    iprot.readSetEnd();
                                }
                                struct.setV11IsSet(true);
                            } else {
                                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                            }
                            break;
                        case 12: // V12
                            if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
                                {
                                    org.apache.thrift.protocol.TMap _map6 = iprot.readMapBegin();
                                    struct.v12 = new java.util.HashMap<>(2 * _map6.size);
                                    java.lang.String _key7;
                                    long _val8;
                                    for (int _i9 = 0; _i9 < _map6.size; ++_i9) {
                                        _key7 = iprot.readString();
                                        _val8 = iprot.readI64();
                                        struct.v12.put(_key7, _val8);
                                    }
                                    iprot.readMapEnd();
                                }
                                struct.setV12IsSet(true);
                            } else {
                                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                            }
                            break;
                        default:
                            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();

                // check for required fields of primitive type, which can't be checked in the validate method
                struct.validate();
            }

            public void write(org.apache.thrift.protocol.TProtocol oprot, alltypes_args struct)
                    throws org.apache.thrift.TException {
                struct.validate();

                oprot.writeStructBegin(STRUCT_DESC);
                oprot.writeFieldBegin(V1_FIELD_DESC);
                oprot.writeBool(struct.v1);
                oprot.writeFieldEnd();
                oprot.writeFieldBegin(V2_FIELD_DESC);
                oprot.writeByte(struct.v2);
                oprot.writeFieldEnd();
                oprot.writeFieldBegin(V3_FIELD_DESC);
                oprot.writeI16(struct.v3);
                oprot.writeFieldEnd();
                oprot.writeFieldBegin(V4_FIELD_DESC);
                oprot.writeI32(struct.v4);
                oprot.writeFieldEnd();
                oprot.writeFieldBegin(V5_FIELD_DESC);
                oprot.writeI64(struct.v5);
                oprot.writeFieldEnd();
                oprot.writeFieldBegin(V6_FIELD_DESC);
                oprot.writeDouble(struct.v6);
                oprot.writeFieldEnd();
                if (struct.v7 != null) {
                    oprot.writeFieldBegin(V7_FIELD_DESC);
                    oprot.writeString(struct.v7);
                    oprot.writeFieldEnd();
                }
                if (struct.v8 != null) {
                    oprot.writeFieldBegin(V8_FIELD_DESC);
                    oprot.writeBinary(struct.v8);
                    oprot.writeFieldEnd();
                }
                if (struct.v9 != null) {
                    oprot.writeFieldBegin(V9_FIELD_DESC);
                    struct.v9.write(oprot);
                    oprot.writeFieldEnd();
                }
                if (struct.v10 != null) {
                    oprot.writeFieldBegin(V10_FIELD_DESC);
                    {
                        oprot.writeListBegin(
                                new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.I32, struct.v10.size()));
                        for (int _iter10 : struct.v10) {
                            oprot.writeI32(_iter10);
                        }
                        oprot.writeListEnd();
                    }
                    oprot.writeFieldEnd();
                }
                if (struct.v11 != null) {
                    oprot.writeFieldBegin(V11_FIELD_DESC);
                    {
                        oprot.writeSetBegin(new org.apache.thrift.protocol.TSet(
                                org.apache.thrift.protocol.TType.STRING, struct.v11.size()));
                        for (java.lang.String _iter11 : struct.v11) {
                            oprot.writeString(_iter11);
                        }
                        oprot.writeSetEnd();
                    }
                    oprot.writeFieldEnd();
                }
                if (struct.v12 != null) {
                    oprot.writeFieldBegin(V12_FIELD_DESC);
                    {
                        oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(
                                org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.I64,
                                struct.v12.size()));
                        for (java.util.Map.Entry<java.lang.String, java.lang.Long> _iter12 : struct.v12.entrySet()) {
                            oprot.writeString(_iter12.getKey());
                            oprot.writeI64(_iter12.getValue());
                        }
                        oprot.writeMapEnd();
                    }
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }

        }

        private static class alltypes_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
            public alltypes_argsTupleScheme getScheme() {
                return new alltypes_argsTupleScheme();
            }
        }

        private static class alltypes_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<alltypes_args> {

            @Override
            public void write(org.apache.thrift.protocol.TProtocol prot, alltypes_args struct)
                    throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
                java.util.BitSet optionals = new java.util.BitSet();
                if (struct.isSetV1()) {
                    optionals.set(0);
                }
                if (struct.isSetV2()) {
                    optionals.set(1);
                }
                if (struct.isSetV3()) {
                    optionals.set(2);
                }
                if (struct.isSetV4()) {
                    optionals.set(3);
                }
                if (struct.isSetV5()) {
                    optionals.set(4);
                }
                if (struct.isSetV6()) {
                    optionals.set(5);
                }
                if (struct.isSetV7()) {
                    optionals.set(6);
                }
                if (struct.isSetV8()) {
                    optionals.set(7);
                }
                if (struct.isSetV9()) {
                    optionals.set(8);
                }
                if (struct.isSetV10()) {
                    optionals.set(9);
                }
                if (struct.isSetV11()) {
                    optionals.set(10);
                }
                if (struct.isSetV12()) {
                    optionals.set(11);
                }
                oprot.writeBitSet(optionals, 12);
                if (struct.isSetV1()) {
                    oprot.writeBool(struct.v1);
                }
                if (struct.isSetV2()) {
                    oprot.writeByte(struct.v2);
                }
                if (struct.isSetV3()) {
                    oprot.writeI16(struct.v3);
                }
                if (struct.isSetV4()) {
                    oprot.writeI32(struct.v4);
                }
                if (struct.isSetV5()) {
                    oprot.writeI64(struct.v5);
                }
                if (struct.isSetV6()) {
                    oprot.writeDouble(struct.v6);
                }
                if (struct.isSetV7()) {
                    oprot.writeString(struct.v7);
                }
                if (struct.isSetV8()) {
                    oprot.writeBinary(struct.v8);
                }
                if (struct.isSetV9()) {
                    struct.v9.write(oprot);
                }
                if (struct.isSetV10()) {
                    {
                        oprot.writeI32(struct.v10.size());
                        for (int _iter13 : struct.v10) {
                            oprot.writeI32(_iter13);
                        }
                    }
                }
                if (struct.isSetV11()) {
                    {
                        oprot.writeI32(struct.v11.size());
                        for (java.lang.String _iter14 : struct.v11) {
                            oprot.writeString(_iter14);
                        }
                    }
                }
                if (struct.isSetV12()) {
                    {
                        oprot.writeI32(struct.v12.size());
                        for (java.util.Map.Entry<java.lang.String, java.lang.Long> _iter15 : struct.v12.entrySet()) {
                            oprot.writeString(_iter15.getKey());
                            oprot.writeI64(_iter15.getValue());
                        }
                    }
                }
            }

            @Override
            public void read(org.apache.thrift.protocol.TProtocol prot, alltypes_args struct)
                    throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
                java.util.BitSet incoming = iprot.readBitSet(12);
                if (incoming.get(0)) {
                    struct.v1 = iprot.readBool();
                    struct.setV1IsSet(true);
                }
                if (incoming.get(1)) {
                    struct.v2 = iprot.readByte();
                    struct.setV2IsSet(true);
                }
                if (incoming.get(2)) {
                    struct.v3 = iprot.readI16();
                    struct.setV3IsSet(true);
                }
                if (incoming.get(3)) {
                    struct.v4 = iprot.readI32();
                    struct.setV4IsSet(true);
                }
                if (incoming.get(4)) {
                    struct.v5 = iprot.readI64();
                    struct.setV5IsSet(true);
                }
                if (incoming.get(5)) {
                    struct.v6 = iprot.readDouble();
                    struct.setV6IsSet(true);
                }
                if (incoming.get(6)) {
                    struct.v7 = iprot.readString();
                    struct.setV7IsSet(true);
                }
                if (incoming.get(7)) {
                    struct.v8 = iprot.readBinary();
                    struct.setV8IsSet(true);
                }
                if (incoming.get(8)) {
                    struct.v9 = new Work();
                    struct.v9.read(iprot);
                    struct.setV9IsSet(true);
                }
                if (incoming.get(9)) {
                    {
                        org.apache.thrift.protocol.TList _list16
                                = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.I32, iprot.readI32());
                        struct.v10 = new java.util.ArrayList<>(_list16.size);
                        int _elem17;
                        for (int _i18 = 0; _i18 < _list16.size; ++_i18) {
                            _elem17 = iprot.readI32();
                            struct.v10.add(_elem17);
                        }
                    }
                    struct.setV10IsSet(true);
                }
                if (incoming.get(10)) {
                    {
                        org.apache.thrift.protocol.TSet _set19
                                = new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
                        struct.v11 = new java.util.HashSet<>(2 * _set19.size);
                        java.lang.String _elem20;
                        for (int _i21 = 0; _i21 < _set19.size; ++_i21) {
                            _elem20 = iprot.readString();
                            struct.v11.add(_elem20);
                        }
                    }
                    struct.setV11IsSet(true);
                }
                if (incoming.get(11)) {
                    {
                        org.apache.thrift.protocol.TMap _map22 = new org.apache.thrift.protocol.TMap(
                                org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.I64, iprot.readI32());
                        struct.v12 = new java.util.HashMap<>(2 * _map22.size);
                        java.lang.String _key23;
                        long _val24;
                        for (int _i25 = 0; _i25 < _map22.size; ++_i25) {
                            _key23 = iprot.readString();
                            _val24 = iprot.readI64();
                            struct.v12.put(_key23, _val24);
                        }
                    }
                    struct.setV12IsSet(true);
                }
            }
        }

        private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
            return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme())
                    ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
        }
    }

    public static class alltypes_result
            implements org.apache.thrift.TBase<alltypes_result, alltypes_result._Fields>, java.io.Serializable, Cloneable,
            Comparable<alltypes_result> {
        private static final org.apache.thrift.protocol.TStruct STRUCT_DESC
                = new org.apache.thrift.protocol.TStruct("alltypes_result");

        private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC
                = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.I32, (short) 0);

        private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY
                = new alltypes_resultStandardSchemeFactory();
        private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY
                = new alltypes_resultTupleSchemeFactory();

        public int success; // required

        /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
        public enum _Fields implements org.apache.thrift.TFieldIdEnum {
            SUCCESS((short) 0, "success");

            private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<>();

            static {
                for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, or null if its not found.
             */
            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    case 0: // SUCCESS
                        return SUCCESS;
                    default:
                        return null;
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, throwing an exception if it is not found.
             */
            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = findByThriftId(fieldId);
                if (fields == null)
                    throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                return fields;
            }

            /**
             * Find the _Fields constant that matches name, or null if its not found.
             */
            public static _Fields findByName(java.lang.String name) {
                return byName.get(name);
            }

            private final short _thriftId;
            private final java.lang.String _fieldName;

            _Fields(short thriftId, java.lang.String fieldName) {
                _thriftId = thriftId;
                _fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return _thriftId;
            }

            public java.lang.String getFieldName() {
                return _fieldName;
            }
        }

        // isset id assignments
        private static final int __SUCCESS_ISSET_ID = 0;
        private byte __isset_bitfield = 0;
        public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
        static {
            java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<>(_Fields.class);
            tmpMap.put(_Fields.SUCCESS,
                    new org.apache.thrift.meta_data.FieldMetaData(
                            "success", org.apache.thrift.TFieldRequirementType.DEFAULT,
                            new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
            metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
            org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(alltypes_result.class, metaDataMap);
        }

        public alltypes_result() {
        }

        public alltypes_result(
                               int success) {
            this();
            this.success = success;
            setSuccessIsSet(true);
        }

        /**
         * Performs a deep copy on <i>other</i>.
         */
        public alltypes_result(alltypes_result other) {
            __isset_bitfield = other.__isset_bitfield;
            this.success = other.success;
        }

        public alltypes_result deepCopy() {
            return new alltypes_result(this);
        }

        @Override
        public void clear() {
            setSuccessIsSet(false);
            this.success = 0;
        }

        public int getSuccess() {
            return this.success;
        }

        public alltypes_result setSuccess(int success) {
            this.success = success;
            setSuccessIsSet(true);
            return this;
        }

        public void unsetSuccess() {
            __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
        }

        /** Returns true if field success is set (has been assigned a value) and false otherwise */
        public boolean isSetSuccess() {
            return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
        }

        public void setSuccessIsSet(boolean value) {
            __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
        }

        public void setFieldValue(_Fields field, java.lang.Object value) {
            switch (field) {
                case SUCCESS:
                    if (value == null) {
                        unsetSuccess();
                    } else {
                        setSuccess((java.lang.Integer) value);
                    }
                    break;

            }
        }

        public java.lang.Object getFieldValue(_Fields field) {
            switch (field) {
                case SUCCESS:
                    return getSuccess();

            }
            throw new java.lang.IllegalStateException();
        }

        /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new java.lang.IllegalArgumentException();
            }

            switch (field) {
                case SUCCESS:
                    return isSetSuccess();
            }
            throw new java.lang.IllegalStateException();
        }

        @Override
        public boolean equals(java.lang.Object that) {
            if (that == null)
                return false;
            if (that instanceof alltypes_result)
                return this.equals((alltypes_result) that);
            return false;
        }

        public boolean equals(alltypes_result that) {
            if (that == null)
                return false;
            if (this == that)
                return true;

            boolean this_present_success = true;
            boolean that_present_success = true;
            if (this_present_success || that_present_success) {
                if (!(this_present_success && that_present_success))
                    return false;
                if (this.success != that.success)
                    return false;
            }

            return true;
        }

        @Override
        public int hashCode() {
            int hashCode = 1;

            hashCode = hashCode * 8191 + success;

            return hashCode;
        }

        @Override
        public int compareTo(alltypes_result other) {
            if (!getClass().equals(other.getClass())) {
                return getClass().getName().compareTo(other.getClass().getName());
            }

            int lastComparison = 0;

            lastComparison = java.lang.Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (isSetSuccess()) {
                lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
                if (lastComparison != 0) {
                    return lastComparison;
                }
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
            scheme(iprot).read(iprot, this);
        }

        public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
            scheme(oprot).write(oprot, this);
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder sb = new java.lang.StringBuilder("alltypes_result(");
            boolean first = true;

            sb.append("success:");
            sb.append(this.success);
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws org.apache.thrift.TException {
            // check for required fields
            // check for sub-struct validity
        }

        private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
            try {
                write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
            try {
                // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
                __isset_bitfield = 0;
                read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private static class alltypes_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
            public alltypes_resultStandardScheme getScheme() {
                return new alltypes_resultStandardScheme();
            }
        }

        private static class alltypes_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<alltypes_result> {

            public void read(org.apache.thrift.protocol.TProtocol iprot, alltypes_result struct)
                    throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TField schemeField;
                iprot.readStructBegin();
                while (true) {
                    schemeField = iprot.readFieldBegin();
                    if (schemeField.type == org.apache.thrift.protocol.TType.STOP) {
                        break;
                    }
                    switch (schemeField.id) {
                        case 0: // SUCCESS
                            if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                                struct.success = iprot.readI32();
                                struct.setSuccessIsSet(true);
                            } else {
                                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                            }
                            break;
                        default:
                            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();

                // check for required fields of primitive type, which can't be checked in the validate method
                struct.validate();
            }

            public void write(org.apache.thrift.protocol.TProtocol oprot, alltypes_result struct)
                    throws org.apache.thrift.TException {
                struct.validate();

                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.isSetSuccess()) {
                    oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                    oprot.writeI32(struct.success);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }

        }

        private static class alltypes_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
            public alltypes_resultTupleScheme getScheme() {
                return new alltypes_resultTupleScheme();
            }
        }

        private static class alltypes_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<alltypes_result> {

            @Override
            public void write(org.apache.thrift.protocol.TProtocol prot, alltypes_result struct)
                    throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
                java.util.BitSet optionals = new java.util.BitSet();
                if (struct.isSetSuccess()) {
                    optionals.set(0);
                }
                oprot.writeBitSet(optionals, 1);
                if (struct.isSetSuccess()) {
                    oprot.writeI32(struct.success);
                }
            }

            @Override
            public void read(org.apache.thrift.protocol.TProtocol prot, alltypes_result struct)
                    throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
                java.util.BitSet incoming = iprot.readBitSet(1);
                if (incoming.get(0)) {
                    struct.success = iprot.readI32();
                    struct.setSuccessIsSet(true);
                }
            }
        }

        private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
            return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme())
                    ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
        }
    }

}
