/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.function.BiFunction;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * Read and write from/to Infinispan distributed key/value store and data grid.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface InfinispanEmbeddedEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Infinispan Embedded component.
     */
    public interface InfinispanEmbeddedEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedInfinispanEmbeddedEndpointConsumerBuilder advanced() {
            return (AdvancedInfinispanEmbeddedEndpointConsumerBuilder) this;
        }
        /**
         * Specifies the query builder.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.infinispan.InfinispanQueryBuilder&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param queryBuilder the value to set
         * @return the dsl builder
         */
        default InfinispanEmbeddedEndpointConsumerBuilder queryBuilder(
                Object queryBuilder) {
            doSetProperty("queryBuilder", queryBuilder);
            return this;
        }
        /**
         * Specifies the query builder.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.infinispan.InfinispanQueryBuilder&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param queryBuilder the value to set
         * @return the dsl builder
         */
        default InfinispanEmbeddedEndpointConsumerBuilder queryBuilder(
                String queryBuilder) {
            doSetProperty("queryBuilder", queryBuilder);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default InfinispanEmbeddedEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default InfinispanEmbeddedEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * If true, the listener will be installed for the entire cluster.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param clusteredListener the value to set
         * @return the dsl builder
         */
        default InfinispanEmbeddedEndpointConsumerBuilder clusteredListener(
                boolean clusteredListener) {
            doSetProperty("clusteredListener", clusteredListener);
            return this;
        }
        /**
         * If true, the listener will be installed for the entire cluster.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param clusteredListener the value to set
         * @return the dsl builder
         */
        default InfinispanEmbeddedEndpointConsumerBuilder clusteredListener(
                String clusteredListener) {
            doSetProperty("clusteredListener", clusteredListener);
            return this;
        }
        /**
         * Returns the custom listener in use, if provided.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.infinispan.embedded.InfinispanEmbeddedCustomListener&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param customListener the value to set
         * @return the dsl builder
         */
        default InfinispanEmbeddedEndpointConsumerBuilder customListener(
                Object customListener) {
            doSetProperty("customListener", customListener);
            return this;
        }
        /**
         * Returns the custom listener in use, if provided.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.infinispan.embedded.InfinispanEmbeddedCustomListener&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param customListener the value to set
         * @return the dsl builder
         */
        default InfinispanEmbeddedEndpointConsumerBuilder customListener(
                String customListener) {
            doSetProperty("customListener", customListener);
            return this;
        }
        /**
         * Specifies the set of event types to register by the consumer.Multiple
         * event can be separated by comma. The possible event types are:
         * CACHE_ENTRY_ACTIVATED, CACHE_ENTRY_PASSIVATED, CACHE_ENTRY_VISITED,
         * CACHE_ENTRY_LOADED, CACHE_ENTRY_EVICTED, CACHE_ENTRY_CREATED,
         * CACHE_ENTRY_REMOVED, CACHE_ENTRY_MODIFIED, TRANSACTION_COMPLETED,
         * TRANSACTION_REGISTERED, CACHE_ENTRY_INVALIDATED, CACHE_ENTRY_EXPIRED,
         * DATA_REHASHED, TOPOLOGY_CHANGED, PARTITION_STATUS_CHANGED,
         * PERSISTENCE_AVAILABILITY_CHANGED.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param eventTypes the value to set
         * @return the dsl builder
         */
        default InfinispanEmbeddedEndpointConsumerBuilder eventTypes(
                String eventTypes) {
            doSetProperty("eventTypes", eventTypes);
            return this;
        }
        /**
         * If true, the consumer will receive notifications synchronously.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param sync the value to set
         * @return the dsl builder
         */
        default InfinispanEmbeddedEndpointConsumerBuilder sync(boolean sync) {
            doSetProperty("sync", sync);
            return this;
        }
        /**
         * If true, the consumer will receive notifications synchronously.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param sync the value to set
         * @return the dsl builder
         */
        default InfinispanEmbeddedEndpointConsumerBuilder sync(String sync) {
            doSetProperty("sync", sync);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Infinispan Embedded
     * component.
     */
    public interface AdvancedInfinispanEmbeddedEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default InfinispanEmbeddedEndpointConsumerBuilder basic() {
            return (InfinispanEmbeddedEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanEmbeddedEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanEmbeddedEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanEmbeddedEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanEmbeddedEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Specifies the cache Container to connect.
         * 
         * The option is a:
         * &lt;code&gt;org.infinispan.manager.EmbeddedCacheManager&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param cacheContainer the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanEmbeddedEndpointConsumerBuilder cacheContainer(
                Object cacheContainer) {
            doSetProperty("cacheContainer", cacheContainer);
            return this;
        }
        /**
         * Specifies the cache Container to connect.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.infinispan.manager.EmbeddedCacheManager&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param cacheContainer the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanEmbeddedEndpointConsumerBuilder cacheContainer(
                String cacheContainer) {
            doSetProperty("cacheContainer", cacheContainer);
            return this;
        }
        /**
         * The CacheContainer configuration. Used if the cacheContainer is not
         * defined.
         * 
         * The option is a:
         * &lt;code&gt;org.infinispan.configuration.cache.Configuration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param cacheContainerConfiguration the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanEmbeddedEndpointConsumerBuilder cacheContainerConfiguration(
                Object cacheContainerConfiguration) {
            doSetProperty("cacheContainerConfiguration", cacheContainerConfiguration);
            return this;
        }
        /**
         * The CacheContainer configuration. Used if the cacheContainer is not
         * defined.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.infinispan.configuration.cache.Configuration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param cacheContainerConfiguration the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanEmbeddedEndpointConsumerBuilder cacheContainerConfiguration(
                String cacheContainerConfiguration) {
            doSetProperty("cacheContainerConfiguration", cacheContainerConfiguration);
            return this;
        }
        /**
         * An implementation specific URI for the CacheManager.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configurationUri the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanEmbeddedEndpointConsumerBuilder configurationUri(
                String configurationUri) {
            doSetProperty("configurationUri", configurationUri);
            return this;
        }
        /**
         * A comma separated list of org.infinispan.context.Flag to be applied
         * by default on each cache invocation.
         * 
         * The option is a:
         * &lt;code&gt;org.infinispan.context.Flag[]&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param flags the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanEmbeddedEndpointConsumerBuilder flags(
                Flag[] flags) {
            doSetProperty("flags", flags);
            return this;
        }
        /**
         * A comma separated list of org.infinispan.context.Flag to be applied
         * by default on each cache invocation.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.infinispan.context.Flag[]&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param flags the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanEmbeddedEndpointConsumerBuilder flags(
                String flags) {
            doSetProperty("flags", flags);
            return this;
        }
        /**
         * Set a specific remappingFunction to use in a compute operation.
         * 
         * The option is a:
         * &lt;code&gt;java.util.function.BiFunction&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param remappingFunction the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanEmbeddedEndpointConsumerBuilder remappingFunction(
                BiFunction remappingFunction) {
            doSetProperty("remappingFunction", remappingFunction);
            return this;
        }
        /**
         * Set a specific remappingFunction to use in a compute operation.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.function.BiFunction&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param remappingFunction the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanEmbeddedEndpointConsumerBuilder remappingFunction(
                String remappingFunction) {
            doSetProperty("remappingFunction", remappingFunction);
            return this;
        }
        /**
         * Store the operation result in a header instead of the message body.
         * By default, resultHeader == null and the query result is stored in
         * the message body, any existing content in the message body is
         * discarded. If resultHeader is set, the value is used as the name of
         * the header to store the query result and the original message body is
         * preserved. This value can be overridden by an in message header
         * named: CamelInfinispanOperationResultHeader.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param resultHeader the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanEmbeddedEndpointConsumerBuilder resultHeader(
                String resultHeader) {
            doSetProperty("resultHeader", resultHeader);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Infinispan Embedded component.
     */
    public interface InfinispanEmbeddedEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedInfinispanEmbeddedEndpointProducerBuilder advanced() {
            return (AdvancedInfinispanEmbeddedEndpointProducerBuilder) this;
        }
        /**
         * Specifies the query builder.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.infinispan.InfinispanQueryBuilder&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param queryBuilder the value to set
         * @return the dsl builder
         */
        default InfinispanEmbeddedEndpointProducerBuilder queryBuilder(
                Object queryBuilder) {
            doSetProperty("queryBuilder", queryBuilder);
            return this;
        }
        /**
         * Specifies the query builder.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.infinispan.InfinispanQueryBuilder&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param queryBuilder the value to set
         * @return the dsl builder
         */
        default InfinispanEmbeddedEndpointProducerBuilder queryBuilder(
                String queryBuilder) {
            doSetProperty("queryBuilder", queryBuilder);
            return this;
        }
        /**
         * Set a specific default value for some producer operations.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param defaultValue the value to set
         * @return the dsl builder
         */
        default InfinispanEmbeddedEndpointProducerBuilder defaultValue(
                Object defaultValue) {
            doSetProperty("defaultValue", defaultValue);
            return this;
        }
        /**
         * Set a specific default value for some producer operations.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param defaultValue the value to set
         * @return the dsl builder
         */
        default InfinispanEmbeddedEndpointProducerBuilder defaultValue(
                String defaultValue) {
            doSetProperty("defaultValue", defaultValue);
            return this;
        }
        /**
         * Set a specific key for producer operations.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param key the value to set
         * @return the dsl builder
         */
        default InfinispanEmbeddedEndpointProducerBuilder key(Object key) {
            doSetProperty("key", key);
            return this;
        }
        /**
         * Set a specific key for producer operations.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param key the value to set
         * @return the dsl builder
         */
        default InfinispanEmbeddedEndpointProducerBuilder key(String key) {
            doSetProperty("key", key);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default InfinispanEmbeddedEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default InfinispanEmbeddedEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Set a specific old value for some producer operations.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param oldValue the value to set
         * @return the dsl builder
         */
        default InfinispanEmbeddedEndpointProducerBuilder oldValue(
                Object oldValue) {
            doSetProperty("oldValue", oldValue);
            return this;
        }
        /**
         * Set a specific old value for some producer operations.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param oldValue the value to set
         * @return the dsl builder
         */
        default InfinispanEmbeddedEndpointProducerBuilder oldValue(
                String oldValue) {
            doSetProperty("oldValue", oldValue);
            return this;
        }
        /**
         * The operation to perform.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.infinispan.InfinispanOperation&lt;/code&gt; type.
         * 
         * Default: PUT
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default InfinispanEmbeddedEndpointProducerBuilder operation(
                InfinispanOperation operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The operation to perform.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.infinispan.InfinispanOperation&lt;/code&gt; type.
         * 
         * Default: PUT
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default InfinispanEmbeddedEndpointProducerBuilder operation(
                String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Set a specific value for producer operations.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param value the value to set
         * @return the dsl builder
         */
        default InfinispanEmbeddedEndpointProducerBuilder value(Object value) {
            doSetProperty("value", value);
            return this;
        }
        /**
         * Set a specific value for producer operations.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param value the value to set
         * @return the dsl builder
         */
        default InfinispanEmbeddedEndpointProducerBuilder value(String value) {
            doSetProperty("value", value);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Infinispan Embedded
     * component.
     */
    public interface AdvancedInfinispanEmbeddedEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default InfinispanEmbeddedEndpointProducerBuilder basic() {
            return (InfinispanEmbeddedEndpointProducerBuilder) this;
        }
        /**
         * Specifies the cache Container to connect.
         * 
         * The option is a:
         * &lt;code&gt;org.infinispan.manager.EmbeddedCacheManager&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param cacheContainer the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanEmbeddedEndpointProducerBuilder cacheContainer(
                Object cacheContainer) {
            doSetProperty("cacheContainer", cacheContainer);
            return this;
        }
        /**
         * Specifies the cache Container to connect.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.infinispan.manager.EmbeddedCacheManager&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param cacheContainer the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanEmbeddedEndpointProducerBuilder cacheContainer(
                String cacheContainer) {
            doSetProperty("cacheContainer", cacheContainer);
            return this;
        }
        /**
         * The CacheContainer configuration. Used if the cacheContainer is not
         * defined.
         * 
         * The option is a:
         * &lt;code&gt;org.infinispan.configuration.cache.Configuration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param cacheContainerConfiguration the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanEmbeddedEndpointProducerBuilder cacheContainerConfiguration(
                Object cacheContainerConfiguration) {
            doSetProperty("cacheContainerConfiguration", cacheContainerConfiguration);
            return this;
        }
        /**
         * The CacheContainer configuration. Used if the cacheContainer is not
         * defined.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.infinispan.configuration.cache.Configuration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param cacheContainerConfiguration the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanEmbeddedEndpointProducerBuilder cacheContainerConfiguration(
                String cacheContainerConfiguration) {
            doSetProperty("cacheContainerConfiguration", cacheContainerConfiguration);
            return this;
        }
        /**
         * An implementation specific URI for the CacheManager.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configurationUri the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanEmbeddedEndpointProducerBuilder configurationUri(
                String configurationUri) {
            doSetProperty("configurationUri", configurationUri);
            return this;
        }
        /**
         * A comma separated list of org.infinispan.context.Flag to be applied
         * by default on each cache invocation.
         * 
         * The option is a:
         * &lt;code&gt;org.infinispan.context.Flag[]&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param flags the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanEmbeddedEndpointProducerBuilder flags(
                Flag[] flags) {
            doSetProperty("flags", flags);
            return this;
        }
        /**
         * A comma separated list of org.infinispan.context.Flag to be applied
         * by default on each cache invocation.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.infinispan.context.Flag[]&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param flags the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanEmbeddedEndpointProducerBuilder flags(
                String flags) {
            doSetProperty("flags", flags);
            return this;
        }
        /**
         * Set a specific remappingFunction to use in a compute operation.
         * 
         * The option is a:
         * &lt;code&gt;java.util.function.BiFunction&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param remappingFunction the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanEmbeddedEndpointProducerBuilder remappingFunction(
                BiFunction remappingFunction) {
            doSetProperty("remappingFunction", remappingFunction);
            return this;
        }
        /**
         * Set a specific remappingFunction to use in a compute operation.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.function.BiFunction&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param remappingFunction the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanEmbeddedEndpointProducerBuilder remappingFunction(
                String remappingFunction) {
            doSetProperty("remappingFunction", remappingFunction);
            return this;
        }
        /**
         * Store the operation result in a header instead of the message body.
         * By default, resultHeader == null and the query result is stored in
         * the message body, any existing content in the message body is
         * discarded. If resultHeader is set, the value is used as the name of
         * the header to store the query result and the original message body is
         * preserved. This value can be overridden by an in message header
         * named: CamelInfinispanOperationResultHeader.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param resultHeader the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanEmbeddedEndpointProducerBuilder resultHeader(
                String resultHeader) {
            doSetProperty("resultHeader", resultHeader);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Infinispan Embedded component.
     */
    public interface InfinispanEmbeddedEndpointBuilder
            extends
                InfinispanEmbeddedEndpointConsumerBuilder,
                InfinispanEmbeddedEndpointProducerBuilder {
        default AdvancedInfinispanEmbeddedEndpointBuilder advanced() {
            return (AdvancedInfinispanEmbeddedEndpointBuilder) this;
        }
        /**
         * Specifies the query builder.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.infinispan.InfinispanQueryBuilder&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param queryBuilder the value to set
         * @return the dsl builder
         */
        default InfinispanEmbeddedEndpointBuilder queryBuilder(
                Object queryBuilder) {
            doSetProperty("queryBuilder", queryBuilder);
            return this;
        }
        /**
         * Specifies the query builder.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.infinispan.InfinispanQueryBuilder&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param queryBuilder the value to set
         * @return the dsl builder
         */
        default InfinispanEmbeddedEndpointBuilder queryBuilder(
                String queryBuilder) {
            doSetProperty("queryBuilder", queryBuilder);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Infinispan Embedded component.
     */
    public interface AdvancedInfinispanEmbeddedEndpointBuilder
            extends
                AdvancedInfinispanEmbeddedEndpointConsumerBuilder,
                AdvancedInfinispanEmbeddedEndpointProducerBuilder {
        default InfinispanEmbeddedEndpointBuilder basic() {
            return (InfinispanEmbeddedEndpointBuilder) this;
        }
        /**
         * Specifies the cache Container to connect.
         * 
         * The option is a:
         * &lt;code&gt;org.infinispan.manager.EmbeddedCacheManager&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param cacheContainer the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanEmbeddedEndpointBuilder cacheContainer(
                Object cacheContainer) {
            doSetProperty("cacheContainer", cacheContainer);
            return this;
        }
        /**
         * Specifies the cache Container to connect.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.infinispan.manager.EmbeddedCacheManager&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param cacheContainer the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanEmbeddedEndpointBuilder cacheContainer(
                String cacheContainer) {
            doSetProperty("cacheContainer", cacheContainer);
            return this;
        }
        /**
         * The CacheContainer configuration. Used if the cacheContainer is not
         * defined.
         * 
         * The option is a:
         * &lt;code&gt;org.infinispan.configuration.cache.Configuration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param cacheContainerConfiguration the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanEmbeddedEndpointBuilder cacheContainerConfiguration(
                Object cacheContainerConfiguration) {
            doSetProperty("cacheContainerConfiguration", cacheContainerConfiguration);
            return this;
        }
        /**
         * The CacheContainer configuration. Used if the cacheContainer is not
         * defined.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.infinispan.configuration.cache.Configuration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param cacheContainerConfiguration the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanEmbeddedEndpointBuilder cacheContainerConfiguration(
                String cacheContainerConfiguration) {
            doSetProperty("cacheContainerConfiguration", cacheContainerConfiguration);
            return this;
        }
        /**
         * An implementation specific URI for the CacheManager.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configurationUri the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanEmbeddedEndpointBuilder configurationUri(
                String configurationUri) {
            doSetProperty("configurationUri", configurationUri);
            return this;
        }
        /**
         * A comma separated list of org.infinispan.context.Flag to be applied
         * by default on each cache invocation.
         * 
         * The option is a:
         * &lt;code&gt;org.infinispan.context.Flag[]&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param flags the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanEmbeddedEndpointBuilder flags(Flag[] flags) {
            doSetProperty("flags", flags);
            return this;
        }
        /**
         * A comma separated list of org.infinispan.context.Flag to be applied
         * by default on each cache invocation.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.infinispan.context.Flag[]&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param flags the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanEmbeddedEndpointBuilder flags(String flags) {
            doSetProperty("flags", flags);
            return this;
        }
        /**
         * Set a specific remappingFunction to use in a compute operation.
         * 
         * The option is a:
         * &lt;code&gt;java.util.function.BiFunction&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param remappingFunction the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanEmbeddedEndpointBuilder remappingFunction(
                BiFunction remappingFunction) {
            doSetProperty("remappingFunction", remappingFunction);
            return this;
        }
        /**
         * Set a specific remappingFunction to use in a compute operation.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.function.BiFunction&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param remappingFunction the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanEmbeddedEndpointBuilder remappingFunction(
                String remappingFunction) {
            doSetProperty("remappingFunction", remappingFunction);
            return this;
        }
        /**
         * Store the operation result in a header instead of the message body.
         * By default, resultHeader == null and the query result is stored in
         * the message body, any existing content in the message body is
         * discarded. If resultHeader is set, the value is used as the name of
         * the header to store the query result and the original message body is
         * preserved. This value can be overridden by an in message header
         * named: CamelInfinispanOperationResultHeader.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param resultHeader the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanEmbeddedEndpointBuilder resultHeader(
                String resultHeader) {
            doSetProperty("resultHeader", resultHeader);
            return this;
        }
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.infinispan.InfinispanOperation</code>
     * enum.
     */
    enum InfinispanOperation {
        PUT,
        PUTASYNC,
        PUTALL,
        PUTALLASYNC,
        PUTIFABSENT,
        PUTIFABSENTASYNC,
        GET,
        GETORDEFAULT,
        CONTAINSKEY,
        CONTAINSVALUE,
        REMOVE,
        REMOVEASYNC,
        REPLACE,
        REPLACEASYNC,
        SIZE,
        CLEAR,
        CLEARASYNC,
        QUERY,
        STATS,
        COMPUTE,
        COMPUTEASYNC;
    }

    /**
     * Proxy enum for <code>org.infinispan.context.Flag</code> enum.
     */
    enum Flag {
        ZERO_LOCK_ACQUISITION_TIMEOUT,
        CACHE_MODE_LOCAL,
        SKIP_LOCKING,
        FORCE_WRITE_LOCK,
        FORCE_ASYNCHRONOUS,
        FORCE_SYNCHRONOUS,
        SKIP_CACHE_STORE,
        SKIP_CACHE_LOAD,
        FAIL_SILENTLY,
        SKIP_REMOTE_LOOKUP,
        SKIP_INDEXING,
        PUT_FOR_EXTERNAL_READ,
        PUT_FOR_STATE_TRANSFER,
        PUT_FOR_X_SITE_STATE_TRANSFER,
        SKIP_SHARED_CACHE_STORE,
        SKIP_OWNERSHIP_CHECK,
        IGNORE_RETURN_VALUES,
        SKIP_XSITE_BACKUP,
        SKIP_LISTENER_NOTIFICATION,
        SKIP_STATISTICS,
        OPERATION_HOTROD,
        OPERATION_MEMCACHED,
        SKIP_INDEX_CLEANUP,
        COMMAND_RETRY,
        ROLLING_UPGRADE,
        REMOTE_ITERATION,
        SKIP_SIZE_OPTIMIZATION,
        IGNORE_TRANSACTION,
        IRAC_UPDATE,
        IRAC_STATE,
        ALREADY_HAS_LOCK,
        BACKUP_WRITE;
    }

    public interface InfinispanEmbeddedBuilders {
        /**
         * Infinispan Embedded (camel-infinispan-embedded)
         * Read and write from/to Infinispan distributed key/value store and
         * data grid.
         * 
         * Category: cache,datagrid,clustering
         * Since: 2.13
         * Maven coordinates: org.apache.camel:camel-infinispan-embedded
         * 
         * Syntax: <code>infinispan-embedded:cacheName</code>
         * 
         * Path parameter: cacheName (required)
         * The name of the cache to use. Use current to use the existing cache
         * name from the currently configured cached manager. Or use default for
         * the default cache manager name.
         * 
         * @param path cacheName
         * @return the dsl builder
         */
        default InfinispanEmbeddedEndpointBuilder infinispanEmbedded(String path) {
            return InfinispanEmbeddedEndpointBuilderFactory.endpointBuilder("infinispan-embedded", path);
        }
        /**
         * Infinispan Embedded (camel-infinispan-embedded)
         * Read and write from/to Infinispan distributed key/value store and
         * data grid.
         * 
         * Category: cache,datagrid,clustering
         * Since: 2.13
         * Maven coordinates: org.apache.camel:camel-infinispan-embedded
         * 
         * Syntax: <code>infinispan-embedded:cacheName</code>
         * 
         * Path parameter: cacheName (required)
         * The name of the cache to use. Use current to use the existing cache
         * name from the currently configured cached manager. Or use default for
         * the default cache manager name.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path cacheName
         * @return the dsl builder
         */
        default InfinispanEmbeddedEndpointBuilder infinispanEmbedded(
                String componentName,
                String path) {
            return InfinispanEmbeddedEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static InfinispanEmbeddedEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class InfinispanEmbeddedEndpointBuilderImpl extends AbstractEndpointBuilder implements InfinispanEmbeddedEndpointBuilder, AdvancedInfinispanEmbeddedEndpointBuilder {
            public InfinispanEmbeddedEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new InfinispanEmbeddedEndpointBuilderImpl(path);
    }
}