/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decorator;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.decorator.MetaDecorator;
import org.jboss.windup.hint.ResultProcessor;
import org.jboss.windup.metadata.decoration.AbstractDecoration;
import org.jboss.windup.metadata.decoration.Line;
import org.jboss.windup.metadata.type.JspMetadata;
import org.jboss.windup.util.NewLineUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JspDecorator
implements MetaDecorator<JspMetadata> {
    private static final Logger LOG = LoggerFactory.getLogger(JspDecorator.class);
    protected List<ResultProcessor> hints = new LinkedList<ResultProcessor>();
    protected Set<Pattern> classBlacklistPatterns;
    protected Set<Pattern> namespaceBlacklistPatterns;
    protected static final Pattern jspImport = Pattern.compile("<%@\\s*page\\s+[^>]*\\s*import\\s*=\\s*['\"]([^'\"]+)['\"].*?%>", 34);
    protected static final Pattern jspTagLib = Pattern.compile("<%@\\s*taglib\\s+[^>]*\\s*uri\\s*=\\s*['\"]([^'\"]+)['\"].*?%>", 34);
    protected static final Pattern jsp2DeprecatedQuotes = Pattern.compile("([\\w\\-0-9]+\\s*?=\\s*?\"\\s*?<%=[\\s\\w\\.\\(]*?[^\\\\]?\"[^%>]+?[^\\\\]\"[\\w\\s\\.\\)]*?%>\\s*?\")(?=.*?>)", 2);

    public void setHints(List<ResultProcessor> hints) {
        this.hints = hints;
    }

    @Override
    public void processMeta(JspMetadata meta) {
        try {
            String jspContents = FileUtils.readFileToString((File)meta.getFilePointer());
            this.findImports(jspContents, jspImport, meta);
            this.findTaglib(jspContents, jspTagLib, meta);
        }
        catch (IOException e) {
            LOG.error("Exception with Regular Expressions.", (Throwable)e);
        }
    }

    protected void findDeprecatedJspQuotes(String html, Pattern thePattern, JspMetadata meta) {
        Matcher matcher = thePattern.matcher(html);
        while (matcher.find()) {
            String matched = matcher.group(1);
            if (!StringUtils.isNotBlank((String)matched)) continue;
            Line lr = new Line();
            lr.setDescription("Deprecated jsp syntax: " + matched);
            lr.setLineNumber(Integer.valueOf(NewLineUtil.countNewLine(html, matcher.start())));
            lr.setPattern(matched);
            for (ResultProcessor hint : this.hints) {
                hint.process((AbstractDecoration)lr);
            }
            meta.getDecorations().add(lr);
        }
    }

    protected void findImports(String html, Pattern thePattern, JspMetadata meta) {
        Matcher matcher = thePattern.matcher(html);
        while (matcher.find()) {
            String[] imports;
            String matched = matcher.group(1);
            if (!StringUtils.isNotBlank((String)matched) || (imports = StringUtils.split((String)matched, (String)",")) == null) continue;
            for (String imp : imports) {
                if (this.lineContainsClassBlacklist(imp = StringUtils.trim((String)imp))) {
                    Line lr = new Line();
                    lr.setDescription("Blacklist: " + imp);
                    lr.setLineNumber(Integer.valueOf(NewLineUtil.countNewLine(html, matcher.start())));
                    lr.setPattern(imp);
                    for (ResultProcessor hint : this.hints) {
                        hint.process((AbstractDecoration)lr);
                    }
                    meta.getDecorations().add(lr);
                }
                meta.getClassDependencies().add(imp);
            }
        }
    }

    protected void findTaglib(String html, Pattern thePattern, JspMetadata meta) {
        Matcher matcher = thePattern.matcher(html);
        while (matcher.find()) {
            String matched = matcher.group(1);
            if (!StringUtils.isNotBlank((String)matched)) continue;
            if (this.lineContainsNamespaceBlacklist(matched)) {
                Line lr = new Line();
                lr.setDescription("Blacklist Namespace: " + matched);
                lr.setLineNumber(Integer.valueOf(NewLineUtil.countNewLine(html, matcher.start())));
                lr.setPattern(matched);
                for (ResultProcessor hint : this.hints) {
                    hint.process((AbstractDecoration)lr);
                }
                meta.getDecorations().add(lr);
            }
            meta.getTaglibDependencies().add(matched);
        }
    }

    public void setClassBlacklists(List<String> classBls) {
        if (classBls == null) {
            return;
        }
        this.classBlacklistPatterns = new HashSet<Pattern>(classBls.size());
        for (String classBlacklist : classBls) {
            if (!StringUtils.startsWith((String)classBlacklist, (String)"^")) {
                classBlacklist = "^" + classBlacklist;
            }
            this.classBlacklistPatterns.add(Pattern.compile(classBlacklist));
        }
    }

    public void setNamespaceBlacklists(List<String> namespaceBls) {
        if (namespaceBls == null) {
            return;
        }
        this.namespaceBlacklistPatterns = new HashSet<Pattern>(namespaceBls.size());
        for (String namespaceBlacklist : namespaceBls) {
            if (!StringUtils.startsWith((String)namespaceBlacklist, (String)"^")) {
                namespaceBlacklist = "^" + namespaceBlacklist;
            }
            this.namespaceBlacklistPatterns.add(Pattern.compile(namespaceBlacklist));
        }
    }

    private boolean lineContainsClassBlacklist(String line) {
        if (line == null) {
            return false;
        }
        for (Pattern black : this.classBlacklistPatterns) {
            if (!black.matcher(line).find()) continue;
            return true;
        }
        return false;
    }

    private boolean lineContainsNamespaceBlacklist(String line) {
        if (line == null) {
            return false;
        }
        for (Pattern black : this.namespaceBlacklistPatterns) {
            if (!black.matcher(line).find()) continue;
            return true;
        }
        return false;
    }
}

