/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decorator;

import java.util.LinkedList;
import java.util.List;
import org.jboss.windup.decorator.MetaDecorator;
import org.jboss.windup.hint.MatchingProcessor;
import org.jboss.windup.metadata.decoration.AbstractDecoration;
import org.jboss.windup.metadata.type.FileMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhitelistDecorator
implements MetaDecorator<FileMetadata> {
    private static final Logger LOG = LoggerFactory.getLogger(WhitelistDecorator.class);
    protected List<MatchingProcessor> whitelistProcessors;

    public void setWhitelistProcessors(List<MatchingProcessor> whitelistProcessors) {
        this.whitelistProcessors = whitelistProcessors;
    }

    @Override
    public void processMeta(FileMetadata file) {
        LinkedList<AbstractDecoration> retractList = new LinkedList<AbstractDecoration>();
        for (AbstractDecoration dr : file.getDecorations()) {
            for (MatchingProcessor hp : this.whitelistProcessors) {
                if (!hp.process(dr)) continue;
                retractList.add(dr);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retracting: " + retractList.size() + " decorations.");
        }
        for (AbstractDecoration dr : retractList) {
            boolean retracted = file.getDecorations().remove(dr);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Retracting: " + dr.toString() + " :: " + retracted);
        }
    }
}

