/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decorator.archive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.decorator.archive.ManifestVersionDecorator;
import org.jboss.windup.metadata.decoration.archetype.version.Version;
import org.jboss.windup.metadata.type.ManifestMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestVersionMapperDecorator
extends ManifestVersionDecorator {
    private static final Logger LOG = LoggerFactory.getLogger(ManifestVersionDecorator.class);
    private String matchName;
    private String matchVersion;
    private Map<String, Pattern> attributeNameToRegex = new HashMap<String, Pattern>(0);

    public void setMatchVersion(String matchVersion) {
        this.matchVersion = matchVersion;
    }

    public void setMatchName(String matchName) {
        this.matchName = matchName;
    }

    public void setAttributeNameToRegex(Map<String, Pattern> attributeNameToRegex) {
        this.attributeNameToRegex = attributeNameToRegex;
    }

    @Override
    public void processMeta(ManifestMetadata file) {
        if (this.matchesAll(file.getManifest())) {
            Version vr = new Version();
            if (StringUtils.isNotBlank((String)this.matchName)) {
                vr.setName(this.matchName);
            } else {
                String name = this.extractValue(file.getManifest(), this.namePriority);
                name = this.cleanseValue(name);
                vr.setName(name);
            }
            if (StringUtils.isNotBlank((String)this.matchVersion)) {
                vr.setVersion(this.matchVersion);
            } else {
                String version = this.extractValue(file.getManifest(), this.versionPriority);
                version = this.cleanseValue(version);
                vr.setVersion(version);
            }
            file.getArchiveMeta().getDecorations().add(vr);
        }
    }

    protected boolean matchesAll(Manifest mf) {
        boolean matched = false;
        matched = this.matchAttributes(mf.getMainAttributes());
        if (!matched) {
            ArrayList<String> attributeNames = new ArrayList<String>(mf.getEntries().keySet());
            Collections.sort(attributeNames);
            for (String attributeName : attributeNames) {
                matched = this.matchAttributes(mf.getAttributes(attributeName));
                if (!matched) continue;
                return true;
            }
        }
        return matched;
    }

    private boolean matchAttributes(Attributes attributes) {
        boolean matched = true;
        for (String key : this.attributeNameToRegex.keySet()) {
            String attrVal = attributes.getValue(key);
            if (attrVal == null) {
                return false;
            }
            matched = this.processPattern(this.attributeNameToRegex.get(key), attrVal);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Key[" + key + "] Found: " + attrVal + " trying to match: " + this.attributeNameToRegex.get(key) + " :: " + matched);
            }
            if (matched) continue;
            return false;
        }
        return matched;
    }

    protected boolean processPattern(Pattern pattern, String val) {
        if (pattern != null && val != null) {
            Matcher matcher = pattern.matcher(val);
            return matcher.find();
        }
        return false;
    }
}

