/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decorator.gate;

import java.util.Set;
import org.jboss.windup.decorator.gate.GateDecorator;
import org.jboss.windup.metadata.type.FileMetadata;
import org.jboss.windup.platform.PlatformType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformGateDecorator
extends GateDecorator<FileMetadata> {
    private static final Logger LOG = LoggerFactory.getLogger(PlatformGateDecorator.class);
    private PlatformType targetContainer = null;
    private Set<PlatformType> supportedContainers;

    public void setSupportedContainers(Set<PlatformType> supportedContainers) {
        this.supportedContainers = supportedContainers;
    }

    public void setTargetContainer(PlatformType targetContainer) {
        this.targetContainer = targetContainer;
    }

    @Override
    protected boolean continueProcessing(FileMetadata meta) {
        if (this.targetContainer == null) {
            LOG.debug("No target specified; run for all target containers.");
            return true;
        }
        for (PlatformType supported : this.supportedContainers) {
            if (!supported.is(this.targetContainer)) continue;
            return true;
        }
        return false;
    }
}

