/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decorator.gate;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.jboss.windup.decorator.gate.GateDecorator;
import org.jboss.windup.hint.ResultProcessor;
import org.jboss.windup.metadata.decoration.AbstractDecoration;
import org.jboss.windup.metadata.type.FileMetadata;

public class RegexPatternGateProcessor
extends GateDecorator<FileMetadata> {
    protected Pattern regexPattern;
    protected List<ResultProcessor> hints = new LinkedList<ResultProcessor>();

    public void setHints(List<ResultProcessor> hints) {
        this.hints = hints;
    }

    public void setRegexPattern(Pattern regexPattern) {
        this.regexPattern = regexPattern;
    }

    protected List<AbstractDecoration> matchResults(FileMetadata meta) {
        LinkedList<AbstractDecoration> results = new LinkedList<AbstractDecoration>();
        for (AbstractDecoration rst : meta.getDecorations()) {
            if (!this.regexPattern.matcher(rst.getPattern()).find()) continue;
            results.add(rst);
        }
        return results;
    }

    @Override
    protected boolean continueProcessing(FileMetadata meta) {
        List<AbstractDecoration> results = this.matchResults(meta);
        if (results != null && results.size() > 0) {
            if (this.hints != null) {
                for (ResultProcessor hintProcessor : this.hints) {
                    for (AbstractDecoration result : results) {
                        hintProcessor.process(result);
                    }
                }
            }
            return true;
        }
        return false;
    }
}

