/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decorator.gate;

import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.jboss.windup.decorator.gate.GateDecorator;
import org.jboss.windup.metadata.type.XmlMetadata;
import org.jboss.windup.metadata.util.NamespaceMapContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class XPathGateDecorator
extends GateDecorator<XmlMetadata>
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(XPathGateDecorator.class);
    private static final XPathFactory factory = XPathFactory.newInstance();
    protected XPath xpath;
    protected XPathExpression expression;
    protected Map<String, String> namespaces;
    protected String xpathExpression;

    public void setNamespaces(Map<String, String> namespaces) {
        this.namespaces = namespaces;
    }

    public void setXpathExpression(String xpathExpression) {
        this.xpathExpression = xpathExpression;
    }

    public void afterPropertiesSet() throws Exception {
        try {
            this.xpath = factory.newXPath();
            NamespaceMapContext context = new NamespaceMapContext(this.namespaces);
            this.xpath.setNamespaceContext((NamespaceContext)context);
            this.expression = this.xpath.compile(this.xpathExpression);
        }
        catch (Exception e) {
            LOG.error("Exception while setting XPath: " + this.xpathExpression, (Throwable)e);
            throw e;
        }
    }

    @Override
    protected boolean continueProcessing(XmlMetadata meta) {
        if (meta.getParsedDocument() == null) {
            LOG.warn("Skipping XPathClassifyingDecorator; no parsed doc: " + meta.getFilePointer().getAbsolutePath());
            return false;
        }
        try {
            Boolean nodes = (Boolean)this.expression.evaluate(meta.getParsedDocument(), XPathConstants.BOOLEAN);
            if (nodes != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Returning: " + nodes + " for XPath: " + this.xpathExpression + " on file: " + meta.getFilePointer().getAbsolutePath());
                }
                return nodes;
            }
        }
        catch (Exception e) {
            LOG.error("Exception running xpath.", (Throwable)e);
        }
        return false;
    }
}

